# Модуль оперативной памяти

![Не для идиотов.](item:tis3d:random_access_memory_module)

Модуль памяти с произвольным доступом (модуль RAM) позволяет хранить в общей сложности 256 значений для последующего извлечения. К каждому сохранённому значению можно обращаться по отдельности, отсюда и название. Обратите внимание, что в отличие от самого компьютера TIS-3D, который обладает впечатляющей поддержкой 16-битных значений, модуль RAM ограничен 8-битными значениями из-за высокой плотности хранения.

Модуль оперативной памяти следует простому протоколу для чтения и записи отдельных ячеек: сначала он считывает одно значение из любого из своих портов. Это значение определяет *адрес*, по которому будет выполняться операция чтения или записи. Предоставление значений, которые превышают 8-битную ширину, приведёт к неопределенному поведению. Будет ли указанный адрес записываться или считываться, определяется тем, какая из операций выполняется первой.
- Когда любой из портов модуля оперативной памяти завершает операцию чтения, считанное значение будет сохранено по адресу.
- Когда любой из портов модуля оперативной памяти завершает операцию записи, значение, хранящееся по адресу, будет передано.
После того, как адрес будет прочитан или записан, модуль оперативной памяти вернётся к чтению другого адреса, чтобы совершить следующую операцию чтения или записи.

Пример для чтения значения по адресу `8` в аккумулятор, предполагая, что модуль оперативной памяти находится на порту `LEFT` [модуля выполнения](execution_module.md):
`MOV 8 LEFT`
`MOV LEFT ACC`

Пример для записи значения по адресу `8`, тот же сценарий:
`MOV 8 LEFT`
`MOV 0x42 LEFT`