# Модуль таймера

![Чёрт возьми, самое время](item:tis3d:timer_module)

Модуль таймера использует высокоточный кварц, чтобы обеспечить согласованные и надёжно синхронизированные операции ожидания. Его аппаратное обеспечение работает на частоте 20 Гц, что означает, что один шаг таймера займёт ровно 50 миллисекунд. Таймер настраивается с использованием этих тактов.

Модуль таймера непрерывно считывает значения со всех четырёх своих портов. Когда значение считывается, внутреннее состояние таймера устанавливается на указанное значение и будет уменьшаться на единицу в каждом будущем такте, пока не достигнет нуля. Как только оно достигнет нуля, модуль таймера станет непрерывно записывать постоянное, специфичное для реализации значение на все четыре своих порта.

Поскольку модуль таймера записывает данные в свои порты только после истечения времени таймера, можно дождаться определенного времени, настроив таймер и затем попытавшись прочитать значение из него. В связи с тем, что порты ввода-вывода на компьютерах TIS-3D блокируются, это приостановит работу до истечения таймера.

Прерывание может быть реализовано посредством чтения [модуля выполнения](execution_module.md) из модуля таймера с использованием виртуального порта `ANY`, что позволяет параллельным программам завершать чтение, передавая значение этому [модулю выполнения](execution_module.md).

## Таблица преобразования времени
Для простоты мы предоставляем таблицу часто используемых времён для значения, которое должно настраивать модуль таймера на ожидание этого количества времени.

Полсекунды: 10
Одна секунда: 20
Пять секунд: 100
Десять секунд: 200
Одна минута: 1200
Пятнадцать минут: 18000
Полчаса: 36000

Максимальное значение таймера ограничено пропускной способностью портов в компьютерах TIS-3D, которая составляет 16 бит. Поэтому максимальное настраиваемое значение таймера равно 0xFFFF, что приводит к ожиданию 54 минут 36 секунд и 750 миллисекунд.
