/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import matteroverdrive.MatterOverdriveTab;
import matteroverdrive.commands.AndoidCommands;
import matteroverdrive.commands.MatterRegistryCommands;
import matteroverdrive.commands.QuestCommands;
import matteroverdrive.commands.SaveWorldToImage;
import matteroverdrive.commands.WorldGenCommands;
import matteroverdrive.compat.MatterOverdriveCompat;
import matteroverdrive.dialog.DialogRegistry;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.handler.AndroidStatRegistry;
import matteroverdrive.handler.BlockHandler;
import matteroverdrive.handler.BucketHandler;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.EntityHandler;
import matteroverdrive.handler.GuiHandler;
import matteroverdrive.handler.MatterRegistrationHandler;
import matteroverdrive.handler.MatterRegistry;
import matteroverdrive.handler.PlayerEventHandler;
import matteroverdrive.handler.TickHandler;
import matteroverdrive.handler.quest.Quests;
import matteroverdrive.imc.MOIMCHandler;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveDialogs;
import matteroverdrive.init.MatterOverdriveEnchantments;
import matteroverdrive.init.MatterOverdriveEntities;
import matteroverdrive.init.MatterOverdriveFluids;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.init.MatterOverdriveMatter;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.init.MatterOverdriveRecipes;
import matteroverdrive.init.MatterOverdriveWorld;
import matteroverdrive.matter_network.MatterNetworkRegistry;
import matteroverdrive.network.PacketPipeline;
import matteroverdrive.proxy.CommonProxy;
import matteroverdrive.util.AndroidPartsFactory;
import matteroverdrive.util.DialogFactory;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.QuestFactory;
import matteroverdrive.util.WeaponFactory;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="mo", name="MatterOverdrive: Community Edition", version="0.4.5", guiFactory="matteroverdrive.gui.GuiConfigFactory", dependencies="after:ThermalExpansion;after:exnihilo;after:EnderIO;")
public class MatterOverdrive {
    @SidedProxy(clientSide="matteroverdrive.proxy.ClientProxy", serverSide="matteroverdrive.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final MatterOverdriveTab tabMatterOverdrive;
    public static final MatterOverdriveTab tabMatterOverdrive_modules;
    public static final MatterOverdriveTab tabMatterOverdrive_upgrades;
    public static final MatterOverdriveTab tabMatterOverdrive_food;
    public static final MatterOverdriveTab tabMatterOverdrive_ships;
    public static final MatterOverdriveTab tabMatterOverdrive_buildings;
    public static final MatterOverdriveTab tabMatterOverdrive_decorative;
    public static TickHandler tickHandler;
    public static PlayerEventHandler playerEventHandler;
    public static ConfigurationHandler configHandler;
    public static GuiHandler guiHandler;
    public static PacketPipeline packetPipeline;
    public static BucketHandler bucketHandler;
    @Mod.Instance(value="mo")
    public static MatterOverdrive instance;
    public static MatterOverdriveWorld moWorld;
    public static EntityHandler entityHandler;
    public static MatterRegistry matterRegistry;
    public static AndroidStatRegistry statRegistry;
    public static DialogRegistry dialogRegistry;
    public static MatterRegistrationHandler matterRegistrationHandler;
    public static WeaponFactory weaponFactory;
    public static AndroidPartsFactory androidPartsFactory;
    public static Quests quests;
    public static QuestFactory questFactory;
    public static DialogFactory dialogFactory;
    public static BlockHandler blockHandler;
    public static final ExecutorService threadPool;
    public static MOLog log;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.checkJavaVersion();
        matterRegistry = new MatterRegistry();
        statRegistry = new AndroidStatRegistry();
        dialogRegistry = new DialogRegistry();
        guiHandler = new GuiHandler();
        packetPipeline = new PacketPipeline();
        entityHandler = new EntityHandler();
        configHandler = new ConfigurationHandler(new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "MatterOverdrive" + File.separator + "Matter Overdrive.cfg"));
        playerEventHandler = new PlayerEventHandler(configHandler);
        bucketHandler = new BucketHandler();
        matterRegistrationHandler = new MatterRegistrationHandler(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "MatterOverdrive" + File.separator + "Registry.matter");
        weaponFactory = new WeaponFactory();
        androidPartsFactory = new AndroidPartsFactory();
        quests = new Quests();
        questFactory = new QuestFactory();
        dialogFactory = new DialogFactory(dialogRegistry);
        blockHandler = new BlockHandler();
        FMLCommonHandler.instance().bus().register((Object)configHandler);
        tickHandler = new TickHandler(configHandler, playerEventHandler);
        FMLCommonHandler.instance().bus().register((Object)tickHandler);
        FMLCommonHandler.instance().bus().register((Object)playerEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)playerEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)bucketHandler);
        MinecraftForge.EVENT_BUS.register((Object)blockHandler);
        MatterOverdriveFluids.init(event);
        MatterOverdriveBlocks.init(event);
        MatterOverdriveItems.init(event);
        moWorld = new MatterOverdriveWorld(configHandler);
        MatterOverdriveEntities.init(event, configHandler);
        MatterOverdriveEnchantments.init(event, configHandler);
        moWorld.register();
        MatterNetworkRegistry.register();
        packetPipeline.registerPackets();
        MatterOverdriveBioticStats.init(event);
        matterRegistry.preInit(event, configHandler);
        this.UpdateTabs();
        proxy.registerCompatModules();
        MatterOverdriveCompat.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        guiHandler.register(event.getSide());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)entityHandler);
        proxy.init(event);
        configHandler.init();
        MatterOverdriveCompat.init(event);
        MatterOverdriveBlocks.register(event);
        MatterOverdriveItems.register(event);
        MatterOverdriveFluids.register(event);
        MatterOverdriveBioticStats.register(event);
        MatterOverdriveBioticStats.registerAll(configHandler, statRegistry);
        MatterOverdriveQuests.init(event);
        MatterOverdriveQuests.register(event, quests);
        MatterOverdriveDialogs.init(event, configHandler, dialogRegistry);
        MatterOverdriveRecipes.registerBlockRecipes(event);
        MatterOverdriveRecipes.registerItemRecipes(event);
        MatterOverdriveRecipes.registerInscriberRecipes(event);
        weaponFactory.initModules();
        weaponFactory.initWeapons();
        androidPartsFactory.initParts();
        AndroidPlayer.loadConfigs(configHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        MatterOverdriveCompat.postInit(event);
        MatterOverdriveEntities.register(event);
        MatterOverdriveItems.addToDungons();
        MatterOverdriveItems.addToMODungons();
        MatterOverdriveMatter.init(configHandler);
        MatterOverdriveMatter.registerBlacklistFromConfig(configHandler);
        MatterOverdriveMatter.registerFromConfig(configHandler);
        MatterOverdriveMatter.registerBasic(configHandler);
        configHandler.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new AndoidCommands());
        event.registerServerCommand((ICommand)new MatterRegistryCommands());
        event.registerServerCommand((ICommand)new QuestCommands());
        event.registerServerCommand((ICommand)new SaveWorldToImage());
        event.registerServerCommand((ICommand)new WorldGenCommands());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        matterRegistrationHandler.serverStart(event);
        tickHandler.onServerStart(event);
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        MOIMCHandler.imcCallback(event);
    }

    private void UpdateTabs() {
        MatterOverdrive.tabMatterOverdrive.item = MatterOverdriveItems.matter_scanner;
        MatterOverdrive.tabMatterOverdrive_modules.item = MatterOverdriveItems.weapon_module_color;
        MatterOverdrive.tabMatterOverdrive_upgrades.item = MatterOverdriveItems.item_upgrade;
        MatterOverdrive.tabMatterOverdrive_food.item = MatterOverdriveItems.earl_gray_tea;
        MatterOverdrive.tabMatterOverdrive_ships.item = MatterOverdriveItems.colonizerShip;
        MatterOverdrive.tabMatterOverdrive_buildings.item = MatterOverdriveItems.buildingBase;
        MatterOverdrive.tabMatterOverdrive_decorative.item = new ItemBlock((Block)MatterOverdriveBlocks.decorative_stripes);
    }

    private void checkJavaVersion() {
        String versionString = System.getProperty("java.version");
        int pos = versionString.indexOf(46);
        double version = Double.parseDouble(versionString.substring(0, pos = versionString.indexOf(46, pos + 1)));
        if (version < 1.8) {
            MOLog.warn("Matter Overdrive only supports Java 8 and above. Please update your Java version. You are currently using: " + version, new Object[0]);
        }
    }

    static {
        tabMatterOverdrive = new MatterOverdriveTab("tabMatterOverdrive");
        tabMatterOverdrive_modules = new MatterOverdriveTab("tabMatterOverdrive_modules");
        tabMatterOverdrive_upgrades = new MatterOverdriveTab("tabMatterOverdrive_upgrades");
        tabMatterOverdrive_food = new MatterOverdriveTab("tabMatterOverdrive_food");
        tabMatterOverdrive_ships = new MatterOverdriveTab("tabMatterOverdrive_ships");
        tabMatterOverdrive_buildings = new MatterOverdriveTab("tabMatterOverdrive_buildings");
        tabMatterOverdrive_decorative = new MatterOverdriveTab("tabMatterOverdrive_decorative");
        threadPool = Executors.newFixedThreadPool(2);
        log = new MOLog();
    }
}

