/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.animation;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.animation.AnimationSegment;
import matteroverdrive.util.math.MOMathHelper;

public class AnimationTimeline<T extends AnimationSegment> {
    boolean loopable;
    int time;
    int duration;
    List<T> segments = new ArrayList<T>();
    int lastSegmentBegin;

    public AnimationTimeline(boolean loopable, int duration) {
        this.loopable = loopable;
        this.duration = duration;
    }

    public double getPercent() {
        return (double)this.time / (double)this.duration;
    }

    public void addSegment(T segment) {
        this.segments.add(segment);
    }

    public void addSegmentSequential(T segment) {
        ((AnimationSegment)segment).begin = this.lastSegmentBegin;
        this.lastSegmentBegin += ((AnimationSegment)segment).length;
        this.segments.add(segment);
    }

    public T getCurrentSegment() {
        for (AnimationSegment segment : this.segments) {
            if (!MOMathHelper.animationInRange(this.time, segment.begin, segment.length)) continue;
            return (T)segment;
        }
        return null;
    }

    public void tick() {
        if (this.time < this.duration) {
            ++this.time;
        } else if (this.loopable) {
            this.time = 0;
        }
    }

    public void setTime(int time) {
        this.time = time;
    }
}

