/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.network;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.BlockPos;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public abstract class MatterNetworkTask {
    long id;
    String name;
    BlockPos senderPos;
    boolean isAlive;
    String unlocalizedName;
    MatterNetworkTaskState state = MatterNetworkTaskState.UNKNOWN;

    public MatterNetworkTask() {
        this.init();
    }

    public MatterNetworkTask(IMatterNetworkConnection sender) {
        this.setSender(sender);
        this.init();
    }

    protected void init() {
        this.id = UUID.randomUUID().getMostSignificantBits();
    }

    public boolean isValid(World world) {
        IMatterNetworkDispatcher dispatcher = this.getSender(world);
        return dispatcher != null;
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound != null) {
            this.senderPos = new BlockPos(compound);
            this.state = MatterNetworkTaskState.get(compound.func_74762_e("State"));
            this.isAlive = compound.func_74767_n("isAlive");
            this.id = compound.func_74763_f("id");
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        if (compound != null) {
            this.senderPos.writeToNBT(compound);
            compound.func_74768_a("State", this.state.ordinal());
            compound.func_74757_a("isAlive", this.isAlive);
            compound.func_74772_a("id", this.id);
        }
    }

    public void addInfo(List<String> list) {
        list.add(this.getColorForState(this.state) + "[ " + MOStringHelper.translateToLocal("task.state." + (Object)((Object)this.getState()) + ".name") + " ]");
        String unlocalizedDescription = "task." + this.getUnlocalizedName() + ".state." + (Object)((Object)this.state) + ".description";
        String[] infos = MOStringHelper.hasTranslation(unlocalizedDescription) ? MOStringHelper.translateToLocal(unlocalizedDescription).split("\n") : MOStringHelper.translateToLocal("task.state." + (Object)((Object)this.state) + ".description").split("\n");
        Collections.addAll(list, infos);
    }

    private EnumChatFormatting getColorForState(MatterNetworkTaskState state) {
        switch (state) {
            case WAITING: {
                return EnumChatFormatting.AQUA;
            }
            case QUEUED: {
                return EnumChatFormatting.BLUE;
            }
            case PROCESSING: {
                return EnumChatFormatting.YELLOW;
            }
            case FINISHED: {
                return EnumChatFormatting.GREEN;
            }
        }
        return EnumChatFormatting.GRAY;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public void setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public IMatterNetworkDispatcher getSender(World world) {
        TileEntity entity;
        if (world != null && this.senderPos != null && (entity = this.senderPos.getTileEntity(world)) instanceof IMatterNetworkDispatcher) {
            return (IMatterNetworkDispatcher)entity;
        }
        return null;
    }

    public void setSender(IMatterNetworkConnection sender) {
        this.senderPos = sender.getPosition();
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public long getId() {
        return this.id;
    }

    public MatterNetworkTaskState getState() {
        return this.state;
    }

    public void setState(MatterNetworkTaskState state) {
        this.state = state;
    }
}

