/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.transport;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class TransportLocation {
    public int x;
    public int y;
    public int z;
    public String name;

    public TransportLocation(int x, int y, int z, String name) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
    }

    public TransportLocation(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public TransportLocation(NBTTagCompound nbt) {
        if (nbt != null) {
            this.x = nbt.func_74762_e("tl_x");
            this.y = nbt.func_74762_e("tl_y");
            this.z = nbt.func_74762_e("tl_z");
            this.name = nbt.func_74779_i("tl_name");
        }
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("tl_x", this.x);
        nbtTagCompound.func_74768_a("tl_y", this.y);
        nbtTagCompound.func_74768_a("tl_z", this.z);
        nbtTagCompound.func_74778_a("tl_name", this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getDistance(int x1, int y1, int z1) {
        return (int)Math.round(Math.sqrt((this.x - x1) * (this.x - x1) + (this.y - y1) * (this.y - y1) + (this.z - z1) * (this.z - z1)));
    }
}

