/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.blocks.includes.IImageGenBlock;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.client.render.block.RendererBlockDecorativeVertical;
import matteroverdrive.items.DecorativeBlockItem;
import matteroverdrive.world.MOImageGen;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDecorative
extends MOBlock
implements IImageGenBlock {
    public static List<BlockDecorative> decorativeBlocks = new ArrayList<BlockDecorative>();
    public String[] iconNames;
    int mapColor;
    boolean rotated;
    boolean colored;
    IIcon[] icons;

    public BlockDecorative(Material material, String name, float hardness, int harvestLevel, float resistance, int mapColor, String[] iconNames) {
        super(material, name);
        this.func_149711_c(hardness);
        this.setHarvestLevel("pickaxe", harvestLevel);
        this.func_149752_b(resistance);
        this.func_149647_a(MatterOverdrive.tabMatterOverdrive_decorative);
        this.mapColor = mapColor;
        decorativeBlocks.add(this);
        MOImageGen.worldGenerationBlockColors.put(this, this.getBlockColor(0));
        this.iconNames = iconNames;
        this.setRotationType(-1);
    }

    @Override
    protected void registerBlock() {
        GameRegistry.registerBlock((Block)this, DecorativeBlockItem.class, (String)this.func_149739_a().substring(5));
    }

    public BlockDecorative(Material material, String name, String iconName, float hardness, int harvestLevel, float resistance, int mapColor) {
        this(material, name, hardness, harvestLevel, resistance, mapColor, new String[]{iconName, iconName, iconName, iconName, iconName, iconName});
    }

    @Override
    public void func_149689_a(World World2, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        World2.func_72921_c(x, y, z, item.func_77960_j(), 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_) {
        if (this.rotated) {
            p_149666_3_.add(new ItemStack(p_149666_1_, 1, 0));
            p_149666_3_.add(new ItemStack(p_149666_1_, 1, 1));
        } else if (this.colored) {
            for (int i = 0; i < 16; ++i) {
                p_149666_3_.add(new ItemStack(p_149666_1_, 1, i));
            }
        }
    }

    public BlockDecorative setRotated(boolean rotated) {
        this.rotated = rotated;
        return this;
    }

    public BlockDecorative setColored(boolean colored) {
        this.colored = colored;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.iconNames.length];
        for (int i = 0; i < this.iconNames.length; ++i) {
            boolean iconRepeat = false;
            for (int j = 0; j < this.iconNames.length; ++j) {
                if (!this.iconNames[j].equals(this.iconNames[i]) || this.icons[j] == null) continue;
                this.icons[i] = this.icons[j];
                iconRepeat = true;
                break;
            }
            if (iconRepeat) continue;
            this.icons[i] = iconRegister.func_94245_a("mo:" + this.iconNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        if (this.colored) {
            return ItemDye.field_150922_c[MathHelper.func_76125_a((int)meta, (int)0, (int)(ItemDye.field_150922_c.length - 1))];
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (this.colored) {
            int meta = world.func_72805_g(x, y, z);
            return ItemDye.field_150922_c[MathHelper.func_76125_a((int)meta, (int)0, (int)(ItemDye.field_150922_c.length - 1))];
        }
        return 0xFFFFFF;
    }

    public int func_149692_a(int meta) {
        return this.rotated || this.colored ? meta : 0;
    }

    public int func_149645_b() {
        return RendererBlockDecorativeVertical.renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[side];
    }

    @Override
    public int getBlockColor(int meta) {
        return this.mapColor;
    }

    public boolean canBeRotated() {
        return this.rotated;
    }

    public boolean isColored() {
        return this.colored;
    }
}

