/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks.includes;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.IMOTileEntity;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.MOBlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MOBlock
extends Block {
    private int rotationType;

    public MOBlock(Material material, String name) {
        super(material);
        this.func_149663_c(name);
        this.func_149658_d("mo:" + name);
        this.func_149647_a(MatterOverdrive.tabMatterOverdrive);
        this.rotationType = 1;
    }

    public void register() {
        this.registerBlock();
    }

    protected void registerBlock() {
        GameRegistry.registerBlock((Block)this, (String)this.func_149739_a().substring(5));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        IMOTileEntity tileEntity = (IMOTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            tileEntity.onAdded(world, x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z + 1, block);
        IMOTileEntity tileEntity = (IMOTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            tileEntity.onNeighborBlockChange();
        }
    }

    protected void setDefaultRotation(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, z, b0, 2);
        }
    }

    public void func_149689_a(World World2, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        int meta = MOBlockHelper.determineXZPlaceFacing(player);
        World2.func_72921_c(x, y, z, meta, 2);
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (this.rotationType >= 0) {
            int meta;
            int rotation = meta = worldObj.func_72805_g(x, y, z);
            if (this.rotationType == 1) {
                rotation = MOBlockHelper.SIDE_LEFT[meta % MOBlockHelper.SIDE_LEFT.length];
            } else if (this.rotationType == 2 && meta < 6) {
                rotation = (meta + 1) % 6;
            }
            worldObj.func_72921_c(x, y, z, rotation, 3);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (this.hasTileEntity(meta) && world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof MOTileEntity) {
            ((MOTileEntity)world.func_147438_o(x, y, z)).onDestroyed();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void setRotationType(int type) {
        this.rotationType = type;
    }
}

