/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroidStatRenderRegistry;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.api.inventory.IBionicPart;
import matteroverdrive.api.renderer.IBionicPartRenderer;
import matteroverdrive.api.renderer.IBioticStatRenderer;
import matteroverdrive.api.starmap.IStarmapRenderRegistry;
import matteroverdrive.client.model.ModelHulkingScientist;
import matteroverdrive.client.model.ModelTritaniumArmor;
import matteroverdrive.client.render.AndroidBionicPartRenderRegistry;
import matteroverdrive.client.render.AndroidStatRenderRegistry;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.client.render.RenderDialogSystem;
import matteroverdrive.client.render.RenderMatterScannerInfoHandler;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.client.render.RenderWeaponsBeam;
import matteroverdrive.client.render.StarmapRenderRegistry;
import matteroverdrive.client.render.WeaponModuleModelRegistry;
import matteroverdrive.client.render.biostat.BioticStatRendererShield;
import matteroverdrive.client.render.biostat.BioticStatRendererTeleporter;
import matteroverdrive.client.render.block.MOBlockRenderer;
import matteroverdrive.client.render.block.RendererBlockChargingStation;
import matteroverdrive.client.render.block.RendererBlockDecorativeVertical;
import matteroverdrive.client.render.block.RendererBlockGravitationalStabilizer;
import matteroverdrive.client.render.block.RendererBlockInscriber;
import matteroverdrive.client.render.block.RendererBlockPatternStorage;
import matteroverdrive.client.render.block.RendererBlockPipe;
import matteroverdrive.client.render.block.RendererBlockReplicator;
import matteroverdrive.client.render.block.RendererBlockTritaniumCrate;
import matteroverdrive.client.render.entity.EntityRendererFailedChicken;
import matteroverdrive.client.render.entity.EntityRendererFailedCow;
import matteroverdrive.client.render.entity.EntityRendererFailedPig;
import matteroverdrive.client.render.entity.EntityRendererFailedSheep;
import matteroverdrive.client.render.entity.EntityRendererMadScientist;
import matteroverdrive.client.render.entity.EntityRendererMutantScientist;
import matteroverdrive.client.render.entity.EntityRendererPhaserFire;
import matteroverdrive.client.render.entity.EntityRendererRangedRougeAndroid;
import matteroverdrive.client.render.entity.EntityRendererRougeAndroid;
import matteroverdrive.client.render.item.ItemRenderPlasmaShotgun;
import matteroverdrive.client.render.item.ItemRendererIonSniper;
import matteroverdrive.client.render.item.ItemRendererOmniTool;
import matteroverdrive.client.render.item.ItemRendererPhaser;
import matteroverdrive.client.render.item.ItemRendererPhaserRifle;
import matteroverdrive.client.render.parts.RougeAndroidPartsRender;
import matteroverdrive.client.render.parts.TritaniumSpineRenderer;
import matteroverdrive.client.render.tileentity.TileEntityRendererAndroidStation;
import matteroverdrive.client.render.tileentity.TileEntityRendererChargingStation;
import matteroverdrive.client.render.tileentity.TileEntityRendererContractMarket;
import matteroverdrive.client.render.tileentity.TileEntityRendererFusionReactorController;
import matteroverdrive.client.render.tileentity.TileEntityRendererGravitationalAnomaly;
import matteroverdrive.client.render.tileentity.TileEntityRendererGravitationalStabilizer;
import matteroverdrive.client.render.tileentity.TileEntityRendererHoloSign;
import matteroverdrive.client.render.tileentity.TileEntityRendererInscriber;
import matteroverdrive.client.render.tileentity.TileEntityRendererMatterPipe;
import matteroverdrive.client.render.tileentity.TileEntityRendererNetworkPipe;
import matteroverdrive.client.render.tileentity.TileEntityRendererPacketQueue;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatterStorage;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatternMonitor;
import matteroverdrive.client.render.tileentity.TileEntityRendererPipe;
import matteroverdrive.client.render.tileentity.TileEntityRendererReplicator;
import matteroverdrive.client.render.tileentity.TileEntityRendererStarMap;
import matteroverdrive.client.render.tileentity.TileEntityRendererWeaponStation;
import matteroverdrive.client.render.tileentity.starmap.StarMapRenderGalaxy;
import matteroverdrive.client.render.tileentity.starmap.StarMapRenderPlanetStats;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererPlanet;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererQuadrant;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStar;
import matteroverdrive.entity.EntityFailedChicken;
import matteroverdrive.entity.EntityFailedCow;
import matteroverdrive.entity.EntityFailedPig;
import matteroverdrive.entity.EntityFailedSheep;
import matteroverdrive.entity.EntityVillagerMadScientist;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityMutantScientist;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.android.RougeAndroidParts;
import matteroverdrive.items.android.TritaniumSpine;
import matteroverdrive.machines.fusionReactorController.TileEntityMachineFusionReactorController;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityAndroidStation;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.tile.TileEntityHoloSign;
import matteroverdrive.tile.TileEntityInscriber;
import matteroverdrive.tile.TileEntityMachineChargingStation;
import matteroverdrive.tile.TileEntityMachineContractMarket;
import matteroverdrive.tile.TileEntityMachineGravitationalStabilizer;
import matteroverdrive.tile.TileEntityMachinePacketQueue;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import matteroverdrive.tile.TileEntityMachinePatternStorage;
import matteroverdrive.tile.TileEntityMachineReplicator;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.tile.TileEntityWeaponStation;
import matteroverdrive.util.MOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.model.ModelCow;
import net.minecraft.client.model.ModelPig;
import net.minecraft.client.model.ModelSheep1;
import net.minecraft.client.model.ModelSheep2;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderHandler {
    private Random random = new Random();
    private RenderMatterScannerInfoHandler matterScannerInfoHandler;
    private RenderParticlesHandler renderParticlesHandler;
    private RenderWeaponsBeam renderWeaponsBeam;
    private List<IWorldLastRenderer> customRenderers = new ArrayList<IWorldLastRenderer>();
    private AndroidStatRenderRegistry statRenderRegistry;
    private StarmapRenderRegistry starmapRenderRegistry;
    private RenderDialogSystem renderDialogSystem;
    private AndroidBionicPartRenderRegistry bionicPartRenderRegistry;
    private WeaponModuleModelRegistry weaponModuleModelRegistry;
    private MOBlockRenderer blockRenderer;
    private RendererBlockGravitationalStabilizer rendererBlockGravitationalStabilizer;
    private RendererBlockPipe rendererBlockPipe;
    private RendererBlockChargingStation rendererBlockChargingStation;
    private RendererBlockPatternStorage rendererBlockPatternStorage;
    private RendererBlockReplicator rendererBlockReplicator;
    private RendererBlockTritaniumCrate rendererBlockTritaniumCrate;
    private RendererBlockInscriber rendererBlockInscriber;
    private RendererBlockDecorativeVertical rendererBlockDecorativeVertical;
    private BioticStatRendererTeleporter rendererTeleporter;
    private BioticStatRendererShield biostatRendererShield;
    private StarMapRendererPlanet starMapRendererPlanet;
    private StarMapRendererQuadrant starMapRendererQuadrant;
    private StarMapRendererStar starMapRendererStar;
    private StarMapRenderGalaxy starMapRenderGalaxy;
    private StarMapRenderPlanetStats starMapRenderPlanetStats;
    private static ItemRendererPhaser rendererPhaser;
    private static ItemRendererPhaserRifle rendererPhaserRifle;
    private static ItemRendererOmniTool rendererOmniTool;
    private static ItemRenderPlasmaShotgun renderPlasmaShotgun;
    private static ItemRendererIonSniper rendererIonSniper;
    private EntityRendererRougeAndroid rendererRougeAndroid;
    public EntityRendererRougeAndroid rendererRougeAndroidHologram;
    private EntityRendererMadScientist rendererMadScientist;
    private EntityRendererFailedCow rendererFailedCow;
    private EntityRendererFailedChicken rendererFailedChicken;
    private EntityRendererFailedPig rendererFailedPig;
    private EntityRendererFailedSheep rendererFailedSheep;
    private EntityRendererPhaserFire rendererPhaserFire;
    private EntityRendererRangedRougeAndroid rendererRangedRougeAndroid;
    private EntityRendererMutantScientist rendererMutantScientist;
    private TileEntityRendererReplicator tileEntityRendererReplicator;
    private TileEntityRendererPipe tileEntityRendererPipe;
    private TileEntityRendererMatterPipe tileEntityRendererMatterPipe;
    private TileEntityRendererNetworkPipe tileEntityRendererNetworkPipe;
    private TileEntityRendererPatterStorage tileEntityRendererPatterStorage;
    private TileEntityRendererWeaponStation tileEntityRendererWeaponStation;
    private TileEntityRendererPatternMonitor tileEntityRendererPatternMonitor;
    private TileEntityRendererGravitationalAnomaly tileEntityRendererGravitationalAnomaly;
    private TileEntityRendererGravitationalStabilizer tileEntityRendererGravitationalStabilizer;
    private TileEntityRendererFusionReactorController tileEntityRendererFusionReactorController;
    private TileEntityRendererAndroidStation tileEntityRendererAndroidStation;
    private TileEntityRendererStarMap tileEntityRendererStarMap;
    private TileEntityRendererChargingStation tileEntityRendererChargingStation;
    private TileEntityRendererHoloSign tileEntityRendererHoloSign;
    private TileEntityRendererPacketQueue tileEntityRendererPacketQueue;
    private TileEntityRendererInscriber tileEntityRendererInscriber;
    private TileEntityRendererContractMarket tileEntityRendererContractMarket;
    public ModelTritaniumArmor modelTritaniumArmor;
    public ModelTritaniumArmor modelTritaniumArmorFeet;
    public ModelBiped modelMeleeRogueAndroidParts;
    public ModelBiped modelRangedRogueAndroidParts;

    public RenderHandler(World world, TextureManager textureManager) {
        this.matterScannerInfoHandler = new RenderMatterScannerInfoHandler();
        this.renderParticlesHandler = new RenderParticlesHandler(world, textureManager);
        this.renderWeaponsBeam = new RenderWeaponsBeam();
        this.statRenderRegistry = new AndroidStatRenderRegistry();
        this.starmapRenderRegistry = new StarmapRenderRegistry();
        this.renderDialogSystem = new RenderDialogSystem();
        this.bionicPartRenderRegistry = new AndroidBionicPartRenderRegistry();
        this.weaponModuleModelRegistry = new WeaponModuleModelRegistry();
        this.addCustomRenderer(this.matterScannerInfoHandler);
        this.addCustomRenderer(this.renderParticlesHandler);
        this.addCustomRenderer(this.renderWeaponsBeam);
        this.addCustomRenderer(this.renderDialogSystem);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        for (IWorldLastRenderer renderer : this.customRenderers) {
            renderer.onRenderWorldLast(this, event);
        }
        for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
            Collection<IBioticStatRenderer> statRendererCollection = this.statRenderRegistry.getRendererCollection(stat.getClass());
            if (statRendererCollection == null) continue;
            for (IBioticStatRenderer renderer : statRendererCollection) {
                renderer.onWorldRender(stat, AndroidPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getUnlockedLevel(stat), event);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        this.renderParticlesHandler.onClientTick(event);
    }

    public void createTileEntityRenderers(ConfigurationHandler configHandler) {
        this.tileEntityRendererReplicator = new TileEntityRendererReplicator();
        this.tileEntityRendererPipe = new TileEntityRendererPipe();
        this.tileEntityRendererMatterPipe = new TileEntityRendererMatterPipe();
        this.tileEntityRendererNetworkPipe = new TileEntityRendererNetworkPipe();
        this.tileEntityRendererPatterStorage = new TileEntityRendererPatterStorage();
        this.tileEntityRendererWeaponStation = new TileEntityRendererWeaponStation();
        this.tileEntityRendererPatternMonitor = new TileEntityRendererPatternMonitor();
        this.tileEntityRendererGravitationalAnomaly = new TileEntityRendererGravitationalAnomaly();
        this.tileEntityRendererGravitationalStabilizer = new TileEntityRendererGravitationalStabilizer();
        this.tileEntityRendererFusionReactorController = new TileEntityRendererFusionReactorController();
        this.tileEntityRendererAndroidStation = new TileEntityRendererAndroidStation();
        this.tileEntityRendererStarMap = new TileEntityRendererStarMap();
        this.tileEntityRendererChargingStation = new TileEntityRendererChargingStation();
        this.tileEntityRendererHoloSign = new TileEntityRendererHoloSign();
        this.tileEntityRendererPacketQueue = new TileEntityRendererPacketQueue();
        this.tileEntityRendererInscriber = new TileEntityRendererInscriber();
        this.tileEntityRendererContractMarket = new TileEntityRendererContractMarket();
        configHandler.subscribe(this.tileEntityRendererAndroidStation);
        configHandler.subscribe(this.tileEntityRendererWeaponStation);
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        AndroidPlayer androidPlayer = AndroidPlayer.get(event.entityPlayer);
        if (androidPlayer != null && androidPlayer.isAndroid() && !event.entityPlayer.func_82150_aj()) {
            for (int i = 0; i < 5; ++i) {
                IBionicPartRenderer renderer;
                ItemStack part = androidPlayer.func_70301_a(i);
                if (part == null || !(part.func_77973_b() instanceof IBionicPart) || (renderer = this.bionicPartRenderRegistry.getRenderer(((IBionicPart)part.func_77973_b()).getClass())) == null) continue;
                try {
                    GL11.glPushMatrix();
                    renderer.renderPart(part, androidPlayer, event.renderer, event.partialRenderTick);
                    GL11.glPopMatrix();
                    continue;
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "An Error occurred while rendering bionic part", new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        AndroidPlayer androidPlayer = AndroidPlayer.get(event.entityPlayer);
        if (androidPlayer != null && androidPlayer.isAndroid() && !event.entityPlayer.func_82150_aj()) {
            for (int i = 0; i < 5; ++i) {
                IBionicPartRenderer renderer;
                ItemStack part = androidPlayer.func_70301_a(i);
                if (part == null || !(part.func_77973_b() instanceof IBionicPart) || (renderer = this.bionicPartRenderRegistry.getRenderer(((IBionicPart)part.func_77973_b()).getClass())) == null) continue;
                renderer.affectPlayerRenderer(part, androidPlayer, event.renderer, event.partialRenderTick);
            }
        }
    }

    public void createBlockRenderers() {
        this.blockRenderer = new MOBlockRenderer();
        this.rendererBlockGravitationalStabilizer = new RendererBlockGravitationalStabilizer();
        this.rendererBlockPipe = new RendererBlockPipe();
        this.rendererBlockChargingStation = new RendererBlockChargingStation();
        this.rendererBlockPatternStorage = new RendererBlockPatternStorage();
        this.rendererBlockReplicator = new RendererBlockReplicator();
        this.rendererBlockTritaniumCrate = new RendererBlockTritaniumCrate();
        this.rendererBlockInscriber = new RendererBlockInscriber();
        this.rendererBlockDecorativeVertical = new RendererBlockDecorativeVertical();
    }

    public void registerBlockRenderers() {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.blockRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockGravitationalStabilizer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockPipe);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockChargingStation);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockPatternStorage);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockReplicator);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockTritaniumCrate);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockInscriber);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.rendererBlockDecorativeVertical);
    }

    public void registerTileEntitySpecialRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineReplicator.class, (TileEntitySpecialRenderer)this.tileEntityRendererReplicator);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachinePatternStorage.class, (TileEntitySpecialRenderer)this.tileEntityRendererPatterStorage);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWeaponStation.class, (TileEntitySpecialRenderer)this.tileEntityRendererWeaponStation);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachinePatternMonitor.class, (TileEntitySpecialRenderer)this.tileEntityRendererPatternMonitor);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGravitationalAnomaly.class, (TileEntitySpecialRenderer)this.tileEntityRendererGravitationalAnomaly);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineGravitationalStabilizer.class, (TileEntitySpecialRenderer)this.tileEntityRendererGravitationalStabilizer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineFusionReactorController.class, (TileEntitySpecialRenderer)this.tileEntityRendererFusionReactorController);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAndroidStation.class, (TileEntitySpecialRenderer)this.tileEntityRendererAndroidStation);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineStarMap.class, (TileEntitySpecialRenderer)this.tileEntityRendererStarMap);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineChargingStation.class, (TileEntitySpecialRenderer)this.tileEntityRendererChargingStation);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHoloSign.class, (TileEntitySpecialRenderer)this.tileEntityRendererHoloSign);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachinePacketQueue.class, (TileEntitySpecialRenderer)this.tileEntityRendererPacketQueue);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInscriber.class, (TileEntitySpecialRenderer)this.tileEntityRendererInscriber);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineContractMarket.class, (TileEntitySpecialRenderer)this.tileEntityRendererContractMarket);
    }

    public void createItemRenderers() {
        rendererPhaser = new ItemRendererPhaser();
        rendererPhaserRifle = new ItemRendererPhaserRifle();
        rendererOmniTool = new ItemRendererOmniTool();
        renderPlasmaShotgun = new ItemRenderPlasmaShotgun();
        rendererIonSniper = new ItemRendererIonSniper();
    }

    public void registerItemRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)MatterOverdriveItems.phaser, (IItemRenderer)rendererPhaser);
        MinecraftForgeClient.registerItemRenderer((Item)MatterOverdriveItems.phaserRifle, (IItemRenderer)rendererPhaserRifle);
        MinecraftForgeClient.registerItemRenderer((Item)MatterOverdriveItems.omniTool, (IItemRenderer)rendererOmniTool);
        MinecraftForgeClient.registerItemRenderer((Item)MatterOverdriveItems.plasmaShotgun, (IItemRenderer)renderPlasmaShotgun);
        MinecraftForgeClient.registerItemRenderer((Item)MatterOverdriveItems.ionSniper, (IItemRenderer)rendererIonSniper);
    }

    public void createEntityRenderers() {
        this.rendererRougeAndroid = new EntityRendererRougeAndroid(new ModelBiped(), 0.0f, false);
        this.rendererMadScientist = new EntityRendererMadScientist();
        this.rendererFailedPig = new EntityRendererFailedPig((ModelBase)new ModelPig(), (ModelBase)new ModelPig(0.5f), 0.7f);
        this.rendererFailedCow = new EntityRendererFailedCow((ModelBase)new ModelCow(), 0.7f);
        this.rendererFailedChicken = new EntityRendererFailedChicken((ModelBase)new ModelChicken(), 0.3f);
        this.rendererFailedSheep = new EntityRendererFailedSheep((ModelBase)new ModelSheep2(), (ModelBase)new ModelSheep1(), 0.7f);
        this.rendererPhaserFire = new EntityRendererPhaserFire();
        this.rendererRangedRougeAndroid = new EntityRendererRangedRougeAndroid(0.0f);
        this.rendererRougeAndroidHologram = new EntityRendererRougeAndroid(new ModelBiped(), 0.0f, true);
        this.rendererMutantScientist = new EntityRendererMutantScientist(new ModelHulkingScientist(), 0.0f, 1.0f);
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityMeleeRougeAndroidMob.class, (Render)this.rendererRougeAndroid);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedPig.class, (Render)this.rendererFailedPig);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedCow.class, (Render)this.rendererFailedCow);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedChicken.class, (Render)this.rendererFailedChicken);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedSheep.class, (Render)this.rendererFailedSheep);
        RenderingRegistry.registerEntityRenderingHandler(EntityVillagerMadScientist.class, (Render)this.rendererMadScientist);
        RenderingRegistry.registerEntityRenderingHandler(PlasmaBolt.class, (Render)this.rendererPhaserFire);
        RenderingRegistry.registerEntityRenderingHandler(EntityRangedRogueAndroidMob.class, (Render)this.rendererRangedRougeAndroid);
        RenderingRegistry.registerEntityRenderingHandler(EntityMutantScientist.class, (Render)this.rendererMutantScientist);
    }

    public void createBioticStatRenderers() {
        this.rendererTeleporter = new BioticStatRendererTeleporter();
        this.biostatRendererShield = new BioticStatRendererShield();
    }

    public void registerBioticStatRenderers() {
        this.statRenderRegistry.registerRenderer(MatterOverdriveBioticStats.shield.getClass(), this.biostatRendererShield);
        this.statRenderRegistry.registerRenderer(MatterOverdriveBioticStats.teleport.getClass(), this.rendererTeleporter);
    }

    public void registerBionicPartRenderers() {
        this.bionicPartRenderRegistry.register(TritaniumSpine.class, new TritaniumSpineRenderer());
        this.bionicPartRenderRegistry.register(RougeAndroidParts.class, new RougeAndroidPartsRender());
    }

    public void registerWeaponModuleModels() {
        this.weaponModuleModelRegistry.registerModule(MatterOverdriveItems.sniperScope);
    }

    public void createStarmapRenderers() {
        this.starMapRendererPlanet = new StarMapRendererPlanet();
        this.starMapRendererQuadrant = new StarMapRendererQuadrant();
        this.starMapRendererStar = new StarMapRendererStar();
        this.starMapRenderGalaxy = new StarMapRenderGalaxy();
        this.starMapRenderPlanetStats = new StarMapRenderPlanetStats();
    }

    public void registerStarmapRenderers() {
        this.starmapRenderRegistry.registerRenderer(Planet.class, this.starMapRendererPlanet);
        this.starmapRenderRegistry.registerRenderer(Quadrant.class, this.starMapRendererQuadrant);
        this.starmapRenderRegistry.registerRenderer(Star.class, this.starMapRendererStar);
        this.starmapRenderRegistry.registerRenderer(Galaxy.class, this.starMapRenderGalaxy);
        this.starmapRenderRegistry.registerRenderer(Planet.class, this.starMapRenderPlanetStats);
    }

    public void createModels() {
        this.modelTritaniumArmor = new ModelTritaniumArmor(0.0f);
        this.modelTritaniumArmorFeet = new ModelTritaniumArmor(0.5f);
        this.modelMeleeRogueAndroidParts = new ModelBiped(0.0f);
        this.modelRangedRogueAndroidParts = new ModelBiped(0.0f, 0.0f, 96, 64);
    }

    public RenderParticlesHandler getRenderParticlesHandler() {
        return this.renderParticlesHandler;
    }

    public TileEntityRendererStarMap getTileEntityRendererStarMap() {
        return this.tileEntityRendererStarMap;
    }

    public IAndroidStatRenderRegistry getStatRenderRegistry() {
        return this.statRenderRegistry;
    }

    public IStarmapRenderRegistry getStarmapRenderRegistry() {
        return this.starmapRenderRegistry;
    }

    public ItemRendererOmniTool getRendererOmniTool() {
        return rendererOmniTool;
    }

    public AndroidBionicPartRenderRegistry getBionicPartRenderRegistry() {
        return this.bionicPartRenderRegistry;
    }

    public WeaponModuleModelRegistry getWeaponModuleModelRegistry() {
        return this.weaponModuleModelRegistry;
    }

    public Random getRandom() {
        return this.random;
    }

    public void addCustomRenderer(IWorldLastRenderer renderer) {
        this.customRenderers.add(renderer);
    }
}

