/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class RenderBeam<T extends EntityLivingBase>
implements IWorldLastRenderer {
    protected final Random random = new Random();

    protected abstract boolean shouldRenderBeam(T var1);

    protected abstract void onBeamRaycastHit(MovingObjectPosition var1, T var2);

    protected abstract void onBeamRender(T var1);

    protected abstract Color getBeamColor(T var1);

    protected abstract ResourceLocation getBeamTexture(T var1);

    protected abstract float getBeamMaxDistance(T var1);

    protected abstract float getBeamThickness(T var1);

    protected boolean renderRaycastedBeam(Vec3 direction, Vec3 offset, T caster) {
        return this.renderRaycastedBeam(caster.func_70666_h(1.0f), direction, offset, caster);
    }

    protected boolean renderRaycastedBeam(Vec3 position, Vec3 direction, Vec3 offset, T caster) {
        double maxDistance = this.getBeamMaxDistance(caster);
        MovingObjectPosition hit = MOPhysicsHelper.rayTrace(position, ((EntityLivingBase)caster).field_70170_p, maxDistance, 0.0f, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), false, true, direction, caster);
        if (hit != null && hit.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
            this.renderBeam(position, hit.field_72307_f, offset, this.getBeamColor(caster), this.getBeamTexture(caster), this.getBeamThickness(caster), caster);
            this.onBeamRender(caster);
            this.onBeamRaycastHit(hit, caster);
            return true;
        }
        this.renderBeam(position, position.func_72441_c(direction.field_72450_a * maxDistance, direction.field_72448_b * maxDistance, direction.field_72449_c * maxDistance), offset, this.getBeamColor(caster), this.getBeamTexture(caster), this.getBeamThickness(caster), caster);
        this.onBeamRender(caster);
        return false;
    }

    protected void renderBeam(Vec3 from, Vec3 to, Vec3 offest, Color color, ResourceLocation texture, float tickness, T viewer) {
        if (texture != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        }
        RenderUtils.applyColor(color);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        double distance = from.func_72444_a(to).func_72433_c();
        double v = (double)(-((EntityLivingBase)viewer).field_70170_p.func_72820_D()) * 0.2;
        GL11.glPushMatrix();
        GL11.glTranslated((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c);
        GL11.glRotated((double)(-viewer.func_70079_am()), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)((EntityLivingBase)viewer).field_70125_A, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)offest.field_72450_a, (double)offest.field_72448_b, (double)offest.field_72449_c);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a((double)tickness, 0.0, 0.0, 0.0, v);
        t.func_78374_a((double)tickness, 0.0, distance, 0.0, v + distance * 1.5);
        t.func_78374_a((double)(-tickness), 0.0, distance, 1.0, v + distance * 1.5);
        t.func_78374_a((double)(-tickness), 0.0, 0.0, 1.0, v);
        t.func_78374_a(0.0, (double)tickness, 0.0, 0.0, v);
        t.func_78374_a(0.0, (double)tickness, distance, 0.0, v + distance * 1.5);
        t.func_78374_a(0.0, (double)(-tickness), distance, 1.0, v + distance * 1.5);
        t.func_78374_a(0.0, (double)(-tickness), 0.0, 1.0, v);
        t.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }
}

