/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.RenderBeam;
import matteroverdrive.client.render.tileentity.TileEntityRendererStation;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.items.weapon.OmniTool;
import matteroverdrive.items.weapon.Phaser;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderWeaponsBeam
extends RenderBeam<EntityPlayer> {
    Map<Entity, WeaponSound> soundMap = new HashMap<Entity, WeaponSound>();
    public static ResourceLocation beamTexture = new ResourceLocation("mo:textures/fx/plasmabeam.png");
    public static ResourceLocation xbeam = new ResourceLocation("mo:textures/fx/xbeam.png");

    @Override
    public void onRenderWorldLast(RenderHandler renderHandler, RenderWorldLastEvent event) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-Minecraft.func_71410_x().field_71439_g.field_70165_t), (double)(-Minecraft.func_71410_x().field_71439_g.field_70163_u), (double)(-Minecraft.func_71410_x().field_71439_g.field_70161_v));
        this.renderClient(renderHandler, event.partialTicks);
        this.renderOthers(renderHandler, event.partialTicks);
        GL11.glPopMatrix();
    }

    public void renderOthers(RenderHandler renderHandler, float ticks) {
        Minecraft.func_71410_x().field_71441_e.func_72910_y().stream().filter(o -> o instanceof EntityPlayer).filter(player -> !player.equals(Minecraft.func_71410_x().field_71439_g)).forEach(o -> {
            EntityPlayer player = (EntityPlayer)o;
            if (this.shouldRenderBeam(player)) {
                this.renderRaycastedBeam(player.func_70666_h(ticks).func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_70676_i(0.0f), Vec3.func_72443_a((double)-0.5, (double)-0.3, (double)1.0), player);
            } else {
                this.stopWeaponSound(player);
            }
        });
    }

    public void renderClient(RenderHandler renderHandler, float ticks) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.shouldRenderBeam((EntityPlayer)player)) {
            Vec3 pos = player.func_70666_h(1.0f);
            Vec3 look = player.func_70676_i(0.0f);
            this.renderRaycastedBeam(pos, look, Vec3.func_72443_a((double)-0.1, (double)-0.1, (double)0.15), player);
        } else {
            this.stopWeaponSound((EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playWeaponSound(EntityPlayer player, Random random) {
        if (!this.soundMap.containsKey(player)) {
            ItemStack weaponStack = player.func_71011_bu();
            if (weaponStack != null && weaponStack.func_77973_b() instanceof IWeapon) {
                WeaponSound sound = ((IWeapon)weaponStack.func_77973_b()).getFireSound(weaponStack, (EntityLivingBase)player);
                this.soundMap.put((Entity)player, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
        } else if (this.soundMap.get(player).func_147667_k()) {
            this.stopWeaponSound(player);
            this.playWeaponSound(player, random);
        } else {
            this.soundMap.get(player).setPosition((float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
        }
    }

    private void stopWeaponSound(EntityPlayer entity) {
        if (this.soundMap.containsKey(entity)) {
            WeaponSound sound = this.soundMap.get(entity);
            sound.stopPlaying();
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
            this.soundMap.remove(entity);
        }
    }

    @Override
    protected boolean shouldRenderBeam(EntityPlayer entity) {
        return entity.func_71039_bw() && (entity.func_71011_bu().func_77973_b() instanceof Phaser || entity.func_71011_bu().func_77973_b() instanceof OmniTool);
    }

    @Override
    protected void onBeamRaycastHit(MovingObjectPosition hit, EntityPlayer caster) {
        ItemStack weaponStack = caster.func_71011_bu();
        if (weaponStack != null && weaponStack.func_77973_b() instanceof EnergyWeapon) {
            ((EnergyWeapon)weaponStack.func_77973_b()).onProjectileHit(hit, weaponStack, caster.field_70170_p, 1.0f);
            if (weaponStack.func_77973_b() instanceof OmniTool && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                GL11.glPushMatrix();
                RenderUtils.applyColorWithMultipy(this.getBeamColor(caster), 0.5f + (float)(1.0 + Math.sin((float)caster.field_70170_p.func_72820_D() * 0.5f)) * 0.5f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TileEntityRendererStation.glowTexture);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2884);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                ForgeDirection side = ForgeDirection.getOrientation((int)hit.field_72310_e);
                GL11.glTranslated((double)((double)hit.field_72311_b + 0.5), (double)((double)hit.field_72312_c + 0.5), (double)((double)hit.field_72309_d + 0.5));
                GL11.glTranslated((double)((double)side.offsetX * 0.5), (double)((double)side.offsetY * 0.5), (double)((double)side.offsetZ * 0.5));
                if (side == ForgeDirection.SOUTH) {
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                } else if (side == ForgeDirection.NORTH) {
                    GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
                } else if (side == ForgeDirection.EAST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)-1.0);
                } else if (side == ForgeDirection.WEST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                } else if (side == ForgeDirection.DOWN) {
                    GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                }
                GL11.glScaled((double)1.0, (double)(1.5 + Math.sin((double)caster.field_70170_p.func_72820_D() * 0.5) * 0.5), (double)1.0);
                ClientProxy.renderHandler.getRendererOmniTool().getModel().renderPart("dig_effect");
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2884);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    protected void onBeamRender(EntityPlayer caster) {
        this.playWeaponSound(caster, this.random);
    }

    @Override
    protected Color getBeamColor(EntityPlayer caster) {
        return new Color(WeaponHelper.getColor(caster.func_71011_bu()));
    }

    @Override
    protected ResourceLocation getBeamTexture(EntityPlayer caster) {
        ItemStack weaponStack = caster.func_71011_bu();
        if (weaponStack != null && weaponStack.func_77973_b() instanceof IWeapon) {
            if (weaponStack.func_77973_b() instanceof Phaser) {
                return beamTexture;
            }
            if (weaponStack.func_77973_b() instanceof OmniTool) {
                return beamTexture;
            }
        }
        return null;
    }

    @Override
    protected float getBeamMaxDistance(EntityPlayer caster) {
        int range = 18;
        ItemStack weaponStack = caster.func_71011_bu();
        if (weaponStack != null && weaponStack.func_77973_b() instanceof IWeapon) {
            range = ((IWeapon)weaponStack.func_77973_b()).getRange(weaponStack);
        }
        return range;
    }

    @Override
    protected float getBeamThickness(EntityPlayer caster) {
        ItemStack weaponStack = caster.func_71011_bu();
        if (weaponStack != null && weaponStack.func_77973_b() instanceof IWeapon) {
            if (weaponStack.func_77973_b() instanceof Phaser) {
                return 0.03f;
            }
            if (weaponStack.func_77973_b() instanceof OmniTool) {
                return 0.07f;
            }
        }
        return 0.05f;
    }
}

