/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.conversation;

import java.util.Random;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.renderer.IDialogShot;
import matteroverdrive.client.render.conversation.DialogShot;
import matteroverdrive.client.render.entity.EntityFakePlayer;
import matteroverdrive.gui.GuiDialog;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityRendererConversation
extends EntityRenderer {
    EntityFakePlayer fakePlayer;
    Minecraft field_78531_r;
    Random field_78537_ab;

    public EntityRendererConversation(Minecraft minecraft, IResourceManager resourceManager) {
        super(minecraft, resourceManager);
        this.field_78531_r = minecraft;
        this.field_78537_ab = new Random();
    }

    public void func_78471_a(float ticks, long time) {
        if (this.fakePlayer == null) {
            this.fakePlayer = new EntityFakePlayer((World)this.field_78531_r.field_71441_e, this.field_78531_r.field_71439_g.func_146103_bH());
        }
        boolean lastHideGui = this.field_78531_r.field_71474_y.field_74319_N;
        EntityLivingBase lastRenderViewEntity = this.field_78531_r.field_71451_h;
        if (this.field_78531_r.field_71462_r instanceof GuiDialog) {
            this.field_78531_r.field_71474_y.field_74319_N = true;
            this.field_78531_r.field_71451_h = this.fakePlayer;
            GuiDialog guiDialog = (GuiDialog)this.field_78531_r.field_71462_r;
            IDialogMessage message = guiDialog.getCurrentMessage();
            if (message != null) {
                this.field_78537_ab.setSeed(guiDialog.getSeed());
                IDialogShot[] shots = message.getShots(guiDialog.getNpc(), (EntityPlayer)this.field_78531_r.field_71439_g);
                if (shots != null && shots.length > 0) {
                    shots[this.field_78537_ab.nextInt(shots.length)].positionCamera((EntityLivingBase)guiDialog.getNpc().getEntity(), (EntityLivingBase)this.field_78531_r.field_71439_g, ticks, this);
                } else {
                    DialogShot.wideNormal.positionCamera((EntityLivingBase)guiDialog.getNpc().getEntity(), (EntityLivingBase)this.field_78531_r.field_71439_g, ticks, this);
                }
            }
            this.updateFakePlayerPositions();
        }
        super.func_78471_a(ticks, time);
        this.field_78531_r.field_71451_h = lastRenderViewEntity;
        this.field_78531_r.field_71474_y.field_74319_N = lastHideGui;
    }

    public Vec3 getLook(EntityLivingBase active, EntityLivingBase other, float ticks) {
        return this.getPosition(other, ticks, false).func_72444_a(this.getPosition(active, ticks, false));
    }

    public Vec3 getPosition(EntityLivingBase entityLivingBase, float ticks, boolean includeHeight) {
        Vec3 pos = entityLivingBase.func_70666_h(ticks);
        if (includeHeight) {
            pos.func_72441_c(0.0, (double)entityLivingBase.func_70047_e(), 0.0);
        }
        return pos;
    }

    public void rotateCameraYawTo(Vec3 dir, float offset) {
        double yaw = Math.acos(Vec3.func_72443_a((double)-1.0, (double)0.0, (double)0.0).func_72430_b(dir));
        Vec3 cross = Vec3.func_72443_a((double)-1.0, (double)0.0, (double)0.0).func_72431_c(dir);
        Vec3 up = Vec3.func_72443_a((double)0.0, (double)-1.0, (double)0.0);
        if (up.func_72430_b(cross) < 0.0) {
            yaw = -yaw;
        }
        yaw = Math.PI + yaw;
        this.setCameraYaw((float)Math.toDegrees(yaw) + offset);
    }

    private void rotatePitchToDir(Vec3 dir, float yaw, float offset) {
        this.setCameraPitch((float)Math.asin(Math.sqrt(dir.field_72450_a * dir.field_72450_a + dir.field_72448_b * dir.field_72448_b) / dir.field_72449_c) + offset);
    }

    public void setCameraPosition(double x, double y, double z) {
        this.fakePlayer.field_70165_t = x;
        this.fakePlayer.field_70163_u = y;
        this.fakePlayer.field_70161_v = z;
    }

    public void setCameraPosition(Vec3 position) {
        this.fakePlayer.field_70165_t = position.field_72450_a;
        this.fakePlayer.field_70163_u = position.field_72448_b;
        this.fakePlayer.field_70161_v = position.field_72449_c;
    }

    public void setCameraYaw(float angle) {
        this.fakePlayer.field_70177_z = angle;
    }

    public void setCameraPitch(float angle) {
        this.fakePlayer.field_70125_A = angle;
    }

    public void setCameraPositionSmooth(float angle, float speed) {
        this.fakePlayer.field_70125_A = MOMathHelper.Lerp(this.fakePlayer.field_70125_A, angle, speed);
    }

    private void updateFakePlayerPositions() {
        this.fakePlayer.field_70169_q = this.fakePlayer.field_70142_S = this.fakePlayer.field_70165_t;
        this.fakePlayer.field_70167_r = this.fakePlayer.field_70137_T = this.fakePlayer.field_70163_u;
        this.fakePlayer.field_70166_s = this.fakePlayer.field_70136_U = this.fakePlayer.field_70161_v;
        this.fakePlayer.field_70127_C = this.fakePlayer.field_70125_A;
        this.fakePlayer.field_70126_B = this.fakePlayer.field_70177_z;
        this.fakePlayer.field_70758_at = this.fakePlayer.field_70759_as;
    }
}

