/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.item;

import java.util.Random;
import matteroverdrive.client.render.item.WeaponItemRenderer;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class ItemRendererOmniTool
extends WeaponItemRenderer {
    public static final String TEXTURE = "mo:textures/items/wielder.png";
    public static final String MODEL = "mo:models/item/wielder.obj";
    public static final float SCALE = 7.0f;
    public static final float THIRD_PERSON_SCALE = 3.0f;
    public static final float ITEM_SCALE = 3.0f;
    public static final float SCALE_DROP = 2.5f;
    private Random random = new Random();

    public ItemRendererOmniTool() {
        super(new ResourceLocation(MODEL), new ResourceLocation(TEXTURE));
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderFirstPerson(item);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderItem(item);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderDrop(item);
        } else {
            this.renderThirdPerson(type, item);
        }
    }

    void renderItem(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.25);
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        this.renderGun(IItemRenderer.ItemRenderType.INVENTORY, item);
        GL11.glPopMatrix();
    }

    void renderThirdPerson(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
        GL11.glTranslated((double)0.3, (double)0.3, (double)0.3);
        GL11.glRotated((double)60.0, (double)-1.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)40.0, (double)0.0, (double)1.0, (double)0.0);
        this.renderGun(renderType, item);
        GL11.glPopMatrix();
    }

    void renderDrop(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)2.5, (double)2.5, (double)2.5);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)15.0, (double)1.0, (double)0.0, (double)0.0);
        this.renderGun(IItemRenderer.ItemRenderType.ENTITY, item);
        GL11.glPopMatrix();
    }

    void renderFirstPerson(ItemStack item) {
        GL11.glPushMatrix();
        float recoilValue = MOEasing.Quad.easeInOut(this.getRecoilTime(), 0.0f, 1.0f, 1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(recoilValue * 0.01f * this.getRecoilAmount()));
        GL11.glRotated((double)(recoilValue * 2.0f * this.getRecoilAmount()), (double)1.0, (double)0.0, (double)0.0);
        Minecraft.func_71410_x().field_71451_h.field_70125_A = (float)((double)Minecraft.func_71410_x().field_71451_h.field_70125_A + ((double)recoilValue * this.random.nextGaussian() * (double)0.03f - (double)(recoilValue * 0.02f)));
        Minecraft.func_71410_x().field_71451_h.field_70177_z = (float)((double)Minecraft.func_71410_x().field_71451_h.field_70177_z + (double)(recoilValue * 0.02f) * this.random.nextGaussian());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderHand();
        GL11.glPushMatrix();
        GL11.glScaled((double)7.0, (double)7.0, (double)7.0);
        if (Minecraft.func_71410_x().field_71439_g.func_71039_bw()) {
            GL11.glTranslated((double)0.15, (double)0.03, (double)-0.0);
            GL11.glRotated((double)35.0, (double)0.0, (double)-1.0, (double)0.0);
            GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)1.0, (double)1.0, (double)0.7);
        } else {
            GL11.glTranslated((double)0.15, (double)0.03, (double)-0.0);
            GL11.glRotated((double)40.0, (double)0.0, (double)-1.0, (double)0.0);
            GL11.glRotated((double)5.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)1.0, (double)1.0, (double)0.7);
        }
        this.renderGun(IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON, item);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    void renderGun(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        GL11.glEnable((int)2977);
        this.bindTexture(this.weaponTexture);
        this.weaponModel.renderOnly(new String[]{"welder_arms_base", "wielder_arms", "grip"});
        this.renderBarrel(item);
        RenderUtils.applyColor(WeaponHelper.getColor(item));
        this.weaponModel.renderOnly(new String[]{"hull", "sights_rail", "side_rail"});
        GL11.glDisable((int)2896);
        RenderUtils.disableLightmap();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.weaponModel.renderPart("indicator");
        GL11.glEnable((int)2896);
        RenderUtils.enableLightmap();
    }

    void renderHand() {
        if (!Minecraft.func_71410_x().field_71439_g.func_82150_aj()) {
            GL11.glPushMatrix();
            ResourceLocation skin = Minecraft.func_71410_x().field_71439_g.func_110306_p();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(skin);
            GL11.glTranslated((double)-0.2, (double)0.2f, (double)0.7);
            GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)-1.0);
            double length = 1.8;
            double width = 0.9;
            double depth = 0.7;
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
            Tessellator.field_78398_a.func_78374_a(depth, length, 0.0, 0.75, 1.0);
            Tessellator.field_78398_a.func_78374_a(depth, 0.0, 0.0, 0.75, 0.625);
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, width, 0.625, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, length, width, 0.625, 1.0);
            Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    public WavefrontObject getModel() {
        return this.weaponModel;
    }
}

