/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.item;

import matteroverdrive.client.render.item.WeaponItemRenderer;
import matteroverdrive.items.weapon.Phaser;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRendererPhaser
extends WeaponItemRenderer {
    public static final String TEXTURE = "mo:textures/items/phaser2.png";
    private static final String TEXTURE_COLOR_MASK = "mo:textures/items/phaser_color_mask.png";
    public static final String MODEL = "mo:models/item/phaser2.obj";
    public static final String MODEL_3DS = "mo:models/item/phaser2.3ds";
    public static final float SCALE = 6.0f;
    public static final float THIRD_PERSON_SCALE = 3.0f;
    public static final float ITEM_SCALE = 3.0f;
    public static final float SCALE_DROP = 2.5f;
    public static ResourceLocation phaserTextureColorMask;

    public ItemRendererPhaser() {
        super(new ResourceLocation(MODEL), new ResourceLocation(TEXTURE));
        phaserTextureColorMask = new ResourceLocation(TEXTURE_COLOR_MASK);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderFirstPerson(item);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderItem(item);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderDrop(item);
        } else {
            this.renderThirdPerson(type, item);
        }
    }

    void renderItem(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.15);
        GL11.glRotated((double)0.0, (double)0.0, (double)1.0, (double)0.0);
        this.renderGun(IItemRenderer.ItemRenderType.INVENTORY, item);
        GL11.glPopMatrix();
    }

    void renderThirdPerson(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
        GL11.glTranslated((double)0.32, (double)0.23, (double)0.32);
        GL11.glRotated((double)-135.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)60.0, (double)1.0, (double)0.0, (double)0.0);
        this.renderGun(renderType, item);
        GL11.glPopMatrix();
    }

    void renderDrop(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)2.5, (double)2.5, (double)2.5);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)15.0, (double)1.0, (double)0.0, (double)0.0);
        this.renderGun(IItemRenderer.ItemRenderType.ENTITY, item);
        GL11.glPopMatrix();
    }

    void renderFirstPerson(ItemStack item) {
        GL11.glPushMatrix();
        this.renderHand();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScaled((double)6.0, (double)6.0, (double)6.0);
        if (Minecraft.func_71410_x().field_71439_g.func_71039_bw()) {
            GL11.glTranslated((double)0.3, (double)-0.07, (double)0.0);
            GL11.glRotated((double)150.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)-26.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)-5.0, (double)1.0, (double)0.0, (double)1.0);
        } else {
            GL11.glTranslated((double)0.15, (double)-0.06, (double)0.05);
            GL11.glRotated((double)137.5, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)-6.0, (double)1.0, (double)0.0, (double)0.0);
        }
        this.renderGun(IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON, item);
        GL11.glPopMatrix();
    }

    void renderHand() {
        if (!Minecraft.func_71410_x().field_71439_g.func_82150_aj()) {
            GL11.glPushMatrix();
            ResourceLocation skin = Minecraft.func_71410_x().field_71439_g.func_110306_p();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(skin);
            GL11.glTranslated((double)-0.2, (double)0.2f, (double)0.7);
            GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)100.0, (double)0.0, (double)0.0, (double)-1.0);
            double length = 1.8;
            double width = 0.9;
            double depth = 0.7;
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
            Tessellator.field_78398_a.func_78374_a(depth, length, 0.0, 0.75, 1.0);
            Tessellator.field_78398_a.func_78374_a(depth, 0.0, 0.0, 0.75, 0.625);
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, width, 0.625, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, length, width, 0.625, 1.0);
            Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    void renderGun(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        this.bindTexture(this.weaponTexture);
        this.weaponModel.renderOnly(new String[]{"grip"});
        this.renderBarrel(item);
        RenderUtils.applyColor(WeaponHelper.getColor(item));
        this.weaponModel.renderOnly(new String[]{"Base", "display"});
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        RenderUtils.disableLightmap();
        this.renderLevelSlider(item);
        GL11.glEnable((int)2896);
        RenderUtils.enableLightmap();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderLevelSlider(ItemStack item) {
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.weaponModel.renderPart("level_bg");
        this.setIndicatorColor(item);
        GL11.glPushMatrix();
        double power = ((double)item.func_77978_p().func_74771_c("power") + 1.0) / 6.0;
        GL11.glTranslated((double)0.042, (double)0.0, (double)0.0);
        GL11.glScaled((double)power, (double)1.0, (double)1.0);
        this.weaponModel.renderPart("level_slider");
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
    }

    private void setIndicatorColor(ItemStack item) {
        if (Phaser.isKillMode(item)) {
            GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        } else {
            GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        }
    }
}

