/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererPipe
extends TileEntitySpecialRenderer {
    private static Vector4d pv1 = new Vector4d(1.0, 1.0, 0.0, 1.0);
    private static Vector4d pv2 = new Vector4d(1.0, 0.0, 0.0, 1.0);
    private static Vector4d pv3 = new Vector4d(0.0, 0.0, 0.0, 1.0);
    private static Vector4d pv4 = new Vector4d(0.0, 1.0, 0.0, 1.0);
    ResourceLocation texture = new ResourceLocation("mo:textures/blocks/pipe.png");
    protected static double size = 0.3333333333333333;
    boolean drawInside = false;
    float texPixel = 0.0625f;

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        if (tileentity instanceof TileEntityPipe) {
            TileEntityPipe pipe = (TileEntityPipe)tileentity;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            if (this.texture != null) {
                this.func_147499_a(this.texture);
            }
            this.drawCore(pipe, x, y, z, f, this.drawSides(pipe, x, y, z, f));
            GL11.glPopMatrix();
        }
    }

    protected int drawSides(TileEntityPipe pipe, double x, double y, double z, float f) {
        int connections = pipe.getConnectionsMask();
        for (int i = 0; i < 6; ++i) {
            if (!MOMathHelper.getBoolean(connections, i)) continue;
            this.drawSide(pipe, ForgeDirection.values()[i]);
        }
        return connections;
    }

    protected void drawCore(TileEntityPipe tile, double x, double y, double z, float f, int sides) {
        Vector2f uv = this.getCoreUV(tile);
        AxisAngle4d rotation = new AxisAngle4d();
        if (this.drawInside) {
            GL11.glDisable((int)2884);
        }
        if (sides == 3) {
            uv = this.getSidesUV(tile, ForgeDirection.UP);
            rotation = new AxisAngle4d(0.0, 0.0, 1.0, 90.0);
        } else if (sides == 12) {
            uv = this.getSidesUV(tile, ForgeDirection.NORTH);
            rotation = new AxisAngle4d(0.0, 1.0, 0.0, 90.0);
        } else if (sides == 48) {
            uv = this.getSidesUV(tile, ForgeDirection.WEST);
            rotation = new AxisAngle4d(0.0, 0.0, 1.0, 180.0);
        }
        this.drawCube(uv, rotation, new Vector3d());
        GL11.glEnable((int)2884);
    }

    protected Vector2f getCoreUV(TileEntity entity) {
        return new Vector2f(0.0f, 0.0f);
    }

    protected Vector2f getSidesUV(TileEntity entity, ForgeDirection dir) {
        return new Vector2f(1.0f, 0.0f);
    }

    protected void drawSide(TileEntityPipe tile, ForgeDirection dir) {
        if (this.drawInside) {
            GL11.glDisable((int)2884);
        }
        Vector3d offset = new Vector3d((double)dir.offsetX * size, (double)dir.offsetY * size, (double)dir.offsetZ * size);
        Vector2f uv = this.getSidesUV(tile, dir);
        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
            this.drawCube(uv, new AxisAngle4d(0.0, 0.0, 1.0, 90.0), offset);
        } else if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
            this.drawCube(uv, new AxisAngle4d(0.0, 0.0, 1.0, 180.0), offset);
        } else {
            this.drawCube(uv, new AxisAngle4d(0.0, 1.0, 0.0, 90.0), offset);
        }
        GL11.glEnable((int)2884);
    }

    void drawCube(Vector2f uv, AxisAngle4d rot, Vector3d pos) {
        this.drawPlane(new Vector3d(0.0, 0.0, 1.0), new AxisAngle4d(1.0, 0.0, 0.0, -90.0), size, uv, rot, pos);
        this.drawPlane(new Vector3d(0.0, 1.0, 0.0), new AxisAngle4d(1.0, 0.0, 0.0, 90.0), size, uv, rot, pos);
        this.drawPlane(new Vector3d(), new AxisAngle4d(0.0, 1.0, 0.0, 0.0), size, uv, rot, pos);
        this.drawPlane(new Vector3d(1.0, 0.0, 1.0), new AxisAngle4d(0.0, 1.0, 0.0, 180.0), size, uv, rot, pos);
        this.drawPlane(new Vector3d(0.0, 0.0, 1.0), new AxisAngle4d(0.0, 1.0, 0.0, 90.0), size, uv, rot, pos);
        this.drawPlane(new Vector3d(1.0, 0.0, 0.0), new AxisAngle4d(0.0, 1.0, 0.0, 270.0), size, uv, rot, pos);
    }

    void drawPlane(Vector3d pos, AxisAngle4d rot, double scale, Vector2f uv, AxisAngle4d globalRot, Vector3d globalPos) {
        Tessellator.field_78398_a.func_78382_b();
        GL11.glPushMatrix();
        GL11.glTranslated((double)globalPos.x, (double)globalPos.y, (double)globalPos.z);
        GL11.glTranslated((double)(0.5 - scale / 2.0), (double)(0.5 - scale / 2.0), (double)(0.5 - scale / 2.0));
        GL11.glTranslated((double)(scale / 2.0), (double)(scale / 2.0), (double)(scale / 2.0));
        GL11.glRotated((double)globalRot.angle, (double)globalRot.x, (double)globalRot.y, (double)globalRot.z);
        GL11.glTranslated((double)(-scale / 2.0), (double)(-scale / 2.0), (double)(-scale / 2.0));
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        GL11.glRotated((double)rot.angle, (double)rot.x, (double)rot.y, (double)rot.z);
        Vector2f uv1 = new Vector2f(1.0f, 1.0f);
        uv1.add((Tuple2f)uv);
        uv1.scale(6.0f * this.texPixel);
        Vector2f uv2 = new Vector2f(1.0f, 0.0f);
        uv2.add((Tuple2f)uv);
        uv2.scale(6.0f * this.texPixel);
        Vector2f uv3 = new Vector2f(0.0f, 0.0f);
        uv3.add((Tuple2f)uv);
        uv3.scale(6.0f * this.texPixel);
        Vector2f uv4 = new Vector2f(0.0f, 1.0f);
        uv4.add((Tuple2f)uv);
        uv4.scale(6.0f * this.texPixel);
        Vector3f normal = new Vector3f(0.0f, 0.0f, -1.0f);
        this.addVertexWithUV(pv1, uv1.x, uv1.y);
        this.addNormal(normal);
        this.addVertexWithUV(pv2, uv2.x, uv2.y);
        this.addNormal(normal);
        this.addVertexWithUV(pv3, uv3.x, uv3.y);
        this.addNormal(normal);
        this.addVertexWithUV(pv4, uv4.x, uv4.y);
        this.addNormal(normal);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
    }

    void addVertexWithUV(Vector4d vec, float u, float v) {
        Tessellator.field_78398_a.func_78374_a(vec.x, vec.y, vec.z, (double)u, (double)v);
    }

    void addNormal(Vector3f vec) {
        Tessellator.field_78398_a.func_78375_b(vec.x, vec.y, vec.z);
    }
}

