/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import matteroverdrive.api.renderer.ISpaceBodyHoloRenderer;
import matteroverdrive.client.render.tileentity.TileEntityRendererStation;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererStarMap
extends TileEntityRendererStation<TileEntityMachineStarMap> {
    @Override
    protected void renderHologram(TileEntityMachineStarMap starMap, double x, double y, double z, float partialTicks, double noise) {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiStarMap)) {
            if (this.isUsable(starMap)) {
                this.render(starMap, x, y, z, partialTicks);
            } else {
                super.renderHologram(starMap, x, y, z, partialTicks, noise);
            }
        }
    }

    public void render(TileEntityMachineStarMap starMap, double x, double y, double z, float partialTicks) {
        this.renderHologramBase(starMap, x, y, z, partialTicks);
    }

    protected void renderHologramBase(TileEntityMachineStarMap starMap, double x, double y, double z, float partialTicks) {
        Collection<ISpaceBodyHoloRenderer> renderers;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        RenderUtils.disableLightmap();
        GL11.glBlendFunc((int)1, (int)1);
        float distance = (float)Vec3.func_72443_a((double)x, (double)y, (double)z).func_72433_c();
        if (starMap.getActiveSpaceBody() != null && (renderers = ClientProxy.renderHandler.getStarmapRenderRegistry().getStarmapRendererCollection(starMap.getActiveSpaceBody().getClass())) != null) {
            for (ISpaceBodyHoloRenderer renderer : renderers) {
                SpaceBody spaceBody;
                if (!renderer.displayOnZoom(starMap.getZoomLevel(), starMap.getActiveSpaceBody()) || (spaceBody = starMap.getActiveSpaceBody()) == null) continue;
                GL11.glTranslated((double)0.0, (double)renderer.getHologramHeight(spaceBody), (double)0.0);
                GL11.glPushMatrix();
                renderer.renderBody(GalaxyClient.getInstance().getTheGalaxy(), spaceBody, starMap, partialTicks, distance);
                GL11.glPopMatrix();
                if (!this.drawHoloLights()) continue;
                GL11.glPushMatrix();
                Vec3 playerPosition = Minecraft.func_71410_x().field_71451_h.func_70666_h(partialTicks);
                playerPosition.field_72448_b = 0.0;
                Vec3 mapPosition = Vec3.func_72443_a((double)((double)starMap.field_145851_c + 0.5), (double)0.0, (double)((double)starMap.field_145849_e + 0.5));
                Vec3 dir = playerPosition.func_72444_a(mapPosition).func_72432_b();
                double angle = Math.acos(dir.func_72430_b(Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0)));
                if (Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0).func_72430_b(dir.func_72431_c(Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0))) < 0.0) {
                    angle = Math.PI * 2 - angle;
                }
                this.drawHoloGuiInfo(renderer, spaceBody, starMap, (1.5707963267948966 - angle) * 57.29577951308232, partialTicks);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
        RenderUtils.enableLightmap();
    }

    @Override
    protected boolean drawHoloLights() {
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiStarMap);
    }

    @Override
    protected double getLightHeight() {
        return 1.0;
    }

    @Override
    protected double getLightsSize() {
        return 2.0;
    }

    public void drawHoloGuiInfo(ISpaceBodyHoloRenderer renderer, SpaceBody spaceBody, TileEntityMachineStarMap starMap, double angle, float partialTicks) {
        angle = Math.round(angle / 90.0) * 90L;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)(-renderer.getHologramHeight(spaceBody) + 0.3), (double)0.0);
        GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)1.0, (double)0.0, (double)-0.8);
        GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        if (spaceBody != null) {
            renderer.renderGUIInfo(GalaxyClient.getInstance().getTheGalaxy(), spaceBody, starMap, partialTicks, 0.5f);
        }
        GL11.glPopMatrix();
    }
}

