/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import matteroverdrive.Reference;
import matteroverdrive.api.starmap.IBuildable;
import matteroverdrive.api.starmap.IBuilding;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererAbstract;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class StarMapRendererPlanet
extends StarMapRendererAbstract {
    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float viewerDistance) {
        if (spaceBody instanceof Planet) {
            GL11.glLineWidth((float)1.0f);
            Planet planet = (Planet)spaceBody;
            GL11.glPushMatrix();
            this.renderPlanet(planet, viewerDistance);
            GL11.glPopMatrix();
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glEnable((int)3553);
        }
    }

    protected void renderPlanet(Planet planet, float viewerDistance) {
        GL11.glPushMatrix();
        float size = this.getClampedSize(planet);
        GL11.glRotated((double)10.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)((double)Minecraft.func_71410_x().field_71441_e.func_72820_D() * 0.1), (double)0.0, (double)1.0, (double)0.0);
        GL11.glPolygonMode((int)1028, (int)6913);
        GL11.glEnable((int)2884);
        GL11.glPushMatrix();
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        this.sphere.draw(size * 0.99f, 64, 32);
        GL11.glDepthMask((boolean)false);
        GL11.glPushMatrix();
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        RenderUtils.applyColorWithMultipy(Planet.getGuiColor(planet), 0.2f * (1.0f / viewerDistance));
        GL11.glPolygonMode((int)1032, (int)6913);
        this.sphere.draw(size, 64, 32);
        GL11.glPopMatrix();
        this.drawBuildings(planet, size, viewerDistance);
        GL11.glPopMatrix();
        GL11.glDisable((int)2884);
        GL11.glPopMatrix();
        this.drawPlanetInfoClose(planet);
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glEnable((int)3553);
        this.drawShips(planet, size, viewerDistance);
    }

    protected float getClampedSize(Planet planet) {
        return Math.min(Math.max(planet.getSize(), 1.0f), 2.2f) * 0.5f;
    }

    private void drawBuildings(Planet planet, float planetSize, float viewerDistance) {
        this.random.setSeed(planet.getSeed());
        for (int i = 0; i < planet.getBuildings().size(); ++i) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(this.random.nextDouble() * 360.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(this.random.nextDouble() * 360.0), (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)((double)planetSize - 0.04), (double)0.0, (double)0.0);
            RenderUtils.drawCube(0.1, 0.1, 0.1, Reference.COLOR_HOLO, 1.0f / viewerDistance);
            GL11.glPopMatrix();
        }
    }

    private void drawShips(Planet planet, float planetSize, float viewerDistance) {
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 1.0f / viewerDistance);
        this.random.setSeed(planet.getSeed());
        for (int i = 0; i < planet.getFleet().size(); ++i) {
            GL11.glPushMatrix();
            double direction = this.random.nextDouble() * 2.0 - 1.0;
            double startingAngle = this.random.nextDouble() * Math.PI * 2.0;
            double phi = startingAngle + Math.copySign((double)Minecraft.func_71410_x().field_71441_e.func_72820_D() * 0.005, direction);
            double theta = this.random.nextDouble() * Math.PI * 2.0;
            double radius = this.random.nextDouble() * 0.3 + 0.1 + (double)planetSize;
            Vector3f pos = new Vector3f((float)(Math.sin(phi) * Math.sin(theta) * radius), (float)(Math.sin(phi) * Math.cos(theta) * radius), (float)(Math.cos(phi) * radius));
            this.renderShipPath(planet, planet.getShip(i), phi, theta, direction, radius);
            GL11.glTranslatef((float)pos.x, (float)pos.y, (float)pos.z);
            GL11.glPushMatrix();
            GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
            GL11.glRotated((double)Minecraft.func_71410_x().field_71451_h.field_70177_z, (double)0.0, (double)-1.0, (double)0.0);
            GL11.glRotated((double)Minecraft.func_71410_x().field_71451_h.field_70125_A, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)-8.0, (double)-8.0, (double)0.0);
            RenderUtils.renderStack(0, 0, 0, planet.getShip(i), false);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    protected void renderShipPath(Planet planet, ItemStack shipStack, double phi, double theta, double direction, double radius) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        RenderUtils.applyColorWithMultipy(Planet.getGuiColor(planet), 0.2f);
        GL11.glBegin((int)3);
        for (int p = 0; p < 8; ++p) {
            double newPhi = phi - Math.copySign(0.1 * (double)p, direction);
            Vector3f pathPos = new Vector3f((float)(Math.sin(newPhi) * Math.sin(theta) * radius), (float)(Math.sin(newPhi) * Math.cos(theta) * radius), (float)(Math.cos(newPhi) * radius));
            GL11.glVertex3f((float)pathPos.x, (float)pathPos.y, (float)pathPos.z);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    protected void drawPlanetInfoClose(Planet planet) {
        GL11.glPushMatrix();
        RenderUtils.rotateTo((Entity)Minecraft.func_71410_x().field_71451_h);
        GL11.glEnable((int)3553);
        GL11.glPolygonMode((int)1032, (int)6914);
        if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            double radius = this.getClampedSize(planet) * 140.0f;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            for (int i = 0; i < planet.getBuildings().size(); ++i) {
                double angle = 14 * i - 6 * planet.getBuildings().size();
                int x = (int)(Math.cos(angle *= Math.PI / 180) * radius) - 10;
                int y = (int)(Math.sin(angle) * radius) - 10;
                RenderUtils.renderStack(x, y, planet.getBuildings().get(i), 1.0f);
                Color color = Reference.COLOR_HOLO_RED;
                if (planet.getBuildings().get(i).func_77973_b() instanceof IBuilding && ((IBuilding)planet.getBuildings().get(i).func_77973_b()).isOwner(planet.getBuildings().get(i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    color = Reference.COLOR_HOLO;
                }
                Minecraft.func_71410_x().field_71466_p.func_78276_b(planet.getBuildings().get(i).func_82833_r(), x + 21, y + 6, color.getColor());
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        if (spaceBody instanceof Planet) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            Color color = Reference.COLOR_HOLO;
            Planet planet = (Planet)spaceBody;
            int x = 0;
            int y = -16;
            if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                int itemCount = 0;
                for (int i = 0; i < planet.func_70302_i_(); ++i) {
                    if (planet.func_70301_a(i) == null) continue;
                    ItemStack stack = planet.func_70301_a(i);
                    ArrayList<String> info = new ArrayList<String>();
                    if (stack.func_77973_b() instanceof IBuildable && planet.canBuild((IBuildable)stack.func_77973_b(), stack, info)) {
                        RenderUtils.renderStack(0, y - itemCount * 18 - 21, 0, stack, false);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)1, (int)1);
                        RenderUtils.drawString(String.format("%1$s - %2$s", stack.func_82833_r(), MOStringHelper.formatRemainingTime(((IBuildable)stack.func_77973_b()).getRemainingBuildTimeTicks(stack, planet, (World)Minecraft.func_71410_x().field_71441_e) / 20L)), 18, y + 5 - itemCount * 18 - 21, Reference.COLOR_HOLO, opacity);
                    } else {
                        RenderUtils.renderStack(0, y - itemCount * 18 - 21, 0, stack, false);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)1, (int)1);
                        RenderUtils.drawString(String.join((CharSequence)". ", info), 18, y + 5 - itemCount * 18 - 21, Reference.COLOR_HOLO_RED, opacity);
                    }
                    ++itemCount;
                }
                int factoryCount = planet.getFactoryCount();
                if (factoryCount <= 0) {
                    color = Reference.COLOR_HOLO_RED;
                }
                RenderUtils.applyColorWithMultipy(color, opacity);
                ClientProxy.holoIcons.renderIcon("holo_factory", (double)x, (double)y);
                String factoryInfo = String.format("%1$s/%2$s", factoryCount, planet.getBuildingSpaces());
                RenderUtils.drawString(factoryInfo, x += 18, y + 6, color, opacity);
                int fleetCount = planet.getFleetCount();
                color = Reference.COLOR_HOLO;
                if (fleetCount <= 0) {
                    color = Reference.COLOR_HOLO_RED;
                }
                String fleetInfo = String.format("%1$s/%2$s", fleetCount, planet.getFleetSpaces());
                RenderUtils.applyColorWithMultipy(color, opacity);
                ClientProxy.holoIcons.renderIcon("icon_shuttle", (double)(x += this.fontRenderer.func_78256_a(factoryInfo) + 8), (double)y);
                RenderUtils.drawString(fleetInfo, x += 18, y + 6, color, opacity);
                x += this.fontRenderer.func_78256_a(fleetInfo) + 8;
            }
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
            ClientProxy.holoIcons.renderIcon("icon_size", (double)x, (double)y);
            RenderUtils.drawString(DecimalFormat.getPercentInstance().format(planet.getSize()), x += 18, y + 6, Reference.COLOR_HOLO, opacity);
            if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                x = -2;
                float happines = planet.getHappiness();
                color = RenderUtils.lerp(Reference.COLOR_HOLO_RED, Reference.COLOR_HOLO, MathHelper.func_76131_a((float)happines, (float)0.0f, (float)1.0f));
                RenderUtils.applyColorWithMultipy(color, opacity);
                ClientProxy.holoIcons.renderIcon("smile", (double)x, (double)(y -= 20));
                String info = DecimalFormat.getPercentInstance().format(happines);
                RenderUtils.drawString(info, x += 18, y + 6, color, opacity);
                int population = planet.getPopulation();
                RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
                ClientProxy.holoIcons.renderIcon("sort_random", (double)(x += this.fontRenderer.func_78256_a(DecimalFormat.getPercentInstance().format(happines)) + 4), (double)y);
                info = String.format("%,d", population);
                RenderUtils.drawString(info, x += 18, y + 6, Reference.COLOR_HOLO, opacity);
                x = -3;
                int powerProduction = planet.getPowerProducation();
                RenderUtils.applyColorWithMultipy(powerProduction < 0 ? Reference.COLOR_HOLO_RED : Reference.COLOR_HOLO, opacity);
                ClientProxy.holoIcons.renderIcon("battery", (double)x, (double)(y -= 20));
                info = Integer.toString(powerProduction) + "m" + " RF";
                RenderUtils.drawString(info, x += 18, y + 6, powerProduction < 0 ? Reference.COLOR_HOLO_RED : Reference.COLOR_HOLO, opacity);
            }
        }
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return zoom == 3;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 1.5;
    }
}

