/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.Random;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererAbstract;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
public class StarMapRendererStar
extends StarMapRendererAbstract {
    public StarMapRendererStar() {
        this.sphere = new Sphere();
        this.random = new Random();
    }

    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float distance) {
        if (spaceBody instanceof Star) {
            GL11.glLineWidth((float)1.0f);
            Star star = (Star)spaceBody;
            this.random.setSeed(star.getSeed());
            double time = Minecraft.func_71410_x().field_71441_e.func_72820_D();
            GL11.glPushMatrix();
            GL11.glScaled((double)star.getSize(), (double)star.getSize(), (double)star.getSize());
            this.bindTexture(ClientProxy.renderHandler.getRenderParticlesHandler().getAdditiveTextureSheet());
            Tessellator.field_78398_a.func_78382_b();
            RenderUtils.tessalateParticle(Minecraft.func_71410_x().field_71451_h, this.star_icon, star.getSize(), Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), Reference.COLOR_HOLO_YELLOW.getFloatR() * 0.1f, Reference.COLOR_HOLO_YELLOW.getFloatG() * 0.1f, Reference.COLOR_HOLO_YELLOW.getFloatB() * 0.1f, Reference.COLOR_HOLO_YELLOW.getFloatA() * 0.1f);
            Tessellator.field_78398_a.func_78381_a();
            RenderUtils.applyColorWithMultipy(new Color(star.getColor()), 0.25f * (1.0f / distance));
            GL11.glPolygonMode((int)1028, (int)6913);
            GL11.glDisable((int)3553);
            double s = 0.9 + Math.sin(time * 0.01) * 0.1;
            GL11.glScaled((double)s, (double)s, (double)s);
            this.sphere_model.renderAll();
            GL11.glPolygonMode((int)1028, (int)6912);
            GL11.glPointSize((float)(10.0f / (float)Math.max(0.1, (double)distance)));
            this.sphere_model.renderAll();
            if (Minecraft.func_71410_x().field_71441_e.func_72820_D() % 120L > 80L) {
                double t = (double)(Minecraft.func_71410_x().field_71441_e.func_72820_D() % 120L - 80L) / 40.0;
                RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO_YELLOW, (float)MOMathHelper.easeIn(1.0 - t, 0.0, 0.1, 1.0));
                s = MOMathHelper.easeIn(t, 0.0, 10.0, 1.0);
                GL11.glScaled((double)(1.0 + s), (double)(1.0 + s), (double)(1.0 + s));
                this.sphere_model.renderAll();
            }
            GL11.glPopMatrix();
            GL11.glPolygonMode((int)1028, (int)6913);
            int planetID = 0;
            for (Planet planet : star.getPlanets()) {
                float sizeMultiply = 1.0f;
                if (starMap.getDestination().equals(planet)) {
                    sizeMultiply = 1.2f;
                }
                GL11.glDisable((int)3008);
                Color planetColor = Planet.getGuiColor(planet);
                this.random.setSeed(planet.getSeed());
                GL11.glPushMatrix();
                double axisRotation = this.random.nextInt(30) - 15;
                GL11.glRotated((double)axisRotation, (double)1.0, (double)0.0, (double)0.0);
                double radius = (double)(planet.getOrbit() * 2.0f) + ((double)(star.getSize() / 2.0f) + 0.1);
                float planetSize = planet.getSize();
                this.drawPlanetOrbit(planet, radius);
                GL11.glTranslated((double)(Math.sin(time * 0.001 + (double)(10 * planetID)) * radius), (double)0.0, (double)(Math.cos(time * 0.001 + (double)(10 * planetID)) * radius));
                GL11.glPolygonMode((int)1028, (int)6914);
                GL11.glEnable((int)3553);
                if (starMap.getDestination().equals(planet)) {
                    this.bindTexture(ClientProxy.renderHandler.getRenderParticlesHandler().getAdditiveTextureSheet());
                    Tessellator.field_78398_a.func_78382_b();
                    RenderUtils.tessalateParticle(Minecraft.func_71410_x().field_71451_h, this.selectedIcon, planet.getSize() * 0.15f * sizeMultiply, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), planetColor);
                    Tessellator.field_78398_a.func_78381_a();
                }
                if (starMap.getGalaxyPosition().equals(planet)) {
                    this.bindTexture(ClientProxy.renderHandler.getRenderParticlesHandler().getAdditiveTextureSheet());
                    Tessellator.field_78398_a.func_78382_b();
                    RenderUtils.tessalateParticle(Minecraft.func_71410_x().field_71451_h, this.currentIcon, planet.getSize() * 0.25f, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), planetColor);
                    Tessellator.field_78398_a.func_78381_a();
                }
                GL11.glPushMatrix();
                GL11.glRotated((double)(-axisRotation), (double)1.0, (double)0.0, (double)0.0);
                RenderUtils.rotateTo((Entity)Minecraft.func_71410_x().field_71451_h);
                this.drawPlanetInfo(planet);
                GL11.glPopMatrix();
                GL11.glPolygonMode((int)1028, (int)6913);
                GL11.glDisable((int)3553);
                RenderUtils.applyColorWithMultipy(planetColor, 0.3f * (1.0f / distance));
                GL11.glRotated((double)100.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)(time * 2.0), (double)0.0, (double)0.0, (double)1.0);
                this.sphere.draw(planetSize * 0.1f * sizeMultiply, (int)(16.0f + planetSize * 2.0f), (int)(8.0f + planetSize * 2.0f));
                ++planetID;
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)3553);
            GL11.glPolygonMode((int)1028, (int)6914);
        }
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        if (spaceBody instanceof Star) {
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
            GL11.glEnable((int)3008);
            Planet planet = galaxy.getPlanet(starMap.getDestination());
            if (planet != null) {
                if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    RenderUtils.drawString(planet.getName(), 72, -42, Reference.COLOR_HOLO, opacity);
                } else {
                    RenderUtils.drawString(Minecraft.func_71410_x().field_71464_q, planet.getName(), 72, -42, Reference.COLOR_HOLO, opacity);
                }
                RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
                ClientProxy.holoIcons.renderIcon("icon_size", 72.0, -28.0);
                RenderUtils.drawString(DecimalFormat.getPercentInstance().format(planet.getSize()), 92, -23, Reference.COLOR_HOLO, opacity);
                GL11.glDisable((int)3553);
                GL11.glPolygonMode((int)1032, (int)6914);
                this.random.setSeed(planet.getSeed());
                Tessellator.field_78398_a.func_78382_b();
                for (int i = 0; i < 10; ++i) {
                    double step = 6.4;
                    double x = step * (double)i;
                    double y = -10.0;
                    double height = 64.0 * (0.5 * this.random.nextGaussian() + 1.0) / 2.0;
                    Tessellator.field_78398_a.func_78377_a(x, y, 0.0);
                    Tessellator.field_78398_a.func_78377_a(x + step - 1.0, y, 0.0);
                    Tessellator.field_78398_a.func_78377_a(x + step - 1.0, y - height, 0.0);
                    Tessellator.field_78398_a.func_78377_a(x, y - height, 0.0);
                }
                Tessellator.field_78398_a.func_78381_a();
                GL11.glEnable((int)3553);
            }
        }
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return true;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 1.5;
    }

    private void drawPlanetInfo(Planet planet) {
        GL11.glTranslated((double)0.0, (double)(planet.getSize() * 0.13f + 0.05f), (double)0.0);
        GL11.glScaled((double)0.005, (double)0.005, (double)0.005);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(planet.getName());
            Minecraft.func_71410_x().field_71466_p.func_78276_b(planet.getName(), -width / 2, 0, Planet.getGuiColor(planet).getColor());
            if (planet.isHomeworld((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                width = Minecraft.func_71410_x().field_71466_p.func_78256_a("[Home]");
                Minecraft.func_71410_x().field_71466_p.func_78276_b(EnumChatFormatting.GOLD + "[Home]", -width / 2, -10, 0xFFFFFF);
            }
        } else {
            EntityPlayer owner;
            int width = Minecraft.func_71410_x().field_71464_q.func_78256_a(planet.getName());
            Minecraft.func_71410_x().field_71464_q.func_78276_b(planet.getName(), -width / 2, 0, Planet.getGuiColor(planet).getColor());
            if (planet.hasOwner() && (owner = Minecraft.func_71410_x().field_71441_e.func_152378_a(planet.getOwnerUUID())) != null) {
                String info = String.format("[%s]", owner.getDisplayName());
                width = Minecraft.func_71410_x().field_71466_p.func_78256_a(info);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(EnumChatFormatting.GOLD + info, -width / 2, -10, 0xFFFFFF);
            }
        }
    }

    private void drawPlanetOrbit(Planet planet, double radius) {
        GL11.glDisable((int)3553);
        GL11.glPolygonMode((int)1028, (int)6913);
        Tessellator.field_78398_a.func_78371_b(1);
        Tessellator.field_78398_a.func_78369_a(Planet.getGuiColor(planet).getFloatR() * 0.1f, Planet.getGuiColor(planet).getFloatG() * 0.1f, Planet.getGuiColor(planet).getFloatB() * 0.1f, Planet.getGuiColor(planet).getFloatA() * 0.1f);
        for (int i = 0; i < 32; ++i) {
            double angleStep = 0.19634954084936207;
            Tessellator.field_78398_a.func_78377_a(Math.sin(angleStep * (double)i) * radius, 0.0, Math.cos(angleStep * (double)i) * radius);
            Tessellator.field_78398_a.func_78377_a(Math.sin(angleStep * (double)(i + 1)) * radius, 0.0, Math.cos(angleStep * (double)(i + 1)) * radius);
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    private void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
    }
}

