/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.commands;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.player.AndroidPlayer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class AndoidCommands
extends CommandBase {
    public String func_71517_b() {
        return "android";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "android <command> <value> <player>";
    }

    public List func_71514_a() {
        return new ArrayList();
    }

    public void func_71515_b(ICommandSender sender, String[] parameters) {
        AndroidPlayer androidPlayer;
        EntityPlayerMP player;
        if (parameters.length == 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid Parameters"));
            return;
        }
        if (parameters.length >= 2 && (player = parameters.length >= 3 ? AndoidCommands.func_82359_c((ICommandSender)sender, (String)parameters[2]) : AndoidCommands.func_71521_c((ICommandSender)sender)) != null && (androidPlayer = AndroidPlayer.get((EntityPlayer)player)) != null) {
            boolean validCommand = false;
            String commandInfo = "";
            if (parameters[0].equalsIgnoreCase("set")) {
                boolean android = AndoidCommands.func_110662_c((ICommandSender)sender, (String)parameters[1]);
                androidPlayer.setAndroid(android);
                validCommand = true;
                commandInfo = android ? sender.func_70005_c_() + " is now an Android" : sender.func_70005_c_() + " is no longer an Android";
            } else if (parameters[0].equalsIgnoreCase("stats")) {
                if (parameters[1].equalsIgnoreCase("reset")) {
                    androidPlayer.resetUnlocked();
                    validCommand = true;
                    commandInfo = sender.func_70005_c_() + " stats are now Reset";
                }
            } else if (parameters[0].equalsIgnoreCase("unlock")) {
                if (MatterOverdrive.statRegistry.hasStat(parameters[1])) {
                    IBionicStat stat = MatterOverdrive.statRegistry.getStat(parameters[1]);
                    androidPlayer.unlock(stat, stat.maxLevel());
                    validCommand = true;
                    commandInfo = sender.func_70005_c_() + " now has the ability " + EnumChatFormatting.GREEN + "[" + stat.getDisplayName(androidPlayer, stat.maxLevel()) + "]";
                }
            } else if (parameters[0].equalsIgnoreCase("forget") && MatterOverdrive.statRegistry.hasStat(parameters[1])) {
                IBionicStat stat = MatterOverdrive.statRegistry.getStat(parameters[1]);
                androidPlayer.reset(stat);
                validCommand = true;
                commandInfo = EnumChatFormatting.GREEN + "[" + stat.getDisplayName(androidPlayer, stat.maxLevel()) + "]" + EnumChatFormatting.RESET + " removed from " + sender.func_70005_c_();
            }
            if (validCommand) {
                androidPlayer.sync(EnumSet.allOf(AndroidPlayer.DataType.class), false);
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[" + "MatterOverdrive: Community Edition" + "] " + EnumChatFormatting.RESET + commandInfo));
                return;
            }
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid Android Command. Use /help to learn more."));
    }

    public List func_71516_a(ICommandSender commandSender, String[] parameters) {
        ArrayList<String> commands = new ArrayList<String>();
        if (parameters.length == 2) {
            if (parameters[0].equalsIgnoreCase("set")) {
                commands.add("true");
                commands.add("false");
            } else if (parameters[0].equalsIgnoreCase("stats")) {
                commands.add("reset");
            } else if (parameters[0].equalsIgnoreCase("unlock")) {
                commands.addAll(MatterOverdrive.statRegistry.getStats().stream().map(IBionicStat::getUnlocalizedName).collect(Collectors.toList()));
            } else if (parameters[0].equalsIgnoreCase("forget")) {
                commands.addAll(MatterOverdrive.statRegistry.getStats().stream().map(IBionicStat::getUnlocalizedName).collect(Collectors.toList()));
            }
        } else {
            commands.add("set");
            commands.add("stats");
            commands.add("unlock");
            commands.add("forget");
        }
        return commands;
    }

    public boolean func_82358_a(String[] params, int index) {
        return index == 2;
    }
}

