/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.init.MatterOverdriveMatter;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.oredict.OreDictionary;

public class MatterRegistryCommands
extends CommandBase {
    public String func_71517_b() {
        return "matter_registry";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "matter_registry <command> <value>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender commandSender, String[] parameters) {
        if (parameters.length == 1) {
            if (!parameters[0].equalsIgnoreCase("recalculate")) return;
            MatterOverdrive.matterRegistry.getEntries().clear();
            MatterOverdriveMatter.registerBasic(MatterOverdrive.configHandler);
            MatterOverdrive.matterRegistrationHandler.runCalculationThread();
            return;
        } else if (parameters.length == 2) {
            String key;
            if (!parameters[0].equalsIgnoreCase("blacklist")) return;
            ItemStack stack = parameters.length >= 4 ? MatterRegistryCommands.func_82359_c((ICommandSender)commandSender, (String)parameters[3]).func_71045_bC() : MatterRegistryCommands.func_82359_c((ICommandSender)commandSender, (String)commandSender.func_70005_c_()).func_71045_bC();
            if (stack == null) throw new CommandException("Player not holding any item", new Object[]{parameters[1]});
            if (parameters[1].equalsIgnoreCase("itemstack")) {
                key = MatterOverdrive.matterRegistry.getKey(stack);
            } else if (parameters[1].equalsIgnoreCase("item")) {
                key = MatterOverdrive.matterRegistry.getKey(stack.func_77973_b());
            } else {
                if (!parameters[1].equalsIgnoreCase("ore")) throw new CommandException("Invalid type of item. Use either item, itemstack or ore.", new Object[0]);
                int[] orenames = OreDictionary.getOreIDs((ItemStack)stack);
                if (orenames == null || orenames.length <= 0) throw new CommandException("Could not find an ore dictionary entry", new Object[]{parameters[1]});
                key = OreDictionary.getOreName((int)orenames[0]);
            }
            MatterOverdrive.matterRegistry.addToBlacklist(key);
            String[] oldBlacklist = MatterOverdrive.configHandler.getStringList("matter registry", "blacklist");
            String[] newBlacklist = new String[oldBlacklist != null ? oldBlacklist.length + 1 : 1];
            if (newBlacklist.length != 1 & oldBlacklist != null) {
                System.arraycopy(oldBlacklist, 0, newBlacklist, 0, oldBlacklist.length);
            }
            newBlacklist[Objects.requireNonNull(oldBlacklist).length] = key;
            MatterOverdrive.configHandler.config.get("matter registry", "blacklist", new String[0], "").set(newBlacklist);
            MatterOverdrive.configHandler.save();
            commandSender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[" + key + "]" + EnumChatFormatting.RESET + " Added $s to matter blacklist and config.\nYou must recalculate the registry for changes to take effect.\nUse /matter_registry recalculate."));
            return;
        } else {
            String key;
            if (parameters.length < 3 || !parameters[0].equalsIgnoreCase("register")) return;
            int matter = MatterRegistryCommands.func_71526_a((ICommandSender)commandSender, (String)parameters[2]);
            ItemStack stack = parameters.length >= 4 ? MatterRegistryCommands.func_82359_c((ICommandSender)commandSender, (String)parameters[3]).func_71045_bC() : MatterRegistryCommands.func_82359_c((ICommandSender)commandSender, (String)commandSender.func_70005_c_()).func_71045_bC();
            if (stack == null) throw new CommandException("player not holding any item", new Object[]{parameters[1]});
            if (parameters[1].equalsIgnoreCase("itemstack")) {
                key = MatterOverdrive.matterRegistry.getKey(stack);
            } else if (parameters[1].equalsIgnoreCase("item")) {
                key = MatterOverdrive.matterRegistry.getKey(stack.func_77973_b());
            } else {
                if (!parameters[1].equalsIgnoreCase("ore")) throw new CommandException("Invalid type of item. Use either item,itemstack or ore.", new Object[0]);
                int[] oreNames = OreDictionary.getOreIDs((ItemStack)stack);
                if (oreNames == null || oreNames.length <= 0) throw new CommandException("Could not find an ore dictionary entry!", new Object[0]);
                key = OreDictionary.getOreName((int)oreNames[0]);
            }
            MatterOverdrive.matterRegistry.register(key, matter);
            MatterOverdrive.configHandler.setInt(key, "matter registry.new items", matter);
            MatterOverdrive.configHandler.save();
            commandSender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[" + key + "]" + EnumChatFormatting.RESET + " Added $s to matter registry and config.\nYou can now recalculated the registry.\nUse /matter_registry recalculate."));
        }
    }

    public List func_71516_a(ICommandSender commandSender, String[] parameters) {
        ArrayList<String> commands = new ArrayList<String>();
        if (parameters.length == 1) {
            commands.add("recalculate");
            commands.add("register");
            commands.add("blacklist");
        } else if (parameters.length == 2 && (parameters[0].equalsIgnoreCase("register") || parameters[0].equalsIgnoreCase("blacklist"))) {
            commands.add("itemstack");
            commands.add("item");
            commands.add("ore");
        }
        return commands;
    }
}

