/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.commands;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import matteroverdrive.util.MOLog;
import matteroverdrive.world.MOImageGen;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;

public class SaveWorldToImage
extends CommandBase {
    public String func_71517_b() {
        return "world_image_gen";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "world_image_gen <command> <coordinates> <filename>";
    }

    public void func_71515_b(ICommandSender commandSender, String[] parameters) {
        if (parameters.length >= 1) {
            if (parameters[0].equalsIgnoreCase("generate")) {
                if (parameters.length >= 2) {
                    try {
                        File imageFile;
                        File mapFile;
                        HashMap<String, Integer> colorMap = new HashMap<String, Integer>();
                        String[] coordinates = parameters[1].split(",");
                        int x1 = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[0]);
                        int y1 = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[1]);
                        int z1 = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[2]);
                        int x2 = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[3]);
                        int y2 = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[4]);
                        int z2 = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[5]);
                        int zoneSizeX = Math.abs(x1 - x2);
                        int zoneSizeZ = Math.abs(z1 - z2);
                        int zoneLayers = Math.abs(y2 - y1);
                        int imageSizeX = (int)Math.ceil(Math.sqrt(zoneLayers)) * zoneSizeX;
                        int imageSizeZ = (int)Math.ceil(Math.sqrt(zoneLayers)) * zoneSizeZ;
                        int layerPerRow = imageSizeX / zoneSizeX;
                        BufferedImage image = new BufferedImage(imageSizeX, imageSizeZ, 2);
                        for (int layer = 0; layer < zoneLayers; ++layer) {
                            for (int z = 0; z < zoneSizeZ; ++z) {
                                for (int x = 0; x < zoneSizeX; ++x) {
                                    int imageX = layer % layerPerRow * zoneSizeX + x;
                                    int imageY = Math.floorDiv(layer, layerPerRow) * zoneSizeZ + z;
                                    int worldX = Math.min(x1, x2) + x;
                                    int worldY = Math.min(y1, y2) + layer;
                                    int worldZ = Math.min(z1, z2) + z;
                                    Block block = commandSender.func_130014_f_().func_147439_a(worldX, worldY, worldZ);
                                    int meta = commandSender.func_130014_f_().func_72805_g(worldX, worldY, worldZ);
                                    int color = (255 - meta & 0xFF) << 24;
                                    String hex = Integer.toHexString(color);
                                    if (MOImageGen.worldGenerationBlockColors.containsKey(block)) {
                                        color += MOImageGen.worldGenerationBlockColors.get(block).intValue();
                                    } else if (block != Blocks.field_150350_a) {
                                        String blockName = Block.field_149771_c.func_148750_c((Object)block);
                                        color += blockName.hashCode() & 0xFFFFFF;
                                        if (!colorMap.containsKey(blockName)) {
                                            colorMap.put(blockName, color & 0xFFFFFF);
                                        }
                                    }
                                    MOLog.info("ImageX: %s, ImageY: %s", imageX, imageY);
                                    image.setRGB(imageX, imageY, color);
                                }
                            }
                        }
                        if (parameters.length >= 3) {
                            mapFile = new File(parameters[2] + ".txt");
                            imageFile = new File(parameters[2] + ".png");
                        } else {
                            mapFile = new File("test_world_gen_image.txt");
                            imageFile = new File("test_world_gen_image.png");
                        }
                        PrintWriter printWriter = new PrintWriter(mapFile);
                        printWriter.println("LayerWidth: " + zoneSizeX + " LayerHeight: " + zoneSizeZ);
                        for (Map.Entry entry : colorMap.entrySet()) {
                            printWriter.println((String)entry.getKey() + ": " + Integer.toHexString((Integer)entry.getValue()));
                        }
                        printWriter.close();
                        try {
                            ImageIO.write((RenderedImage)image, "png", imageFile);
                            image.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        MOLog.error("", e, new Object[0]);
                        throw new CommandException(e.getMessage(), new Object[0]);
                    }
                }
            } else if (parameters[0].equalsIgnoreCase("import") && parameters.length >= 5) {
                File imageFile = new File(parameters[1] + ".png");
                File mapFile = new File(parameters[1] + ".txt");
                int layerWidth = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)parameters[2]);
                int layerHeight = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)parameters[3]);
                List<int[][]> layers = MOImageGen.loadTexture(imageFile, layerWidth, layerHeight);
                String[] coordinates = parameters[4].split(",");
                int x = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[0]);
                int y = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[1]);
                int z = SaveWorldToImage.func_71526_a((ICommandSender)commandSender, (String)coordinates[2]);
                HashMap<Integer, Block> map = new HashMap<Integer, Block>();
                try {
                    BufferedReader mapReader = new BufferedReader(new FileReader(mapFile));
                    String line = mapReader.readLine();
                    line = mapReader.readLine();
                    while (line != null) {
                        String[] parts = line.split(":");
                        if (parts.length < 3) continue;
                        String blockName = parts[0].trim() + ":" + parts[1].trim();
                        String color = parts[2].trim();
                        int colorInt = (int)(Long.valueOf(color, 16) & 0xFFFFFFL);
                        Block block = Block.func_149684_b((String)blockName);
                        map.put(colorInt, block);
                        line = mapReader.readLine();
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                MOImageGen.generateFromImage(commandSender.func_130014_f_(), x, y, z, layerWidth, layerHeight, layers, map);
            }
        }
    }
}

