/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.compat.modules;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import matteroverdrive.compat.Compat;
import matteroverdrive.init.MatterOverdriveItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;

@Compat(value="exnihilo")
public class CompatExNihilo {
    private static Method registerSieve;

    @Compat.Init
    public static void init(FMLInitializationEvent event) {
        try {
            Class<?> sieveRegistry = Class.forName("exnihilo.registries.SieveRegistry");
            registerSieve = sieveRegistry.getMethod("register", Block.class, Item.class, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            System.err.println("The Ex Nihilo sieve registry class could not be found.");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.err.println("The register method of the Ex Nihilo sieve registry did not exist.");
            e.printStackTrace();
        }
        CompatExNihilo.register(Blocks.field_150351_n, MatterOverdriveItems.dilithium_ctystal, 0, 50);
        CompatExNihilo.register(Blocks.field_150351_n, MatterOverdriveItems.tritanium_dust, 0, 25);
    }

    private static void register(Block source, Item output, int outputMeta, int rarity) {
        try {
            registerSieve.invoke(null, source, output, outputMeta, rarity);
        }
        catch (InvocationTargetException e) {
            System.err.println("There was a problem invoking the register method of the Ex Nihilo sieve registry.");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("There was a problem accessing the register method of the Ex Nihilo sieve registry.");
            e.printStackTrace();
        }
    }
}

