/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.compat.modules.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.data.recipes.InscriberRecipe;
import matteroverdrive.handler.recipes.InscriberRecipes;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CraftingHandlerInscriber
extends TemplateRecipeHandler {
    ResourceLocation background = new ResourceLocation("mo:textures/gui/inscriber_nei.png");
    ResourceLocation arrowTexture = new ResourceLocation("mo:textures/gui/elements/Progress_Arrow_Right.png");

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(55, 20, 26, 18), "mo_inscriber", new Object[0]));
    }

    public String getGuiTexture() {
        return "mo:textures/gui/inscriber_nei.png";
    }

    public void drawProgressBar(int x, int y, int tx, int ty, int w, int h, float completion, int direction) {
        GuiDraw.changeTexture((ResourceLocation)this.arrowTexture);
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)24, (int)0, (int)48, (int)16);
    }

    public void drawExtras(int recipe) {
        GuiDraw.changeTexture((ResourceLocation)this.arrowTexture);
        int ticks = ((CashedInscriberRecipe)((Object)this.arecipes.get(recipe))).getTime();
        int width = (int)((float)(this.cycleticks % ticks) / (float)ticks * 24.0f);
        RenderUtils.drawPlaneWithUV(57.0, 20.0, 0.0, width, 16.0, 0.5, 0.0, (float)width / 48.0f, 1.0);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(String.format("-%,d RF", ((CashedInscriberRecipe)((Object)this.arecipes.get(recipe))).getEnergy()), 72, 52, Reference.COLOR_HOLO_RED.getColor());
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("mo_inscriber") && ((Object)((Object)this)).getClass() == CraftingHandlerInscriber.class) {
            for (InscriberRecipe recipe : InscriberRecipes.getRecipes()) {
                CashedInscriberRecipe cachedRecipe = new CashedInscriberRecipe(recipe);
                cachedRecipe.computeVisuals();
                this.arecipes.add(cachedRecipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        RenderUtils.drawPlane(23.0, 5.0, 0.0, 120.0, 72.0);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes()) {
            if (!NEIServerUtils.areStacksIdentical((ItemStack)result, (ItemStack)recipe.getRecipeOutput())) continue;
            CashedInscriberRecipe cachedRecipe = new CashedInscriberRecipe(recipe);
            cachedRecipe.computeVisuals();
            this.arecipes.add(cachedRecipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes()) {
            if (!NEIServerUtils.areStacksIdentical((ItemStack)ingredient, (ItemStack)recipe.getMain()) && !NEIServerUtils.areStacksIdentical((ItemStack)ingredient, (ItemStack)recipe.getSec())) continue;
            CashedInscriberRecipe cachedRecipe = new CashedInscriberRecipe(recipe);
            cachedRecipe.computeVisuals();
            this.arecipes.add(cachedRecipe);
        }
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public String getRecipeName() {
        return MOStringHelper.translateToLocal("gui.inscriber.name");
    }

    public String getOverlayIdentifier() {
        return "mo_inscriber";
    }

    public class CashedInscriberRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack main;
        PositionedStack sec;
        PositionedStack result;
        int time;
        int energy;

        public CashedInscriberRecipe(InscriberRecipe recipe) {
            super((TemplateRecipeHandler)CraftingHandlerInscriber.this);
            this.main = new PositionedStack((Object)recipe.getMain(), 33, 20);
            this.sec = new PositionedStack((Object)recipe.getSec(), 33, 47);
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 91, 20);
            this.time = recipe.getTime();
            this.energy = recipe.getEnergy();
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(this.main);
            stacks.add(this.sec);
            return stacks;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            this.main.generatePermutations();
            this.sec.generatePermutations();
            this.result.generatePermutations();
        }

        public int getTime() {
            return this.time;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

