/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import java.io.Serializable;
import matteroverdrive.util.MOBlockHelper;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos
implements Comparable<BlockPos>,
Serializable {
    public int x;
    public int y;
    public int z;
    public ForgeDirection orientation;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPos(int x, int y, int z, ForgeDirection var4) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = var4;
    }

    public BlockPos(BlockPos blockPos) {
        this.x = blockPos.x;
        this.y = blockPos.y;
        this.z = blockPos.z;
        this.orientation = blockPos.orientation;
    }

    public BlockPos(NBTTagCompound tagCompound) {
        this.x = tagCompound.func_74762_e("bp_i");
        this.y = tagCompound.func_74762_e("bp_j");
        this.z = tagCompound.func_74762_e("bp_k");
        this.orientation = !tagCompound.func_74764_b("bp_dir") ? ForgeDirection.UNKNOWN : ForgeDirection.getOrientation((int)tagCompound.func_74771_c("bp_dir"));
    }

    public BlockPos(TileEntity tileEntity) {
        this.x = tileEntity.field_145851_c;
        this.y = tileEntity.field_145848_d;
        this.z = tileEntity.field_145849_e;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPos copy() {
        return new BlockPos(this.x, this.y, this.z, this.orientation);
    }

    public BlockPos copy(ForgeDirection direction) {
        return new BlockPos(this.x, this.y, this.z, direction);
    }

    public BlockPos setOrientation(ForgeDirection var1) {
        this.orientation = var1;
        return this;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("bp_i", this.x);
        tagCompound.func_74768_a("bp_j", this.y);
        tagCompound.func_74768_a("bp_k", this.z);
        tagCompound.func_74774_a("bp_dir", (byte)this.orientation.ordinal());
    }

    public String toString() {
        return this.orientation == null ? "{" + this.x + ", " + this.y + ", " + this.z + "}" : "{" + this.x + ", " + this.y + ", " + this.z + ";" + this.orientation.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockPos)) {
            return false;
        }
        BlockPos blockPos = (BlockPos)obj;
        return blockPos.x == this.x & blockPos.y == this.y & blockPos.z == this.z & blockPos.orientation == this.orientation;
    }

    public boolean equals(BlockPos blockPos) {
        return blockPos != null && blockPos.x == this.x & blockPos.y == this.y & blockPos.z == this.z & blockPos.orientation == this.orientation;
    }

    public int hashCode() {
        return this.x & 0xFFF | this.y & 0xFF00 | this.z & 0xFFF000;
    }

    public BlockPos step(int dir) {
        int[] var2 = MOBlockHelper.SIDE_COORD_MOD[dir];
        this.x += var2[0];
        this.y += var2[1];
        this.z += var2[2];
        return this;
    }

    public BlockPos step(int dir, int amount) {
        int[] var3 = MOBlockHelper.SIDE_COORD_MOD[dir];
        this.x += var3[0] * amount;
        this.y += var3[1] * amount;
        this.z += var3[2] * amount;
        return this;
    }

    public BlockPos step(ForgeDirection direction) {
        this.x += direction.offsetX;
        this.y += direction.offsetY;
        this.z += direction.offsetZ;
        return this;
    }

    public BlockPos step(ForgeDirection direction, int amount) {
        this.x += direction.offsetX * amount;
        this.y += direction.offsetY * amount;
        this.z += direction.offsetZ * amount;
        return this;
    }

    public boolean blockExists(World world) {
        return world.func_72899_e(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public <T extends TileEntity> T getTileEntity(World world, Class<T> tClass) {
        TileEntity var3 = world.func_147438_o(this.x, this.y, this.z);
        return (T)(tClass.isInstance(var3) ? var3 : null);
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    @Override
    public int compareTo(BlockPos blockPos) {
        return this.x == blockPos.x ? (this.y == blockPos.y ? this.z - blockPos.z : this.y - blockPos.y) : this.x - blockPos.x;
    }
}

