/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ScaleTexture {
    private ResourceLocation location;
    int texW;
    int texH;
    int leftOffset;
    int rightOffset;
    int topOffset;
    int bottomOffset;
    int width;
    int height;
    int u;
    int v;

    public ScaleTexture(ResourceLocation location, int width, int height) {
        this.location = location;
        this.texW = width;
        this.texH = height;
        this.width = width;
        this.height = height;
    }

    public ScaleTexture setOffsets(int left, int right, int top, int bottom) {
        this.leftOffset = this.clamp(left, this.texW);
        this.rightOffset = this.clamp(right, this.texW - left);
        this.topOffset = this.clamp(top, this.texH);
        this.bottomOffset = this.clamp(bottom, this.texH - top);
        return this;
    }

    public void render(int x, int y, int width, int height) {
        this.render(x, y, width, height, 0);
    }

    public void render(int x, int y, int width, int height, int zLevel) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        float u = (float)this.u / (float)this.texW;
        float v = (float)this.v / (float)this.texH;
        float leftOffset = (float)this.leftOffset / (float)this.texW;
        float rightOffset = (float)this.rightOffset / (float)this.texW;
        float topOffset = (float)this.topOffset / (float)this.texH;
        float bottomOffset = (float)this.bottomOffset / (float)this.texH;
        int centerWidth = width - (this.leftOffset + this.rightOffset);
        int centerHeight = height - (this.topOffset + this.bottomOffset);
        float centerUWidth = (float)this.width / (float)this.texW - (leftOffset + rightOffset);
        float centerVHeight = (float)this.height / (float)this.texH - (topOffset + bottomOffset);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78374_a(0.0, (double)this.topOffset, 0.0, (double)u, (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)this.topOffset, 0.0, (double)(u + leftOffset), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, 0.0, 0.0, (double)(u + leftOffset), (double)v);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)v);
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)this.topOffset, 0.0, (double)(u + leftOffset), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), 0.0, 0.0, (double)(u + leftOffset + centerUWidth), (double)v);
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, 0.0, 0.0, (double)(u + leftOffset), (double)v);
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth + this.rightOffset), (double)this.topOffset, 0.0, (double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth + this.rightOffset), 0.0, 0.0, (double)(u + leftOffset + centerUWidth + rightOffset), (double)v);
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), 0.0, 0.0, (double)(u + leftOffset + centerUWidth), (double)v);
        Tessellator.field_78398_a.func_78374_a(0.0, (double)(this.topOffset + centerHeight), 0.0, (double)u, (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)this.topOffset, 0.0, (double)(u + leftOffset), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a(0.0, (double)this.topOffset, 0.0, (double)u, (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)this.topOffset, 0.0, (double)(u + leftOffset), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth + this.rightOffset), (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth + this.rightOffset), (double)this.topOffset, 0.0, (double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset));
        Tessellator.field_78398_a.func_78374_a(0.0, (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0, (double)u, (double)(v + topOffset + centerVHeight + bottomOffset));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0, (double)(u + leftOffset), (double)(v + topOffset + centerVHeight + bottomOffset));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a(0.0, (double)(this.topOffset + centerHeight), 0.0, (double)u, (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0, (double)(u + leftOffset), (double)(v + topOffset + centerVHeight + bottomOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight + bottomOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight + bottomOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth + this.rightOffset), (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0, (double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset + centerVHeight + bottomOffset));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth + this.rightOffset), (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78374_a((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0, (double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight));
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
    }

    private int clamp(int value, int max) {
        return MathHelper.func_76125_a((int)value, (int)0, (int)max);
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ScaleTexture setTextureSize(int width, int height) {
        this.texW = width;
        this.texH = height;
        return this;
    }

    public ScaleTexture setUV(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }
}

