/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.util.EnumSet;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BioticStatCloak
extends AbstractBioticStat
implements IConfigSubscriber {
    public static int ENERGY_PER_TICK = 128;

    public BioticStatCloak(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.setShowOnWheel(true);
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), EnumChatFormatting.YELLOW.toString() + ENERGY_PER_TICK + " RF" + EnumChatFormatting.GRAY);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K) {
            if (this.isActive(android, level)) {
                if (!android.getPlayer().func_82150_aj()) {
                    android.getPlayer().field_70170_p.func_72956_a((Entity)android.getPlayer(), "mo:cloak_on", 1.0f, 1.0f);
                }
                android.getPlayer().func_82142_c(true);
                android.extractEnergyScaled(ENERGY_PER_TICK);
            } else {
                if (android.getPlayer().func_82150_aj()) {
                    android.getPlayer().field_70170_p.func_72956_a((Entity)android.getPlayer(), "mo:cloak_off", 1.0f, 1.0f);
                }
                android.getPlayer().func_82142_c(false);
            }
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer android, int level, boolean server) {
        if (this.equals(android.getActiveStat()) && server) {
            this.setActive(android, level, !android.getEffects().func_74767_n("Cloaked"));
        }
    }

    public void setActive(AndroidPlayer android, int level, boolean active) {
        android.getEffects().func_74757_a("Cloaked", active);
        android.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS), true);
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (!this.isEnabled(androidPlayer, level) && this.isActive(androidPlayer, level)) {
            this.setActive(androidPlayer, level, false);
        }
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getEffects().func_74767_n("Cloaked") && !androidPlayer.getPlayer().func_71039_bw();
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        return super.isEnabled(androidPlayer, level) && androidPlayer.hasEnoughEnergyScaled(ENERGY_PER_TICK);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_TICK = config.getInt("cloak_energy_per_tick", "abilities", 128, "The energy cost of the Cloak");
    }
}

