/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestLogic;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.GenericQuest;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.entity.player.MOExtendedProperties;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class GenericMultiQuest
extends GenericQuest {
    protected IQuestLogic[] logics;
    boolean sequential;
    boolean autoComplete;

    public GenericMultiQuest(IQuestLogic[] questLogics, String title, int xpReward) {
        super(null, title, xpReward);
        this.logics = questLogics;
        for (int i = 0; i < this.logics.length; ++i) {
            if (!(this.logics[i] instanceof AbstractQuestLogic)) continue;
            ((AbstractQuestLogic)this.logics[i]).setAutoComplete(true);
            ((AbstractQuestLogic)this.logics[i]).setId(Integer.toString(i));
        }
    }

    @Override
    public boolean canBeAccepted(QuestStack questStack, EntityPlayer entityPlayer) {
        MOExtendedProperties extendedProperties = MOExtendedProperties.get(entityPlayer);
        if (extendedProperties != null) {
            for (IQuestLogic logic : this.logics) {
                if (logic.canAccept(questStack, entityPlayer)) continue;
                return false;
            }
        }
        return !extendedProperties.hasCompletedQuest(questStack) && !extendedProperties.hasQuest(questStack);
    }

    @Override
    public String getTitle(QuestStack questStack) {
        String t = MOStringHelper.translateToLocal("quest." + this.title + ".title");
        if (this.sequential) {
            t = this.logics[this.getCurrentObjective(questStack)].modifyTitle(questStack, t);
        }
        return t;
    }

    @Override
    public String getTitle(QuestStack questStack, EntityPlayer entityPlayer) {
        String t = this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".title"), entityPlayer);
        if (this.sequential) {
            t = this.logics[this.getCurrentObjective(questStack)].modifyTitle(questStack, t);
        }
        return t;
    }

    @Override
    public String getInfo(QuestStack questStack, EntityPlayer entityPlayer) {
        if (this.sequential) {
            String i = MOStringHelper.hasTranslation("quest." + this.title + ".info." + this.getCurrentObjective(questStack)) ? this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".info." + this.getCurrentObjective(questStack)), entityPlayer) : this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".info"), entityPlayer);
            i = this.logics[this.getCurrentObjective(questStack)].modifyInfo(questStack, i);
            return i;
        }
        return this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".info"), entityPlayer);
    }

    @Override
    public String getObjective(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.logics[objectiveIndex].modifyObjective(questStack, entityPlayer, this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".objective." + objectiveIndex), entityPlayer), objectiveIndex);
    }

    @Override
    public int getObjectivesCount(QuestStack questStack, EntityPlayer entityPlayer) {
        if (this.sequential) {
            return this.getCurrentObjective(questStack) + 1;
        }
        return this.logics.length;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.logics[objectiveIndex].isObjectiveCompleted(questStack, entityPlayer, 0);
    }

    @Override
    public boolean areQuestStacksEqual(QuestStack questStackOne, QuestStack questStackTwo) {
        if (questStackOne.getQuest() instanceof GenericMultiQuest && questStackTwo.getQuest() instanceof GenericMultiQuest) {
            return questStackOne.getQuest() == questStackTwo.getQuest();
        }
        return false;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        for (IQuestLogic logic : this.logics) {
            logic.initQuestStack(random, questStack);
        }
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        boolean hasChangedFlag = false;
        for (int i = 0; i < this.logics.length; ++i) {
            if (this.sequential) {
                if (i > this.getCurrentObjective(questStack)) continue;
                hasChangedFlag |= this.logics[i].onEvent(questStack, event, entityPlayer);
                continue;
            }
            if (!this.logics[i].onEvent(questStack, event, entityPlayer)) continue;
            hasChangedFlag = true;
        }
        return hasChangedFlag;
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
        for (IQuestLogic logic : this.logics) {
            logic.onCompleted(questStack, entityPlayer);
        }
    }

    @Override
    public int getXpReward(QuestStack questStack, EntityPlayer entityPlayer) {
        int xp = this.xpReward;
        for (IQuestLogic logic : this.logics) {
            xp = logic.modifyXP(questStack, entityPlayer, xp);
        }
        return xp;
    }

    @Override
    public void addToRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
        rewards.addAll(this.questRewards);
        for (IQuestLogic logic : this.logics) {
            logic.modifyRewards(questStack, entityPlayer, rewards);
        }
    }

    public GenericMultiQuest setSequential(boolean sequential) {
        this.sequential = sequential;
        return this;
    }

    @Override
    public void setCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
        for (int i = 0; i < this.logics.length; ++i) {
            if (!this.logics[i].isObjectiveCompleted(questStack, entityPlayer, 0)) {
                return;
            }
            if (!this.sequential || i < this.getCurrentObjective(questStack) || i >= this.logics.length) continue;
            this.setCurrentObjective(questStack, i + 1);
        }
        if (this.autoComplete) {
            super.setCompleted(questStack, entityPlayer);
        }
    }

    public int getCurrentObjective(QuestStack questStack) {
        if (questStack.getTagCompound() != null) {
            return MathHelper.func_76125_a((int)questStack.getTagCompound().func_74771_c("CurrentObjective"), (int)0, (int)(this.logics.length - 1));
        }
        return 0;
    }

    public void setCurrentObjective(QuestStack questStack, int objective) {
        if (questStack.getTagCompound() == null) {
            questStack.setTagCompound(new NBTTagCompound());
        }
        questStack.getTagCompound().func_74774_a("CurrentObjective", (byte)MathHelper.func_76125_a((int)objective, (int)0, (int)(this.logics.length - 1)));
    }

    public GenericMultiQuest setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
        return this;
    }
}

