/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.entity.player.MOExtendedProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class QuestLogicKillCreature
extends AbstractQuestLogic {
    String regex;
    ItemStack killWithItemStack;
    Item killWithItem;
    boolean explosionOnly;
    boolean burnOnly;
    boolean shootOnly;
    boolean onlyChildren;
    int minKillCount;
    int maxKillCount;
    int xpPerKill;
    Class<? extends EntityLivingBase>[] creatureClasses;

    public QuestLogicKillCreature(Class<? extends EntityLivingBase> creatureClass, int minKillCount, int maxKillCount, int xpPerKill) {
        this(new Class[]{creatureClass}, minKillCount, maxKillCount, xpPerKill);
    }

    public QuestLogicKillCreature(Class<? extends EntityLivingBase>[] creatureClasses, int minKillCount, int maxKillCount, int xpPerKill) {
        this.creatureClasses = creatureClasses;
        this.minKillCount = minKillCount;
        this.maxKillCount = maxKillCount;
        this.xpPerKill = xpPerKill;
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return String.format(info, "", Integer.toString(this.getMaxKillCount(questStack)), this.getTargetName(questStack));
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getKillCount(questStack) >= this.getMaxKillCount(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objetive, int objectiveIndex) {
        return String.format(objetive, "", this.getKillCount(questStack), this.getMaxKillCount(questStack), this.getTargetName(questStack));
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.getTag(questStack).func_74768_a("MaxKillCount", this.random(random, this.minKillCount, this.maxKillCount));
        this.getTag(questStack).func_74774_a("KillType", (byte)random.nextInt(this.creatureClasses.length));
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof LivingDeathEvent) {
            LivingDeathEvent deathEvent = (LivingDeathEvent)event;
            Class<? extends EntityLivingBase> targetClass = this.creatureClasses[this.getKillType(questStack)];
            if (deathEvent.entityLiving != null && targetClass.isInstance(deathEvent.entityLiving)) {
                if (this.regex != null && !this.isTargetNameValid(((LivingDeathEvent)event).entity)) {
                    return false;
                }
                if (this.shootOnly && !((LivingDeathEvent)event).source.func_76352_a()) {
                    return false;
                }
                if (this.burnOnly && !((LivingDeathEvent)event).source.func_76347_k()) {
                    return false;
                }
                if (this.explosionOnly && !((LivingDeathEvent)event).source.func_94541_c()) {
                    return false;
                }
                if (this.killWithItem != null && (entityPlayer.func_70694_bm() == null || entityPlayer.func_70694_bm().func_77973_b() != this.killWithItem)) {
                    return false;
                }
                if (!(this.killWithItemStack == null || entityPlayer.func_70694_bm() != null && ItemStack.func_77989_b((ItemStack)entityPlayer.func_70694_bm(), (ItemStack)this.killWithItemStack))) {
                    return false;
                }
                if (this.onlyChildren && !((LivingDeathEvent)event).entityLiving.func_70631_g_()) {
                    return false;
                }
                this.initTag(questStack);
                int currentKillCount = this.getKillCount(questStack);
                if (currentKillCount < this.getMaxKillCount(questStack)) {
                    MOExtendedProperties extendedProperties;
                    this.setKillCount(questStack, ++currentKillCount);
                    if (this.isObjectiveCompleted(questStack, entityPlayer, 0) && this.autoComplete && (extendedProperties = MOExtendedProperties.get(entityPlayer)) != null) {
                        questStack.markComplited(entityPlayer, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isTargetNameValid(Entity entity) {
        return !(entity instanceof EntityLiving && ((EntityLiving)entity).func_94056_bM() ? !((EntityLiving)entity).func_94057_bL().matches(this.regex) : !entity.func_70005_c_().matches(this.regex));
    }

    @Override
    public void onTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    public int getKillType(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("KillType");
        }
        return 0;
    }

    public int getMaxKillCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MaxKillCount");
        }
        return 0;
    }

    public int getKillCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("KillCount");
        }
        return 0;
    }

    public void setKillCount(QuestStack questStack, int killCount) {
        this.initTag(questStack);
        this.getTag(questStack).func_74768_a("KillCount", killCount);
    }

    public String getTargetName(QuestStack questStack) {
        return this.getEntityClassName(this.creatureClasses[this.getKillType(questStack)], "Unknown Target");
    }

    public Class<? extends EntityLivingBase>[] getCreatureClasses() {
        return this.creatureClasses;
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.xpPerKill * this.getMaxKillCount(questStack);
    }

    public QuestLogicKillCreature setOnlyChildren(boolean onlyChildren) {
        this.onlyChildren = onlyChildren;
        return this;
    }

    public QuestLogicKillCreature setShootOnly(boolean shootOnly) {
        this.shootOnly = shootOnly;
        return this;
    }

    public QuestLogicKillCreature setBurnOnly(boolean burnOnly) {
        this.burnOnly = burnOnly;
        return this;
    }

    public QuestLogicKillCreature setExplosionOnly(boolean explosionOnly) {
        this.explosionOnly = explosionOnly;
        return this;
    }

    public void setNameRegex(String regex) {
        this.regex = regex;
    }
}

