/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.QuestBlock;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.world.BlockEvent;

public class QuestLogicMine
extends AbstractQuestLogic {
    QuestBlock[] blocks;
    boolean hasMetadata;
    int metadata;
    int minMineCount;
    int maxMineCount;
    int xpPerMine;
    boolean randomBlock;

    public QuestLogicMine(Block block, int minMineCount, int maxMineCount, int xpPerMine) {
        this.blocks = new QuestBlock[]{QuestBlock.fromBlock(block)};
        this.minMineCount = minMineCount;
        this.maxMineCount = maxMineCount;
        this.xpPerMine = xpPerMine;
        this.randomBlock = true;
    }

    public QuestLogicMine(Block block, int minMineCount, int maxMineCount, int xpPerMine, int metadata) {
        this(block, minMineCount, maxMineCount, xpPerMine);
        this.metadata = metadata;
        this.hasMetadata = true;
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        info = info.replace("$maxMineAmount", Integer.toString(this.getMaxMineCount(questStack)));
        Block block = this.getBlock(questStack);
        info = info.replace("$mineBlock", block != null ? block.func_149732_F() : "Unknown Block");
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getMineCount(questStack) >= this.getMaxMineCount(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = objective.replace("$mineAmount", Integer.toString(this.getMineCount(questStack)));
        objective = objective.replace("$maxMineAmount", Integer.toString(this.getMaxMineCount(questStack)));
        Block block = this.getBlock(questStack);
        objective = objective.replace("$mineBlock", block != null ? block.func_149732_F() : "Unknown Block");
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.initBlockType(random, questStack);
        this.getTag(questStack).func_74768_a("MaxMineCount", this.random(random, this.minMineCount, this.maxMineCount));
    }

    private void initBlockType(Random random, QuestStack questStack) {
        if (this.randomBlock) {
            ArrayList<Integer> avalibleBlocks = new ArrayList<Integer>();
            for (int i = 0; i < this.blocks.length; ++i) {
                Block block = this.blocks[i].getBlock();
                if (block == null) continue;
                avalibleBlocks.add(i);
            }
            if (avalibleBlocks.size() > 0) {
                this.setBlockType(questStack, (Integer)avalibleBlocks.get(random.nextInt(avalibleBlocks.size())));
            }
        } else {
            for (int i = 0; i < this.blocks.length; ++i) {
                Block block = this.blocks[i].getBlock();
                if (block == null) continue;
                this.setBlockType(questStack, i);
            }
        }
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof BlockEvent.HarvestDropsEvent) {
            BlockEvent.HarvestDropsEvent harvestEvent = (BlockEvent.HarvestDropsEvent)event;
            Block block = this.getBlock(questStack);
            if (!(block == null || harvestEvent.block != block || this.hasMetadata && harvestEvent.blockMetadata != this.metadata || this.getMineCount(questStack) >= this.getMaxMineCount(questStack))) {
                this.setMineCount(questStack, this.getMineCount(questStack) + 1);
                if (this.isObjectiveCompleted(questStack, entityPlayer, 0) && this.autoComplete) {
                    questStack.markComplited(entityPlayer, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.getMaxMineCount(questStack) * this.xpPerMine;
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public int getMineCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MineCount");
        }
        return 0;
    }

    public void setMineCount(QuestStack questStack, int mineCount) {
        this.initTag(questStack);
        this.getTag(questStack).func_74768_a("MineCount", mineCount);
    }

    public int getMaxMineCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MaxMineCount");
        }
        return 0;
    }

    public int getBlockType(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("BlockType");
        }
        return 0;
    }

    public void setBlockType(QuestStack questStack, int blockType) {
        this.initTag(questStack);
        this.getTag(questStack).func_74774_a("BlockType", (byte)blockType);
    }

    public Block getBlock(QuestStack questStack) {
        int blockType = this.getBlockType(questStack);
        if (blockType < this.blocks.length) {
            return this.blocks[blockType].getBlock();
        }
        return null;
    }

    public QuestLogicMine setRandomBlock(boolean randomBlock) {
        this.randomBlock = randomBlock;
        return this;
    }
}

