/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.events.MOEventTransport;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import net.minecraft.entity.player.EntityPlayer;

public class QuestLogicTeleport
extends AbstractQuestLogic {
    BlockPos pos;
    int minDistance;
    int maxDistance;

    public QuestLogicTeleport() {
        this(null);
    }

    public QuestLogicTeleport(BlockPos pos) {
        this(pos, 0, 0);
    }

    public QuestLogicTeleport(BlockPos pos, int minDistance, int maxDistance) {
        this.pos = pos;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.hasTeleported(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof MOEventTransport) {
            if (this.pos != null) {
                int distance = ((MOEventTransport)event).destination.getDistance(this.pos.x, this.pos.y, this.pos.z);
                if (distance < this.maxDistance && distance > this.minDistance) {
                    if (this.autoComplete) {
                        questStack.markComplited(entityPlayer, false);
                    }
                    this.setTeleported(questStack);
                    return true;
                }
            } else {
                if (this.autoComplete) {
                    questStack.markComplited(entityPlayer, false);
                }
                this.setTeleported(questStack);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public void setTeleported(QuestStack questStack) {
        this.initTag(questStack);
        this.getTag(questStack).func_74757_a("Teleported", true);
    }

    public boolean hasTeleported(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74767_n("Teleported");
        }
        return false;
    }
}

