/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.transport;

import java.util.List;
import matteroverdrive.api.transport.IPipe;
import matteroverdrive.api.transport.IPipeNetwork;

public abstract class AbstractPipeNetwork<T extends IPipe>
implements IPipeNetwork<T> {
    @Override
    public void invalidateNetwork() {
        for (IPipe pipe : this.getNetworkPipes()) {
            pipe.setNetwork(null);
        }
        this.getNetworkPipes().clear();
    }

    public void merge(IPipeNetwork<T> network) {
        for (IPipe pipe : network.getNetworkPipes()) {
            pipe.setNetwork(this);
            this.getNetworkPipes().add(pipe);
        }
    }

    @Override
    public void addPipe(T pipe) {
        this.getNetworkPipes().add(pipe);
        if (pipe.getNetwork() != null && pipe.getNetwork() != this) {
            pipe.getNetwork().removePipe(pipe);
        }
        pipe.setNetwork((AbstractPipeNetwork)this);
    }

    @Override
    public void removePipe(T pipe) {
        this.getNetworkPipes().remove(pipe);
    }

    @Override
    public void destroyPipe(T pipe) {
        List connections;
        this.removePipe(pipe);
        if (this.getNetworkPipes().size() == 0) {
            this.invalidateNetwork();
        }
        if ((connections = pipe.getConnections()).size() > 1) {
            for (IPipe iPipe : connections) {
                if (iPipe.getNetwork() == null || iPipe.getNetwork() != this) continue;
                iPipe.getNetwork().invalidateNetwork();
            }
        }
    }

    public abstract void networkUpdate(T var1);
}

