/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.transport;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import matteroverdrive.data.transport.AbstractPipeNetwork;
import matteroverdrive.data.transport.IFluidPipe;
import matteroverdrive.util.FluidNetworkHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidPipeNetwork
extends AbstractPipeNetwork<IFluidPipe> {
    Set<IFluidPipe> fluidPipes;
    Set<IFluidPipe> fluidHandlers = new HashSet<IFluidPipe>();

    public FluidPipeNetwork() {
        this.fluidPipes = new HashSet<IFluidPipe>();
    }

    @Override
    public void invalidateNetwork() {
        super.invalidateNetwork();
        FluidNetworkHelper.addFluidPipeToPool(this);
    }

    @Override
    public void addPipe(IFluidPipe pipe) {
        super.addPipe(pipe);
        this.manageFluidHandlersAdding(pipe);
    }

    public void manageFluidHandlersAdding(IFluidPipe fluidPipe) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = fluidPipe.getTile().func_145831_w().func_147438_o(fluidPipe.getTile().field_145851_c + direction.offsetX, fluidPipe.getTile().field_145848_d + direction.offsetY, fluidPipe.getTile().field_145849_e + direction.offsetZ);
            if (!(tileEntity instanceof IFluidHandler) || tileEntity instanceof IFluidPipe || this.fluidHandlers.contains(tileEntity)) continue;
            this.fluidHandlers.add(fluidPipe);
            return;
        }
    }

    @Override
    public void removePipe(IFluidPipe pipe) {
        super.removePipe(pipe);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = pipe.getTile().func_145831_w().func_147438_o(pipe.getTile().field_145851_c + direction.offsetX, pipe.getTile().field_145848_d + direction.offsetY, pipe.getTile().field_145849_e + direction.offsetZ);
            if (!(tileEntity instanceof IFluidHandler) || tileEntity instanceof IFluidPipe) continue;
            this.fluidHandlers.remove(pipe);
        }
    }

    @Override
    public void networkUpdate(IFluidPipe fluidPipe) {
        boolean stillAHandler = false;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = fluidPipe.getTile().func_145831_w().func_147438_o(fluidPipe.getTile().field_145851_c + direction.offsetX, fluidPipe.getTile().field_145848_d + direction.offsetY, fluidPipe.getTile().field_145849_e + direction.offsetZ);
            if (!(tileEntity instanceof IFluidHandler) || tileEntity instanceof IFluidPipe) continue;
            stillAHandler = true;
            break;
        }
        if (!stillAHandler) {
            this.fluidHandlers.remove(fluidPipe);
        }
        this.manageFluidHandlersAdding(fluidPipe);
    }

    public Collection<IFluidPipe> getFluidHandlers() {
        return this.fluidHandlers;
    }

    @Override
    public Collection<IFluidPipe> getNetworkPipes() {
        return this.fluidPipes;
    }
}

