/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.data.world.WorldPosition2D;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldSavedData;

public class GenPositionWorldData
extends WorldSavedData {
    Map<String, List<WorldPosition2D>> positions = new HashMap<String, List<WorldPosition2D>>();

    public GenPositionWorldData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        for (Object key : nbtTagCompound.func_150296_c()) {
            ArrayList<WorldPosition2D> pos2D = new ArrayList<WorldPosition2D>();
            NBTTagList tagList = nbtTagCompound.func_150295_c(key.toString(), 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                pos2D.add(new WorldPosition2D(tagList.func_150305_b(i)));
            }
            this.positions.put(key.toString(), pos2D);
        }
    }

    public void func_76187_b(NBTTagCompound nbtTagCompound) {
        for (Map.Entry<String, List<WorldPosition2D>> entry : this.positions.entrySet()) {
            NBTTagList tagList = new NBTTagList();
            for (WorldPosition2D worldPosition2D : entry.getValue()) {
                NBTTagCompound worldPositionTag = new NBTTagCompound();
                worldPosition2D.writeToNBT(worldPositionTag);
                tagList.func_74742_a((NBTBase)worldPositionTag);
            }
            nbtTagCompound.func_74782_a(entry.getKey(), (NBTBase)tagList);
        }
    }

    public boolean isFarEnough(String name, int x, int y, int distance) {
        List<WorldPosition2D> positions = this.positions.get(name);
        if (positions != null) {
            for (WorldPosition2D worldPosition2D : positions) {
                if (worldPosition2D.manhattanDistance(x, y) >= distance) continue;
                return false;
            }
        }
        return true;
    }

    public double getNearestDistance(String name, Vec3 pos) {
        List<WorldPosition2D> positions = this.positions.get(name);
        double lastDistance = -1.0;
        if (positions != null) {
            for (WorldPosition2D worldPosition2D : positions) {
                double tempDist = Vec3.func_72443_a((double)worldPosition2D.x, (double)pos.field_72448_b, (double)worldPosition2D.z).func_72438_d(pos);
                if (!(lastDistance < 0.0) && !(tempDist < lastDistance)) continue;
                lastDistance = tempDist;
            }
        }
        return lastDistance;
    }

    public void addPosition(String name, WorldPosition2D position2D) {
        List<WorldPosition2D> pos = this.positions.get(name);
        if (pos == null) {
            pos = new ArrayList<WorldPosition2D>();
            this.positions.put(name, pos);
        }
        pos.add(position2D);
        this.func_76185_a();
    }

    public List<WorldPosition2D> getPositions(String name) {
        return this.positions.get(name);
    }
}

