/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.dialog;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.api.events.MOEventDialogInteract;
import matteroverdrive.api.renderer.IDialogShot;
import matteroverdrive.entity.player.MOExtendedProperties;
import matteroverdrive.gui.GuiDialog;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;

public class DialogMessage
implements IDialogMessage {
    protected String message;
    protected String question;
    protected IDialogMessage parent;
    protected List<IDialogMessage> options;
    @SideOnly(value=Side.CLIENT)
    protected IDialogShot[] shots;
    @SideOnly(value=Side.CLIENT)
    protected String holoIcon;

    public DialogMessage() {
        this.init();
    }

    public DialogMessage(String message) {
        this(message, message);
    }

    public DialogMessage(String message, String question) {
        this.message = message;
        this.question = question;
        this.init();
    }

    private void init() {
        this.options = new ArrayList<IDialogMessage>();
    }

    @Override
    public IDialogMessage getParent(IDialogNpc npc, EntityPlayer player) {
        return this.parent;
    }

    @Override
    public List<IDialogMessage> getOptions(IDialogNpc npc, EntityPlayer player) {
        return this.options;
    }

    @Override
    public String getMessageText(IDialogNpc npc, EntityPlayer player) {
        return this.formatMessage(this.message, npc, player);
    }

    @Override
    public String getQuestionText(IDialogNpc npc, EntityPlayer player) {
        return this.formatQuestion(this.question, npc, player);
    }

    @Override
    public void onOptionsInteract(IDialogNpc npc, EntityPlayer player, int option) {
        if (option >= 0 && option < this.options.size()) {
            this.options.get(option).onInteract(npc, player);
        }
    }

    @Override
    public void onInteract(IDialogNpc npc, EntityPlayer player) {
        if (npc != null && player != null) {
            if (player.field_70170_p.field_72995_K) {
                this.setAsGuiActiveMessage(npc, player);
            } else {
                npc.onPlayerInteract(player, this);
                MOEventDialogInteract eventDialogInteract = new MOEventDialogInteract(player, npc, this);
                MinecraftForge.EVENT_BUS.post((Event)eventDialogInteract);
                MOExtendedProperties extendedProperties = MOExtendedProperties.get(player);
                if (extendedProperties != null) {
                    extendedProperties.onEvent((Event)eventDialogInteract);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void setAsGuiActiveMessage(IDialogNpc npc, EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiDialog) {
            ((GuiDialog)Minecraft.func_71410_x().field_71462_r).setCurrentMessage(this);
        }
    }

    @Override
    public boolean canInteract(IDialogNpc npc, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isVisible(IDialogNpc npc, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IDialogShot[] getShots(IDialogNpc npc, EntityPlayer player) {
        return this.shots;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHoloIcon(IDialogNpc npc, EntityPlayer player) {
        return this.holoIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShots(IDialogShot ... shot) {
        this.shots = shot;
    }

    public void setParent(IDialogMessage parent) {
        this.parent = parent;
    }

    public void addOption(IDialogMessage message) {
        this.options.add(message);
    }

    public IDialogMessage getMessage(int id) {
        return this.options.get(id);
    }

    public List<IDialogMessage> getOptions() {
        return this.options;
    }

    @SideOnly(value=Side.CLIENT)
    public DialogMessage setHoloIcon(String holoIcon) {
        this.holoIcon = holoIcon;
        return this;
    }

    public DialogMessage loadMessageFromLocalization(String key) {
        this.message = MOStringHelper.translateToLocal(key);
        return this;
    }

    public DialogMessage loadQuestionFromLocalization(String key) {
        this.question = MOStringHelper.translateToLocal(key);
        return this;
    }

    protected String formatMessage(String text, IDialogNpc npc, EntityPlayer player) {
        if (text != null) {
            return String.format(text, player.getDisplayName(), npc.getEntity().func_70005_c_());
        }
        return text;
    }

    protected String formatQuestion(String text, IDialogNpc npc, EntityPlayer player) {
        if (text != null) {
            return String.format(text, player.getDisplayName(), npc.getEntity().func_70005_c_());
        }
        return text;
    }
}

