/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity;

import cpw.mods.fml.relauncher.Side;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.api.dialog.IDialogQuestGiver;
import matteroverdrive.api.dialog.IDialogRegistry;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.client.render.conversation.DialogShot;
import matteroverdrive.dialog.DialogMessage;
import matteroverdrive.dialog.DialogMessageAndroidOnly;
import matteroverdrive.dialog.DialogMessageBackToMain;
import matteroverdrive.dialog.DialogMessageQuestGive;
import matteroverdrive.dialog.DialogMessageQuestOnObjectivesCompleted;
import matteroverdrive.dialog.DialogMessageQuestStart;
import matteroverdrive.dialog.DialogMessageQuit;
import matteroverdrive.dialog.DialogMessageRandom;
import matteroverdrive.entity.monster.EntityMutantScientist;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.entity.player.MOExtendedProperties;
import matteroverdrive.entity.tasks.EntityAITalkToPlayer;
import matteroverdrive.entity.tasks.EntityAIWatchDialogPlayer;
import matteroverdrive.init.MatterOverdriveDialogs;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.network.packet.server.PacketManageConversation;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityVillagerMadScientist
extends EntityVillager
implements IDialogNpc,
IDialogQuestGiver {
    private static DialogMessageQuestOnObjectivesCompleted convertMe;
    private static DialogMessage canYouConvert;
    private static DialogMessage whatDidYouDo;
    private static DialogMessage cocktailOfAscension;
    public static DialogMessage cocktailOfAscensionComplete;
    private EntityPlayer dialogPlayer;
    private IDialogMessage startMessage;

    public EntityVillagerMadScientist(World world) {
        super(world, 666);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITalkToPlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchDialogPlayer(this));
        this.setJunkie(this.field_70146_Z.nextBoolean());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)new Byte(0));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        return data;
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("junkie", this.getJunkie());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setJunkie(nbtTagCompound.func_74767_n("junkie"));
    }

    public EntityVillager func_90011_a(EntityAgeable entity) {
        EntityVillagerMadScientist villager = new EntityVillagerMadScientist(this.field_70170_p);
        villager.func_110161_a(null);
        return villager;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            MatterOverdrive.packetPipeline.sendToServer(new PacketManageConversation(this, true));
            return true;
        }
        return false;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        return super.func_70934_b(player);
    }

    public static void registerDialogMessages(IDialogRegistry registry, Side side) {
        convertMe = new DialogMessageQuestOnObjectivesCompleted(new QuestStack(MatterOverdriveQuests.punyHumans), new int[]{0});
        registry.registerMessage(convertMe);
        convertMe.loadQuestionFromLocalization("dialog.mad_scientist.convert.question");
        canYouConvert = new DialogMessageQuestGive(new QuestStack(MatterOverdriveQuests.punyHumans));
        registry.registerMessage(canYouConvert);
        canYouConvert.loadMessageFromLocalization("dialog.mad_scientist.requirements.line");
        canYouConvert.loadQuestionFromLocalization("dialog.mad_scientist.requirements.question");
        canYouConvert.addOption(convertMe);
        canYouConvert.addOption(MatterOverdriveDialogs.backHomeMessage);
        DialogMessage undo = new DialogMessage();
        registry.registerMessage(undo);
        undo.loadMessageFromLocalization("dialog.mad_scientist.undo.line");
        undo.loadQuestionFromLocalization("dialog.mad_scientist.undo.question");
        undo.addOption(MatterOverdriveDialogs.trade);
        undo.addOption(MatterOverdriveDialogs.backHomeMessage);
        whatDidYouDo = new DialogMessageAndroidOnly();
        registry.registerMessage(whatDidYouDo);
        whatDidYouDo.loadMessageFromLocalization("dialog.mad_scientist.whatDidYouDo.line");
        whatDidYouDo.loadQuestionFromLocalization("dialog.mad_scientist.whatDidYouDo.question");
        whatDidYouDo.addOption(undo);
        whatDidYouDo.addOption(MatterOverdriveDialogs.backHomeMessage);
        DialogMessage acceptCocktail = new DialogMessageQuestGive(new QuestStack(MatterOverdriveQuests.cocktailOfAscension)).setReturnToMain(true).loadQuestionFromLocalization("dialog.mad_scientist.junkie.cocktail_quest.question.accept");
        registry.registerMessage(acceptCocktail);
        DialogMessage declineCocktail = new DialogMessageBackToMain().loadQuestionFromLocalization("dialog.mad_scientist.junkie.cocktail_quest.question.decline");
        registry.registerMessage(declineCocktail);
        DialogMessage[] cocktailQuest = MatterOverdrive.dialogFactory.constructMultipleLineDialog(DialogMessageQuestStart.class, "dialog.mad_scientist.junkie.cocktail_quest", 8, ". . . . . .");
        ((DialogMessageQuestStart)cocktailQuest[0]).setQuest(new QuestStack(MatterOverdriveQuests.cocktailOfAscension));
        cocktailOfAscension = cocktailQuest[0];
        DialogMessage lastLine = cocktailQuest[cocktailQuest.length - 1];
        lastLine.addOption(acceptCocktail);
        lastLine.addOption(declineCocktail);
        cocktailOfAscensionComplete = new DialogMessageQuestOnObjectivesCompleted(new QuestStack(MatterOverdriveQuests.cocktailOfAscension), new int[]{0, 1, 2});
        cocktailOfAscensionComplete.loadMessageFromLocalization("dialog.mad_scientist.junkie.cocktail_quest.line");
        cocktailOfAscensionComplete.loadQuestionFromLocalization("dialog.mad_scientist.junkie.cocktail_quest.complete.question");
        DialogMessage areYouOk = new DialogMessageQuit().loadQuestionFromLocalization("dialog.mad_scientist.junkie.cocktail_quest.are_you_ok.question");
        cocktailOfAscensionComplete.addOption(areYouOk);
        if (side == Side.CLIENT) {
            canYouConvert.setShots(DialogShot.closeUp);
            undo.setShots(DialogShot.closeUp);
            whatDidYouDo.setShots(DialogShot.fromBehindLeftClose);
            for (int i = 0; i < cocktailQuest.length; ++i) {
                MatterOverdrive.dialogFactory.addRandomShots(cocktailQuest[i]);
            }
        }
    }

    @Override
    public IDialogMessage getStartDialogMessage(EntityPlayer player) {
        return this.startMessage;
    }

    @Override
    public void setDialogPlayer(EntityPlayer player) {
        this.dialogPlayer = player;
        this.startMessage = player != null ? this.assembleStartingMessage(player) : null;
    }

    private IDialogMessage assembleStartingMessage(EntityPlayer player) {
        if (this.getJunkie()) {
            DialogMessage mainJunkieMessage = new DialogMessageRandom().loadMessageFromLocalization("dialog.mad_scientist.junkie.main.line");
            MatterOverdrive.dialogFactory.addOnlyVisibleOptions(player, this, mainJunkieMessage, canYouConvert, MatterOverdriveDialogs.trade, cocktailOfAscension, cocktailOfAscensionComplete, MatterOverdriveDialogs.quitMessage);
            return mainJunkieMessage;
        }
        if (AndroidPlayer.get(player).isAndroid()) {
            DialogMessageRandom mainAndroidMessage = new DialogMessageRandom();
            ((DialogMessage)mainAndroidMessage).loadMessageFromLocalization("dialog.mad_scientist.main.line.android");
            mainAndroidMessage.addOption(whatDidYouDo);
            mainAndroidMessage.addOption(MatterOverdriveDialogs.trade);
            mainAndroidMessage.addOption(MatterOverdriveDialogs.quitMessage);
            return mainAndroidMessage;
        }
        DialogMessageRandom mainHumanMessage = new DialogMessageRandom();
        ((DialogMessage)mainHumanMessage).loadMessageFromLocalization("dialog.mad_scientist.main.line.human");
        mainHumanMessage.addOption(canYouConvert);
        mainHumanMessage.addOption(MatterOverdriveDialogs.quitMessage);
        return mainHumanMessage;
    }

    @Override
    public EntityPlayer getDialogPlayer() {
        return this.dialogPlayer;
    }

    @Override
    public boolean canTalkTo(EntityPlayer player) {
        return AndroidPlayer.get(player) == null || !AndroidPlayer.get(player).isTurning();
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public void onPlayerInteract(EntityPlayer player, DialogMessage dialogMessage) {
        if (dialogMessage == cocktailOfAscensionComplete) {
            this.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 1000, 1));
            this.field_70170_p.func_72956_a((Entity)this, "mo:failed_animal_die_0", 1.0f, 1.0f);
            this.func_70106_y();
            EntityMutantScientist mutantScientist = new EntityMutantScientist(this.field_70170_p);
            mutantScientist.func_70656_aK();
            mutantScientist.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            mutantScientist.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)mutantScientist);
        } else if (dialogMessage == convertMe) {
            MOExtendedProperties extendedProperties = MOExtendedProperties.get(player);
            for (QuestStack questStack : extendedProperties.getQuestData().getActiveQuests()) {
                if (questStack.getQuest() != MatterOverdriveQuests.punyHumans) continue;
                questStack.markComplited(player, false);
                AndroidPlayer.get(player).startConversion();
            }
        }
    }

    @Override
    public void giveQuest(IDialogMessage message, QuestStack questStack, EntityPlayer entityPlayer) {
        MOExtendedProperties extendedProperties;
        if (questStack != null && (extendedProperties = MOExtendedProperties.get(entityPlayer)) != null && questStack.getQuest().canBeAccepted(questStack, entityPlayer)) {
            QuestStack newQuestStack = questStack.copy();
            newQuestStack.setGiver((Entity)this);
            extendedProperties.addQuest(newQuestStack);
        }
    }

    public void setJunkie(boolean junkie) {
        this.field_70180_af.func_75692_b(13, (Object)(junkie ? (byte)1 : 0));
        if (junkie) {
            this.func_94058_c(MOStringHelper.translateToLocal("entity.mad_scientist.junkie.name"));
        }
    }

    public boolean getJunkie() {
        return this.field_70180_af.func_75683_a(13) == 1;
    }
}

