/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.monster;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import matteroverdrive.Reference;
import matteroverdrive.api.entity.IPathableMob;
import matteroverdrive.data.BlockPos;
import matteroverdrive.entity.monster.EntityRogueAndroid;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.tile.TileEntityAndroidSpawner;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityRougeAndroidMob
extends EntityMob
implements IEntityAdditionalSpawnData,
IPathableMob<EntityRougeAndroidMob> {
    private static ResourceLocation androidNames = new ResourceLocation("mo:info/android_names.txt");
    private static String[] names = MOStringHelper.readTextFile(androidNames).split(",");
    boolean fromSpawner;
    private BlockPos spawnerPosition;
    private int currentPathIndex;
    private Vec3[] path;
    private int maxPathTargetRangeSq;
    private int visorColor;
    private ScorePlayerTeam team;
    private boolean legendary;
    private int level;

    public EntityRougeAndroidMob(World world) {
        super(world);
        if (!world.field_72995_K) {
            this.setAndroidLevel((int)MathHelper.func_151237_a((double)Math.abs(this.field_70146_Z.nextGaussian() * (1.0 + (double)world.field_73013_u.func_151525_a() * 0.25)), (double)0.0, (double)3.0));
            boolean isLegendary = this.field_70146_Z.nextDouble() < 0.05 * (double)this.getAndroidLevel();
            this.setLegendary(isLegendary);
            this.init();
            this.func_70661_as().func_75491_a(true);
            this.func_70661_as().func_75495_e(false);
        }
    }

    public EntityRougeAndroidMob(World world, int level, boolean legendary) {
        super(world);
        this.setAndroidLevel(level);
        this.setLegendary(legendary);
        this.init();
    }

    private void init() {
        String name = this.getIsLegendary() ? EnumChatFormatting.GOLD + String.format("%s %s ", "\u272a", MOStringHelper.translateToLocal("rarity.legendary")) : "";
        name = name + String.format("[%s] ", this.getAndroidLevel());
        name = name + names[this.field_70146_Z.nextInt(names.length)];
        this.func_94058_c(name);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getIsLegendary() ? 128.0 : (double)(this.getAndroidLevel() * 10 + 32));
        this.func_70606_j(this.func_110138_aP());
        if (this.fromSpawner && !this.addToSpawner(this.spawnerPosition)) {
            this.func_70106_y();
        }
        if (this.getIsLegendary()) {
            this.setVisorColor(Reference.COLOR_HOLO_RED.getColor());
        } else {
            switch (this.getAndroidLevel()) {
                case 0: {
                    this.setVisorColor(Reference.COLOR_HOLO.getColor());
                    break;
                }
                case 1: {
                    this.setVisorColor(Reference.COLOR_HOLO_YELLOW.getColor());
                    break;
                }
                case 2: {
                    this.setVisorColor(Reference.COLOR_HOLO_PURPLE.getColor());
                    break;
                }
                default: {
                    this.setVisorColor(-1);
                }
            }
        }
    }

    public EnumChatFormatting getNameColor() {
        if (this.getIsLegendary()) {
            return EnumChatFormatting.GOLD;
        }
        switch (this.getAndroidLevel()) {
            case 0: {
                return EnumChatFormatting.GRAY;
            }
            case 1: {
                return EnumChatFormatting.DARK_AQUA;
            }
            case 2: {
                return EnumChatFormatting.DARK_PURPLE;
            }
        }
        return null;
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setLegendary(nbtTagCompound.func_74767_n("Legendary"));
        this.setAndroidLevel(nbtTagCompound.func_74771_c("Level"));
        this.setVisorColor(nbtTagCompound.func_74762_e("VisorColor"));
        if (nbtTagCompound.func_150297_b("Team", 8)) {
            ScorePlayerTeam team = this.field_70170_p.func_96441_U().func_96508_e(nbtTagCompound.func_74779_i("Team"));
            if (team != null) {
                this.setTeam(team);
            } else {
                this.func_70106_y();
            }
        }
        if (nbtTagCompound.func_150297_b("SpawnerPos", 10)) {
            this.spawnerPosition = new BlockPos(nbtTagCompound.func_74775_l("SpawnerPos"));
            this.fromSpawner = true;
        }
        this.currentPathIndex = nbtTagCompound.func_74762_e("CurrentPathIndex");
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74774_a("Level", (byte)this.getAndroidLevel());
        nbtTagCompound.func_74757_a("Legendary", this.getIsLegendary());
        nbtTagCompound.func_74768_a("VisorColor", this.getVisorColor());
        if (this.getTeam() != null) {
            nbtTagCompound.func_74778_a("Team", this.getTeam().func_96661_b());
        }
        if (this.spawnerPosition != null) {
            NBTTagCompound spawnerPos = new NBTTagCompound();
            this.spawnerPosition.writeToNBT(spawnerPos);
            nbtTagCompound.func_74782_a("SpawnerPos", (NBTBase)spawnerPos);
        }
        nbtTagCompound.func_74768_a("CurrentPathIndex", this.currentPathIndex);
    }

    private boolean addToSpawner(BlockPos position) {
        this.spawnerPosition = position;
        TileEntityAndroidSpawner spawnerEntity = position.getTileEntity(this.field_70170_p, TileEntityAndroidSpawner.class);
        if (spawnerEntity != null) {
            spawnerEntity.addSpawnedAndroid(this);
            return true;
        }
        return false;
    }

    public void func_70624_b(EntityLivingBase target) {
        if (target != null && target.func_96124_cp() != null) {
            if (!target.func_96124_cp().func_142054_a((Team)this.getTeam())) {
                super.func_70624_b(target);
            }
        } else {
            super.func_70624_b(target);
        }
    }

    public boolean func_70687_e(PotionEffect potion) {
        return false;
    }

    public boolean func_70601_bi() {
        return this.getCanSpawnHere(false, false, false) && !this.hasToManyAndroids();
    }

    public boolean hasToManyAndroids() {
        Chunk chunk = this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj);
        int androidCount = 0;
        for (int i = 0; i < chunk.field_76645_j.length; ++i) {
            for (int c = 0; c < chunk.field_76645_j[i].size(); ++c) {
                if (!(chunk.field_76645_j[i].get(c) instanceof EntityRougeAndroidMob) || ++androidCount <= EntityRogueAndroid.MAX_ANDROIDS_PER_CHUNK) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getCanSpawnHere(boolean ignoreEntityCollision, boolean ignoreLight, boolean ignoreDimension) {
        if (!ignoreDimension) {
            if (EntityRogueAndroid.dimensionWhitelist.size() > 0) {
                return EntityRogueAndroid.dimensionWhitelist.contains(this.field_70170_p.field_73011_w.field_76574_g) && this.inDimensionBlacklist();
            }
            if (this.inDimensionBlacklist()) {
                return false;
            }
        }
        boolean light = ignoreLight ? true : this.func_70814_o();
        boolean entityCollison = ignoreEntityCollision ? true : this.field_70170_p.func_72855_b(this.field_70121_D);
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && light && entityCollison && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public float func_70783_a(int p_70783_1_, int p_70783_2_, int p_70783_3_) {
        float weight = 1.0f - this.field_70170_p.func_72801_o(p_70783_1_, p_70783_2_, p_70783_3_);
        weight *= this.field_70170_p.isSideSolid(p_70783_1_, p_70783_2_, p_70783_3_, ForgeDirection.UP) ? 0.0f : 1.0f;
        weight = (float)((double)weight / Math.abs((double)p_70783_2_ - this.field_70165_t));
        return weight;
    }

    protected void func_82164_bB() {
        if (this.field_70146_Z.nextFloat() < 0.15f) {
            float f;
            int i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            for (int j = 3; j >= 0; --j) {
                ItemStack itemstack = this.func_130225_q(j);
                if (j < 3 && this.field_70146_Z.nextFloat() < f) break;
                if (itemstack != null) continue;
                Object item = null;
                if (i == 3) {
                    if (this.field_70146_Z.nextBoolean()) {
                        switch (j + 1) {
                            case 4: {
                                item = MatterOverdriveItems.tritaniumHelemet;
                                break;
                            }
                            case 3: {
                                item = MatterOverdriveItems.tritaniumChestplate;
                                break;
                            }
                            case 2: {
                                item = MatterOverdriveItems.tritaniumLeggings;
                                break;
                            }
                            case 1: {
                                item = MatterOverdriveItems.tritaniumBoots;
                            }
                        }
                    } else {
                        item = EntityRougeAndroidMob.func_82161_a((int)(j + 1), (int)i);
                    }
                } else {
                    item = EntityRougeAndroidMob.func_82161_a((int)(j + 1), (int)i);
                }
                if (item == null) continue;
                this.func_70062_b(j + 1, new ItemStack(item));
            }
        }
    }

    public boolean func_110176_b(int p_110176_1_, int p_110176_2_, int p_110176_3_) {
        return true;
    }

    public boolean func_110175_bO() {
        return this.getCurrentTarget() != null;
    }

    public ChunkCoordinates func_110172_bL() {
        Vec3 currentTarget = this.getCurrentTarget();
        return new ChunkCoordinates((int)currentTarget.field_72450_a, (int)currentTarget.field_72448_b, (int)currentTarget.field_72449_c);
    }

    private boolean inDimensionBlacklist() {
        return EntityRogueAndroid.dimensionBlacklist.contains(this.field_70170_p.field_73011_w.field_76574_g);
    }

    public void setAndroidLevel(int level) {
        this.level = level;
    }

    public int getAndroidLevel() {
        return this.level;
    }

    public void setLegendary(boolean legendary) {
        this.legendary = legendary;
        this.field_70131_O = legendary ? 2.8799999f : 1.8f;
    }

    public boolean getIsLegendary() {
        return this.legendary;
    }

    public void setTeam(ScorePlayerTeam team) {
        this.team = team;
    }

    public String func_94057_bL() {
        if (this.hasTeam()) {
            return this.getTeam().func_142053_d(this.field_70180_af.func_75681_e(10));
        }
        EnumChatFormatting color = this.getNameColor();
        if (color != null) {
            return color + this.field_70180_af.func_75681_e(10);
        }
        return this.field_70180_af.func_75681_e(10);
    }

    public ScorePlayerTeam getTeam() {
        return this.team;
    }

    public boolean hasTeam() {
        return this.getTeam() != null;
    }

    public boolean wasSpawnedFrom(TileEntityAndroidSpawner spawner) {
        if (this.spawnerPosition != null) {
            TileEntity tileEntity = this.spawnerPosition.getTileEntity(this.field_70170_p);
            return tileEntity == spawner;
        }
        return false;
    }

    public void setSpawnerPosition(BlockPos position) {
        this.spawnerPosition = position;
        this.fromSpawner = true;
    }

    public void func_70106_y() {
        TileEntityAndroidSpawner spawner;
        if (this.spawnerPosition != null && (spawner = this.spawnerPosition.getTileEntity(this.field_70170_p, TileEntityAndroidSpawner.class)) != null) {
            spawner.removeAndroid(this);
        }
        this.field_70128_L = true;
    }

    public int getVisorColor() {
        return this.visorColor;
    }

    public void setVisorColor(int color) {
        this.visorColor = color;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.level);
        buffer.writeBoolean(this.legendary);
        buffer.writeInt(this.visorColor);
        buffer.writeBoolean(this.hasTeam());
        if (this.hasTeam()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.getTeam().func_96661_b());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setAndroidLevel(additionalData.readByte());
        this.setLegendary(additionalData.readBoolean());
        this.setVisorColor(additionalData.readInt());
        if (additionalData.readBoolean()) {
            String teamName = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
            ScorePlayerTeam team = this.field_70170_p.func_96441_U().func_96508_e(teamName);
            if (team != null) {
                this.setTeam(team);
            }
        }
    }

    @Override
    public Vec3 getCurrentTarget() {
        if (this.path != null && this.currentPathIndex < this.path.length) {
            return this.path[this.currentPathIndex];
        }
        return null;
    }

    @Override
    public void onTargetReached(Vec3 pos) {
        if (this.currentPathIndex < this.path.length - 1) {
            ++this.currentPathIndex;
        }
    }

    @Override
    public boolean isNearTarget(Vec3 pos) {
        return pos.func_72445_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) < (double)this.maxPathTargetRangeSq;
    }

    @Override
    public EntityRougeAndroidMob getEntity() {
        return this;
    }

    public void setPath(Vec3[] path, int range) {
        this.path = path;
        this.maxPathTargetRangeSq = range * range;
    }

    protected String func_70639_aQ() {
        return "mo:rogue_android_say";
    }

    protected String func_70673_aS() {
        return "mo:rogue_android_death";
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public int func_70627_aG() {
        return 480;
    }
}

