/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.player;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventQuest;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.gui.GuiDataPad;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.network.packet.client.quest.PacketSyncQuests;
import matteroverdrive.network.packet.client.quest.PacketUpdateQuest;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;

public class MOExtendedProperties
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "MOPlayer";
    private EntityPlayer player;
    private PlayerQuestData questData;

    public MOExtendedProperties(EntityPlayer player) {
        this.player = player;
        this.questData = new PlayerQuestData(this);
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new MOExtendedProperties(player));
    }

    public static MOExtendedProperties get(EntityPlayer player) {
        return (MOExtendedProperties)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound questNBT = new NBTTagCompound();
        this.questData.writeToNBT(questNBT, EnumSet.allOf(PlayerQuestData.DataType.class));
        compound.func_74782_a("QuestData", (NBTBase)questNBT);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound questNBT = compound.func_74775_l("QuestData");
        this.questData.readFromNBT(questNBT, EnumSet.allOf(PlayerQuestData.DataType.class));
    }

    public void sync(EnumSet<PlayerQuestData.DataType> dataTypes) {
        if (this.player != null && !this.player.field_70170_p.field_72995_K && this.player instanceof EntityPlayerMP) {
            MatterOverdrive.packetPipeline.sendTo(new PacketSyncQuests(this.questData, dataTypes), (EntityPlayerMP)this.player);
        }
    }

    public void copy(MOExtendedProperties oterExtendetProperies) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        oterExtendetProperies.saveNBTData(tagCompound);
        this.loadNBTData(tagCompound);
    }

    public void addQuest(QuestStack questStack) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventQuest.Added(questStack, this.player))) {
            if (this.isServer()) {
                QuestStack addedQuest;
                if (this.questData.getActiveQuests().size() <= 0 && this.questData.getCompletedQuests().size() <= 0) {
                    this.player.field_71071_by.func_70441_a(new ItemStack((Item)MatterOverdriveItems.dataPad));
                }
                if ((addedQuest = this.questData.addQuest(questStack)) != null) {
                    addedQuest.getQuest().initQuestStack(this.player.func_70681_au(), addedQuest, this.player);
                    MatterOverdrive.packetPipeline.sendTo(new PacketUpdateQuest(addedQuest, 1), (EntityPlayerMP)this.player);
                }
            } else {
                QuestStack addedQuest = this.questData.addQuest(questStack);
                ClientProxy.questHud.addStartedQuest(addedQuest);
            }
        }
    }

    public void update(Side side) {
        if (side.equals((Object)Side.SERVER)) {
            this.questData.manageQuestCompletion();
        }
    }

    public boolean hasCompletedQuest(QuestStack questStack) {
        return this.questData.hasCompletedQuest(questStack);
    }

    public boolean hasQuest(QuestStack questStack) {
        return this.questData.hasQuest(questStack);
    }

    public void onQuestCompleted(QuestStack questStack, int index) {
        if (this.isServer()) {
            ArrayList<IQuestReward> rewards = new ArrayList<IQuestReward>();
            questStack.addRewards(rewards, this.getPlayer());
            int xp = questStack.getXP(this.getPlayer());
            MOEventQuest.Completed event = new MOEventQuest.Completed(questStack, this.player, xp, rewards);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                this.questData.addQuestToCompleted(questStack);
                this.getPlayer().func_71023_q(event.xp);
                InventoryPlayer inventoryPlayer = this.getPlayer().field_71071_by;
                for (IQuestReward reward : event.rewards) {
                    reward.giveReward(questStack, this.getPlayer());
                }
                questStack.getQuest().onCompleted(questStack, this.player);
                this.player.func_145747_a((IChatComponent)new ChatComponentText(String.format("[Matter Overdrive] %1$s completed %2$s", this.player.getDisplayName(), questStack.getTitle(this.player))));
            }
            MatterOverdrive.packetPipeline.sendTo(new PacketUpdateQuest(index, questStack, 2), (EntityPlayerMP)this.player);
        } else {
            ClientProxy.questHud.addCompletedQuest(questStack);
            this.getQuestData().getCompletedQuests().add(questStack);
            this.getQuestData().removeQuest(index);
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiDataPad) {
                ((GuiDataPad)Minecraft.func_71410_x().field_71462_r).refreshQuests(this);
            }
        }
    }

    public void onQuestAbandoned(QuestStack questStack) {
        if (!this.isServer() && Minecraft.func_71410_x().field_71462_r instanceof GuiDataPad) {
            ((GuiDataPad)Minecraft.func_71410_x().field_71462_r).refreshQuests(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateQuestFromServer(int index, QuestStack questStack) {
        if (index < this.getQuestData().getActiveQuests().size()) {
            ClientProxy.questHud.addObjectivesChanged(this.getQuestData().getActiveQuests().get(index), questStack);
            this.getQuestData().getActiveQuests().set(index, questStack);
        }
    }

    public boolean isServer() {
        return this.player != null && !this.player.field_70170_p.field_72995_K;
    }

    public PlayerQuestData getQuestData() {
        return this.questData;
    }

    public void onEvent(Event event) {
        this.questData.onEvent(event);
    }

    public void init(Entity entity, World world) {
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }
}

