/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogMessageSeedable;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.network.packet.server.PacketConversationInteract;
import matteroverdrive.network.packet.server.PacketManageConversation;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiDialog
extends GuiScreen {
    private static final int INTERACTION_DELAY = 20;
    public static final ResourceLocation separator_texture = new ResourceLocation("mo:textures/gui/elements/dialog_separator.png");
    private IDialogNpc npc;
    private EntityPlayer player;
    private long seed;
    private static Random random = new Random();
    private IDialogMessage currentMessage;
    private float lastInteractionTime;

    public GuiDialog(IDialogNpc npc, EntityPlayer player) {
        this.npc = npc;
        this.player = player;
        this.seed = random.nextLong();
        this.currentMessage = npc.getStartDialogMessage(player);
    }

    public void func_73866_w_() {
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        super.func_73863_a(mouseX, mouseY, ticks);
        if (this.npc == null || this.npc.getEntity().field_70128_L) {
            this.player.func_71053_j();
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)1.0);
        this.func_73729_b(0, 0, 0, 0, this.field_146294_l, this.field_146295_m / 8);
        this.func_73729_b(0, this.field_146295_m - this.field_146295_m / 8, 0, 0, this.field_146294_l, this.field_146295_m / 8);
        GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)0.4);
        this.func_73729_b(0, this.field_146295_m - this.field_146295_m / 8 - 128, 0, 0, this.field_146294_l, 128);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        this.drawDialog(mouseX, mouseY, ticks);
        if (this.lastInteractionTime > 0.0f) {
            this.lastInteractionTime = Math.max(0.0f, this.lastInteractionTime - ticks);
        }
    }

    public void drawDialog(int mouseX, int mouseY, float ticks) {
        int messageWidth;
        String message;
        if (this.currentMessage instanceof IDialogMessageSeedable) {
            ((IDialogMessageSeedable)((Object)this.currentMessage)).setSeed(this.seed);
        }
        if ((message = this.currentMessage.getMessageText(this.npc, this.player)) != null && !message.isEmpty()) {
            int i;
            ArrayList splitMessage = new ArrayList();
            String[] list = message.split("<br>");
            for (i = 0; i < list.length; ++i) {
                splitMessage.addAll(this.field_146289_q.func_78271_c(list[i], this.field_146294_l / 3));
            }
            for (i = 0; i < splitMessage.size(); ++i) {
                String m = ((String)splitMessage.get(i)).toString();
                messageWidth = this.field_146289_q.func_78256_a(m);
                this.field_146289_q.func_78276_b(m, this.field_146294_l / 2 - messageWidth - 16, this.field_146295_m - this.field_146295_m / 8 - 64 - splitMessage.size() * this.field_146289_q.field_78288_b / 2 + this.field_146289_q.field_78288_b * i, Reference.COLOR_HOLO.getColor());
            }
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(separator_texture);
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.5f);
        GuiDialog.func_146110_a((int)(this.field_146294_l / 2 - 5), (int)(this.field_146295_m - this.field_146295_m / 8 - 128), (float)0.0f, (float)0.0f, (int)11, (int)128, (float)11.0f, (float)128.0f);
        GL11.glDisable((int)3042);
        List<IDialogMessage> options = this.currentMessage.getOptions(this.npc, this.player);
        int visibleOptionsCount = 0;
        for (IDialogMessage option : options) {
            if (!option.isVisible(this.npc, this.player)) continue;
            ++visibleOptionsCount;
        }
        int optionPos = 0;
        for (IDialogMessage option : options) {
            if (option instanceof IDialogMessageSeedable) {
                ((IDialogMessageSeedable)((Object)option)).setSeed(this.seed);
            }
            if (!option.isVisible(this.npc, this.player)) continue;
            int messageX = this.field_146294_l / 2 + 26;
            int messageY = this.field_146295_m - this.field_146295_m / 8 - 60 + 18 * optionPos - visibleOptionsCount * 18 / 2;
            messageWidth = this.field_146289_q.func_78256_a(option.getQuestionText(this.npc, this.player));
            boolean canInteract = option.canInteract(this.npc, this.player);
            if (mouseX > messageX && mouseX <= messageX + messageWidth && mouseY > messageY && mouseY <= messageY + this.field_146289_q.field_78288_b) {
                GL11.glDisable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)0.4);
                GuiDialog.func_146110_a((int)(messageX - 2), (int)(messageY - 4), (float)0.0f, (float)0.0f, (int)(messageWidth + 10), (int)(this.field_146289_q.field_78288_b + 8), (float)(messageWidth + 8), (float)(this.field_146289_q.field_78288_b + 8));
                if (canInteract) {
                    GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)0.6);
                } else {
                    RenderUtils.applyColor(Reference.COLOR_HOLO_RED);
                }
                GuiDialog.func_146110_a((int)(messageX - 2 + messageWidth + 10), (int)(messageY - 4), (float)0.0f, (float)0.0f, (int)2, (int)(this.field_146289_q.field_78288_b + 8), (float)2.0f, (float)(this.field_146289_q.field_78288_b + 8));
                GL11.glEnable((int)3553);
                GL11.glDisable((int)3042);
                if (option.getHoloIcon(this.npc, this.player) != null) {
                    GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                    ClientProxy.holoIcons.renderIcon(option.getHoloIcon(this.npc, this.player), (double)(messageX - 18), (double)(messageY + this.field_146289_q.field_78288_b / 2 - 8), 16, 16);
                }
                this.field_146289_q.func_78276_b(option.getQuestionText(this.npc, this.player), messageX + 2, messageY, canInteract ? 0xFFFFFF : Reference.COLOR_HOLO_RED.getColor());
            } else {
                if (option.getHoloIcon(this.npc, this.player) != null) {
                    RenderUtils.applyColor(Reference.COLOR_HOLO);
                    ClientProxy.holoIcons.renderIcon(option.getHoloIcon(this.npc, this.player), (double)(messageX - 18), (double)(messageY + this.field_146289_q.field_78288_b / 2 - 8), 16, 16);
                }
                String text = option.getQuestionText(this.npc, this.player);
                this.field_146289_q.func_78276_b(text, messageX, messageY, canInteract ? Reference.COLOR_HOLO.getColor() : Reference.COLOR_HOLO_RED.getColor());
            }
            ++optionPos;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        List<IDialogMessage> options = this.currentMessage.getOptions(this.npc, this.player);
        int visibleOptionsCount = 0;
        for (IDialogMessage option : options) {
            if (!option.isVisible(this.npc, this.player)) continue;
            ++visibleOptionsCount;
        }
        int optionPos = 0;
        int optionIndex = 0;
        for (IDialogMessage option : options) {
            if (option.isVisible(this.npc, this.player)) {
                if (option.canInteract(this.npc, this.player)) {
                    if (option instanceof IDialogMessageSeedable) {
                        ((IDialogMessageSeedable)((Object)option)).setSeed(this.seed);
                    }
                    int messageX = this.field_146294_l / 2 + 26;
                    int messageY = this.field_146295_m - this.field_146295_m / 8 - 60 + 18 * optionPos - visibleOptionsCount * 18 / 2;
                    int messageWidth = this.field_146289_q.func_78256_a(option.getQuestionText(this.npc, this.player));
                    if (mouseX > messageX && mouseX <= messageX + messageWidth && mouseY > messageY && mouseY <= messageY + this.field_146289_q.field_78288_b) {
                        this.onQuestionClick(this.currentMessage, optionIndex);
                        return;
                    }
                }
                ++optionPos;
            }
            ++optionIndex;
        }
    }

    protected void onQuestionClick(IDialogMessage message, int option) {
        if (this.lastInteractionTime <= 0.0f) {
            this.lastInteractionTime = 20.0f;
            message.onOptionsInteract(this.npc, this.player, option);
            MatterOverdrive.packetPipeline.sendToServer(new PacketConversationInteract(this.npc, message, option));
        }
    }

    public void func_146281_b() {
        this.npc.setDialogPlayer(null);
        MatterOverdrive.packetPipeline.sendToServer(new PacketManageConversation(this.npc, false));
    }

    public IDialogNpc getNpc() {
        return this.npc;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public EntityLivingBase getCharacterInView() {
        return this.npc.getEntity();
    }

    public boolean func_73868_f() {
        return false;
    }

    public long getSeed() {
        return this.seed;
    }

    public IDialogMessage getCurrentMessage() {
        return this.currentMessage;
    }

    public void setCurrentMessage(IDialogMessage dialogMessage) {
        this.seed = random.nextLong();
        this.currentMessage = dialogMessage;
    }
}

