/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayDeque;
import java.util.Queue;
import matteroverdrive.Reference;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.client.data.Color;
import matteroverdrive.util.animation.MOAnimationTimeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiQuestHud {
    private static final float QUEST_NOTIFICATION_TIME = 400.0f;
    private static final float QUEST_FADE_IN_TIME = 30.0f;
    private static final float QUEST_FADE_OUT_TIME = 60.0f;
    private static final float OBJECTIVES_NOTIFICATION_TIME = 200.0f;
    private static final float OBJECTIVES_FADE_TIME = 20.0f;
    private Queue<QuestStack> completedQuestQueue = new ArrayDeque<QuestStack>();
    private Queue<QuestStack> startedQuestQueue = new ArrayDeque<QuestStack>();
    private Queue<QuestStack[]> objectivesChangedQueue = new ArrayDeque<QuestStack[]>();
    private String completeQuestName;
    private int completeQuestXp;
    private String newQuestName;
    private String[] objectivesChanged;
    private MOAnimationTimeline completeQuestTimeline = new MOAnimationTimeline(400.0f, false, false, 1.0f);
    private MOAnimationTimeline startedQuestTimeline;
    private MOAnimationTimeline objectivesTimeline;

    public GuiQuestHud() {
        this.completeQuestTimeline.setAutoLength(true);
        this.completeQuestTimeline.addSlice(new MOAnimationTimeline.Slice(0.0f, 1.0f, 0.0f, 30.0f, new MOAnimationTimeline.Easing.QuadEaseIn()));
        this.completeQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 1.0f, 30.0f, 340.0f, null));
        this.completeQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 0.0f, 340.0f, 60.0f, new MOAnimationTimeline.Easing.QuadEaseOut()));
        this.startedQuestTimeline = new MOAnimationTimeline(400.0f, false, false, 1.0f);
        this.startedQuestTimeline.setAutoLength(true);
        this.startedQuestTimeline.addSlice(new MOAnimationTimeline.Slice(0.0f, 1.0f, 0.0f, 30.0f, new MOAnimationTimeline.Easing.QuadEaseIn()));
        this.startedQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 1.0f, 30.0f, 340.0f, null));
        this.startedQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 0.0f, 340.0f, 20.0f, new MOAnimationTimeline.Easing.QuadEaseOut()));
        this.objectivesTimeline = new MOAnimationTimeline(200.0f, false, false, 1.0f);
        this.objectivesTimeline.setAutoLength(true);
        this.objectivesTimeline.addSlice(new MOAnimationTimeline.Slice(0.0f, 1.0f, 0.0f, 20.0f, new MOAnimationTimeline.Easing.QuadEaseIn()));
        this.objectivesTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 1.0f, 30.0f, 340.0f, null));
        this.objectivesTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 0.0f, 180.0f, 20.0f, new MOAnimationTimeline.Easing.QuadEaseOut()));
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            int y;
            Color color;
            float time;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            if (this.completeQuestTimeline.isPlaying() && this.completeQuestName != null) {
                time = this.completeQuestTimeline.getCurrentValue();
                color = new Color(Reference.COLOR_HOLO.getIntR(), Reference.COLOR_HOLO.getIntG(), Reference.COLOR_HOLO.getIntB(), 20 + (int)(235.0f * time));
                GL11.glPushMatrix();
                y = (int)((double)event.resolution.func_78328_b() * 0.15);
                int titleWidth = (int)((double)fontRenderer.func_78256_a(this.completeQuestName) * 1.5);
                GL11.glTranslated((double)((float)(event.resolution.func_78326_a() - titleWidth - 30) - time * 30.0f), (double)(y - 20), (double)0.0);
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                fontRenderer.func_78261_a(EnumChatFormatting.BOLD + this.completeQuestName, 0, 40, color.getColor());
                GL11.glPopMatrix();
                fontRenderer.func_78261_a("Completed:", event.resolution.func_78326_a() - titleWidth - 20 - (int)(time * 40.0f), y + 28, color.getColor());
                if (this.completeQuestXp > 0) {
                    fontRenderer.func_78261_a(String.format("+%dxp", (int)(time * (float)this.completeQuestXp)), event.resolution.func_78326_a() - 50 - (int)(20.0f * time), y + 58, color.getColor());
                }
            }
            if (this.startedQuestTimeline.isPlaying() && this.newQuestName != null) {
                time = this.startedQuestTimeline.getCurrentValue();
                color = new Color(Reference.COLOR_HOLO.getIntR(), Reference.COLOR_HOLO.getIntG(), Reference.COLOR_HOLO.getIntB(), 20 + (int)(235.0f * time));
                GL11.glPushMatrix();
                y = (int)((double)event.resolution.func_78328_b() * 0.65);
                String title = "Dead! We're all dead!";
                GL11.glTranslated((double)(-10.0f + time * 30.0f), (double)y, (double)0.0);
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                fontRenderer.func_78261_a(EnumChatFormatting.BOLD + this.newQuestName, 0, 0, color.getColor());
                GL11.glPopMatrix();
                fontRenderer.func_78261_a("Started:", (int)(time * 20.0f), y - 12, color.getColor());
            }
            if (this.objectivesTimeline.isPlaying() && this.objectivesChanged != null) {
                time = this.objectivesTimeline.getCurrentValue();
                color = new Color(Reference.COLOR_HOLO.getIntR(), Reference.COLOR_HOLO.getIntG(), Reference.COLOR_HOLO.getIntB(), 20 + (int)(235.0f * time));
                int objectivesY = 0;
                for (int i = 0; i < this.objectivesChanged.length; ++i) {
                    if (this.objectivesChanged[i] == null) continue;
                    fontRenderer.func_78261_a(String.format("[ %s ]", this.objectivesChanged[i]), (int)(time * 20.0f), (int)((double)event.resolution.func_78328_b() * 0.5) + objectivesY, color.getColor());
                    objectivesY += fontRenderer.field_78288_b + 2;
                }
            }
            this.startedQuestTimeline.tick(event.partialTicks);
            this.completeQuestTimeline.tick(event.partialTicks);
            this.objectivesTimeline.tick(event.partialTicks);
        }
    }

    public void onTick() {
        if (!(this.completedQuestQueue.isEmpty() || this.completeQuestTimeline.isPlaying() || this.startedQuestTimeline.isPlaying())) {
            this.startCompleteQuestNotification(this.completedQuestQueue.poll());
        }
        if (!(this.startedQuestQueue.isEmpty() || this.startedQuestTimeline.isPlaying() || this.completeQuestTimeline.isPlaying())) {
            this.startNewQuestNotification(this.startedQuestQueue.poll());
        }
        if (!this.objectivesChangedQueue.isEmpty() && !this.objectivesTimeline.isPlaying()) {
            QuestStack[] questStacks = this.objectivesChangedQueue.poll();
            this.startObjectivesChanged(questStacks[0], questStacks[1]);
        }
    }

    public void startCompleteQuestNotification(QuestStack questStack) {
        Minecraft.func_71410_x().field_71439_g.func_85030_a("mo:quest_complete", 1.0f, 1.0f);
        if (questStack != null) {
            this.completeQuestName = questStack.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.completeQuestXp = questStack.getXP((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        } else {
            this.completeQuestName = "Test. This is a test";
            this.completeQuestXp = 256;
        }
        this.completeQuestTimeline.getSlice(1).setLength(this.completeQuestName.length() * 15);
        this.completeQuestTimeline.sort();
        this.completeQuestTimeline.replay();
    }

    public void startNewQuestNotification(QuestStack questStack) {
        Minecraft.func_71410_x().field_71439_g.func_85030_a("mo:quest_started", 1.0f, 1.0f);
        this.newQuestName = questStack != null ? questStack.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g) : "Test. This is a test";
        this.startedQuestTimeline.getSlice(1).setLength(100 + this.newQuestName.length() * 5);
        this.startedQuestTimeline.sort();
        this.startedQuestTimeline.replay();
    }

    public void startObjectivesChanged(QuestStack oldQuestStack, QuestStack newQuestStack) {
        int showTime = 0;
        if (newQuestStack != null) {
            int objectiveCount = newQuestStack.getObjectivesCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.objectivesChanged = new String[objectiveCount];
            for (int i = 0; i < objectiveCount; ++i) {
                String oldObjective;
                String newObjective = newQuestStack.getObjective((EntityPlayer)Minecraft.func_71410_x().field_71439_g, i);
                if (newObjective.contentEquals(oldObjective = oldQuestStack.getObjective((EntityPlayer)Minecraft.func_71410_x().field_71439_g, i))) continue;
                this.objectivesChanged[i] = newObjective;
                showTime = Math.max(showTime, this.objectivesChanged[i].length() * 4);
            }
        } else {
            this.objectivesChanged = new String[]{"Objectives changed 0/5", "Objectives changed 0/5"};
        }
        this.objectivesTimeline.getSlice(1).setLength(showTime);
        this.objectivesTimeline.sort();
        this.objectivesTimeline.replay();
    }

    public void addCompletedQuest(QuestStack questStack) {
        this.completedQuestQueue.add(questStack);
    }

    public void addStartedQuest(QuestStack questStack) {
        this.startedQuestQueue.add(questStack);
    }

    public void addObjectivesChanged(QuestStack oldQuestStack, QuestStack newQestStack) {
        this.objectivesChangedQueue.add(new QuestStack[]{oldQuestStack, newQestStack});
        if (this.objectivesTimeline.getTime() < 180.0f) {
            this.objectivesTimeline.setTime(180.0f);
        }
    }
}

