/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.Collection;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.renderer.ISpaceBodyHoloRenderer;
import matteroverdrive.client.data.Color;
import matteroverdrive.container.ContainerStarMap;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.pages.starmap.PageGalaxy;
import matteroverdrive.gui.pages.starmap.PagePlanetMenu;
import matteroverdrive.gui.pages.starmap.PagePlanetStats;
import matteroverdrive.gui.pages.starmap.PageQuadrant;
import matteroverdrive.gui.pages.starmap.PageStar;
import matteroverdrive.network.packet.server.starmap.PacketStarMapClientCommands;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.starmap.data.TravelEvent;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class GuiStarMap
extends MOGuiMachine<TileEntityMachineStarMap> {
    public static ScaleTexture BG = new ScaleTexture(new ResourceLocation("mo:textures/gui/star_map.png"), 255, 141).setOffsets(213, 34, 42, 94);
    Minecraft field_146297_k = Minecraft.func_71410_x();
    IModelCustom sphere = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("mo:models/block/sphere.obj"));
    PagePlanetMenu planetPage;
    PageGalaxy pageGalaxy;
    PageQuadrant pageQuadrant;
    PageStar pageStar;
    PagePlanetStats pagePlanetStats;

    public GuiStarMap(InventoryPlayer inventoryPlayer, TileEntityMachineStarMap machine) {
        super(new ContainerStarMap(inventoryPlayer, machine), machine, 480, 360);
        this.background = BG;
        this.texW = 255;
        this.texH = 237;
        this.slotsList.getElements().clear();
        this.sidePannel.BACKGROUND_TEXTURE.setLocation(new ResourceLocation("mo:textures/gui/elements/right_side_bar_panel_bg_holo.png"));
        this.sidePannel.setOpenable(false);
        this.sidePannel.setOpen(true);
    }

    @Override
    public void registerPages(MOBaseContainer container, TileEntityMachineStarMap starMap) {
        this.pageGalaxy = new PageGalaxy(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        this.pageGalaxy.setName("Galaxy");
        this.AddPage(this.pageGalaxy, ClientProxy.holoIcons.getIcon("page_icon_galaxy"), MOStringHelper.translateToLocal("gui.tooltip.page.galaxy")).setIconColor(Reference.COLOR_MATTER);
        this.pageQuadrant = new PageQuadrant(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        this.pageQuadrant.setName("Quadrant");
        this.AddPage(this.pageQuadrant, ClientProxy.holoIcons.getIcon("page_icon_quadrant"), MOStringHelper.translateToLocal("gui.tooltip.page.quadrant")).setIconColor(Reference.COLOR_MATTER);
        this.pageStar = new PageStar(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        this.pageStar.setName("Star");
        this.AddPage(this.pageStar, ClientProxy.holoIcons.getIcon("page_icon_star"), MOStringHelper.translateToLocal("gui.tooltip.page.star")).setIconColor(Reference.COLOR_MATTER);
        this.planetPage = new PagePlanetMenu(this, 0, 0, this.field_146294_l, this.field_146295_m, (ContainerStarMap)container, starMap);
        this.planetPage.setName("Planet");
        this.AddPage(this.planetPage, ClientProxy.holoIcons.getIcon("page_icon_planet"), MOStringHelper.translateToLocal("gui.tooltip.page.planet")).setIconColor(Reference.COLOR_MATTER);
        this.pagePlanetStats = new PagePlanetStats(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        this.pagePlanetStats.setName("Planet Stats");
        this.AddPage(this.pagePlanetStats, ClientProxy.holoIcons.getIcon("icon_stats"), MOStringHelper.translateToLocal("gui.tooltip.page.planet_stats")).setIconColor(Reference.COLOR_MATTER);
        this.setPage(((TileEntityMachineStarMap)this.machine).getZoomLevel());
    }

    @Override
    protected void func_146976_a(float partialTick, int x, int y) {
        Collection<ISpaceBodyHoloRenderer> renderers;
        super.func_146976_a(partialTick, x, y);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        if (((TileEntityMachineStarMap)this.machine).getActiveSpaceBody() != null && (renderers = ClientProxy.renderHandler.getStarmapRenderRegistry().getStarmapRendererCollection(((TileEntityMachineStarMap)this.machine).getActiveSpaceBody().getClass())) != null) {
            for (ISpaceBodyHoloRenderer renderer : renderers) {
                if (!renderer.displayOnZoom(((TileEntityMachineStarMap)this.machine).getZoomLevel(), ((TileEntityMachineStarMap)this.machine).getActiveSpaceBody())) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)((double)this.field_146999_f / 1.9), (double)(this.field_147000_g - 16), (double)0.0);
                if (((TileEntityMachineStarMap)this.machine).getActiveSpaceBody() != null) {
                    renderer.renderGUIInfo(GalaxyClient.getInstance().getTheGalaxy(), ((TileEntityMachineStarMap)this.machine).getActiveSpaceBody(), (TileEntityMachineStarMap)this.machine, partialTick, 0.8f);
                }
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public void func_146270_b(int p_146270_1_) {
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        RenderUtils.drawPlane(0.0, 0.0, -1000.0, this.field_146294_l, this.field_146295_m);
        GL11.glEnable((int)3553);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)16384);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Project.gluPerspective((float)75.0f, (float)((float)this.field_146297_k.field_71443_c / (float)this.field_146297_k.field_71440_d), (float)0.05f, (float)20.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glRotated((double)15.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslatef((float)0.0f, (float)-0.8f, (float)0.0f);
        float lastRotationYaw = Minecraft.func_71410_x().field_71451_h.field_70177_z;
        float lastRotationPitch = Minecraft.func_71410_x().field_71451_h.field_70125_A;
        float rotation = 0.0f;
        if (((TileEntityMachineStarMap)this.machine).getZoomLevel() <= 2) {
            rotation = (float)this.field_146297_k.field_71441_e.func_72820_D() * 0.1f;
        }
        Minecraft.func_71410_x().field_71451_h.field_70177_z = 180.0f + rotation;
        Minecraft.func_71410_x().field_71451_h.field_70125_A = 15.0f;
        Minecraft.func_71410_x().field_71451_h.field_70127_C = 15.0f;
        switch (((TileEntityMachineStarMap)this.machine).getZoomLevel()) {
            case 0: {
                GL11.glTranslated((double)0.0, (double)-1.1, (double)-4.0);
                break;
            }
            case 1: {
                GL11.glTranslated((double)0.0, (double)-0.6, (double)-4.0);
                break;
            }
            case 2: {
                Star star = ((TileEntityMachineStarMap)this.machine).getStar();
                float maxDistance = 0.0f;
                if (star != null) {
                    for (Planet planet : star.getPlanets()) {
                        if (!(maxDistance < planet.getOrbit())) continue;
                        maxDistance = planet.getOrbit();
                    }
                }
                GL11.glTranslated((double)0.0, (double)0.0, (double)(-maxDistance * 3.0f - 1.5f));
                break;
            }
            default: {
                GL11.glTranslatef((float)0.0f, (float)0.1f, (float)-3.0f);
            }
        }
        GL11.glRotated((double)rotation, (double)0.0, (double)1.0, (double)0.0);
        ClientProxy.renderHandler.getTileEntityRendererStarMap().render((TileEntityMachineStarMap)this.machine, -0.5, -1.8f, -0.5, 0.0f);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71451_h.field_70177_z = lastRotationYaw;
        Minecraft.func_71410_x().field_71451_h.field_70127_C = Minecraft.func_71410_x().field_71451_h.field_70125_A = lastRotationPitch;
        GL11.glPopAttrib();
    }

    @Override
    public void onPageChange(int newPage) {
        this.pageQuadrant.init();
        this.pageStar.init();
        this.planetPage.init();
        this.pagePlanetStats.init();
        if (newPage != ((TileEntityMachineStarMap)this.machine).getZoomLevel()) {
            MatterOverdrive.packetPipeline.sendToServer(new PacketStarMapClientCommands((TileEntityMachineStarMap)this.machine, newPage, ((TileEntityMachineStarMap)this.machine).getGalaxyPosition(), ((TileEntityMachineStarMap)this.machine).getDestination()));
        }
    }

    public void onPlanetChange(Planet planet) {
        this.pageStar.init();
        this.pagePlanetStats.loadShips();
        this.planetPage.init();
    }

    public void onTravelEventsChange(List<TravelEvent> travelEvents) {
        this.pagePlanetStats.init();
    }

    @Override
    public void func_73866_w_() {
        this.field_146999_f = this.field_146294_l;
        this.field_147000_g = this.field_146295_m;
        this.pageGalaxy.setSize(this.field_146294_l, this.field_146295_m);
        this.pageQuadrant.setSize(this.field_146294_l, this.field_146295_m);
        this.pageStar.setSize(this.field_146294_l, this.field_146295_m);
        this.sidePannel.setPosition(this.field_146999_f - 42, 16);
        super.func_73866_w_();
        this.indicator.setVisible(false);
        this.AddMainPlayerSlots(this.field_147002_h, this, "holo_with_BG", new Color(Reference.COLOR_HOLO.getIntR() / 3, Reference.COLOR_HOLO.getIntG() / 3, Reference.COLOR_HOLO.getIntB() / 3), 45, this.field_147000_g - 104);
        this.AddHotbarPlayerSlots(this.field_147002_h, this, "holo_with_BG", new Color(Reference.COLOR_HOLO.getIntR() / 2, Reference.COLOR_HOLO.getIntG() / 2, Reference.COLOR_HOLO.getIntB() / 2), 45, this.field_147000_g - 25);
    }

    public void func_146281_b() {
    }

    @Override
    protected void updateElementInformation() {
        if (((TileEntityMachineStarMap)this.machine).getZoomLevel() != this.currentPage) {
            this.setPage(((TileEntityMachineStarMap)this.machine).getZoomLevel());
        }
        super.updateElementInformation();
        ((MOElementButton)this.pageButtons.get(4)).setVisible(((TileEntityMachineStarMap)this.machine).getPlanet() != null);
        ((MOElementButton)this.pageButtons.get(3)).setVisible(((TileEntityMachineStarMap)this.machine).getPlanet() != null);
        ((MOElementButton)this.pageButtons.get(2)).setVisible(((TileEntityMachineStarMap)this.machine).getStar() != null);
        ((MOElementButton)this.pageButtons.get(1)).setVisible(((TileEntityMachineStarMap)this.machine).getQuadrant() != null);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }
}

