/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.container.slot.SlotPlayerInventory;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.GuiElementList;
import matteroverdrive.gui.element.CloseButton;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementIconButton;
import matteroverdrive.gui.element.SidePannel;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.gui.events.ITextHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class MOGuiBase
extends GuiContainer
implements IButtonHandler,
ITextHandler,
IListHandler,
GuiElementList {
    public static final SoundHandler guiSoundManager = FMLClientHandler.instance().getClient().func_147118_V();
    protected int currentPage = -1;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected SidePannel sidePannel;
    protected CloseButton closeButton;
    ScaleTexture background = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/base_gui_hotbar.png"), 92, 77);
    protected List<ElementBaseGroup> pages;
    protected List<MOElementButton> pageButtons;
    protected ArrayList<MOElementBase> elements;
    protected List<String> tooltip;
    protected boolean tooltips = true;
    protected String name;
    protected int lastIndex = -1;
    int texW;
    int texH;

    public MOGuiBase(MOBaseContainer container) {
        this(container, 225, 186);
    }

    public MOGuiBase(MOBaseContainer container, int width, int height) {
        super((Container)container);
        this.background.setOffsets(57, 34, 42, 34);
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.sidePannel = new SidePannel(this, this.field_146999_f - 12, 33, this.field_147000_g - 34);
        this.closeButton = new CloseButton(this, this, this.field_146999_f - 17, 6, "close");
        this.texW = 224;
        this.texH = 176;
        this.field_146294_l = width;
        this.field_146295_m = height;
        this.pages = new ArrayList<ElementBaseGroup>(3);
        this.pageButtons = new ArrayList<MOElementButton>(3);
        this.tooltip = new LinkedList<String>();
        this.elements = new ArrayList();
        this.registerPages(container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.elements.clear();
        for (ElementBaseGroup page : this.pages) {
            page.init();
            this.addElement(page);
        }
        this.addElement(this.sidePannel);
        this.sidePannel.init();
        this.addElement(this.closeButton);
        for (MOElementButton button : this.pageButtons) {
            this.sidePannel.addElement(button);
        }
        this.setPage(this.currentPage);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.updateElementInformation();
        super.func_73863_a(mouseX, mouseY, partialTick);
        if (this.tooltips && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null) {
            this.addTooltips(this.tooltip);
            this.drawTooltip(this.tooltip);
        }
        this.mouseX = mouseX - this.field_147003_i;
        this.mouseY = mouseY - this.field_147009_r;
        this.updateElements();
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.background != null) {
            this.background.render(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        }
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(partialTick, false);
        GL11.glPopMatrix();
    }

    protected void drawElements(float partialTicks, boolean foreground) {
        if (foreground) {
            for (int i = 0; i < this.elements.size(); ++i) {
                MOElementBase element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawForeground(this.mouseX, this.mouseY);
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                MOElementBase element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawBackground(this.mouseX, this.mouseY, partialTicks);
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawElements(0.0f, true);
    }

    public void addTooltips(List<String> list) {
        int i = this.elements.size();
        while (i-- > 0) {
            MOElementBase element = this.elements.get(i);
            if (!(element instanceof MOElementBase) || !element.isVisible() || !element.intersectsWith(this.mouseX, this.mouseY)) continue;
            element.addTooltip(list, this.mouseX, this.mouseY);
        }
    }

    public void drawTooltip(List<String> tooltips) {
        this.drawTooltipHoveringText(tooltips, this.mouseX + this.field_147003_i, this.mouseY + this.field_147009_r, this.field_146289_q);
        this.tooltip.clear();
    }

    protected void drawTooltipHoveringText(List list, int x, int y, FontRenderer font) {
        if (list == null || list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        for (String s : list) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int i1 = x + 12;
        int j1 = y - 12;
        int k1 = 8;
        if (list.size() > 1) {
            k1 += 2 + (list.size() - 1) * 10;
        }
        if (i1 + k > this.field_146294_l) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.field_146295_m) {
            j1 = this.field_146295_m - k1 - 6;
        }
        this.field_73735_i = 300.0f;
        MOGuiBase.field_146296_j.field_77023_b = 300.0f;
        int l1 = -267386864;
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        int i2 = 0x505000FF;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            String s1 = (String)list.get(k2);
            font.func_78261_a(s1, i1, j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        MOGuiBase.field_146296_j.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        for (int i = 0; i < this.pageButtons.size(); ++i) {
            if (i >= this.pages.size() || !this.pageButtons.get(i).equals(element)) continue;
            this.setPage(i);
        }
    }

    protected void func_73869_a(char character, int state) {
        MOElementBase element;
        int elementsCount = this.elements.size();
        do {
            if (elementsCount-- > 0) continue;
            super.func_73869_a(character, state);
            return;
        } while (!(element = this.elements.get(elementsCount)).isVisible() || !element.isEnabled() || !element.onKeyTyped(character, state));
    }

    public void func_146274_d() {
        int var1 = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int var2 = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = var1 - this.field_147003_i;
        this.mouseY = var2 - this.field_147009_r;
        int var3 = Mouse.getEventDWheel();
        if (var3 != 0) {
            int var4 = this.elements.size();
            while (var4-- > 0) {
                MOElementBase var5 = this.elements.get(var4);
                if (!var5.isVisible() || !var5.isEnabled() || !var5.intersectsWith(this.mouseX, this.mouseY) || !var5.onMouseWheel(this.mouseX, this.mouseY, var3)) continue;
                return;
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        MOElementBase var5;
        mouseX -= this.field_147003_i;
        mouseY -= this.field_147009_r;
        int var4 = this.elements.size();
        do {
            if (var4-- > 0) continue;
            super.func_73864_a(mouseX += this.field_147003_i, mouseY += this.field_147009_r, mouseButton);
            return;
        } while (!(var5 = this.elements.get(var4)).isVisible() || !var5.isEnabled() || !var5.intersectsWith(mouseX, mouseY) || !var5.onMousePressed(mouseX, mouseY, mouseButton));
    }

    protected void func_146286_b(int var1, int var2, int var3) {
        var1 -= this.field_147003_i;
        var2 -= this.field_147009_r;
        if (var3 >= 0 && var3 <= 2) {
            int var4 = this.elements.size();
            while (var4-- > 0) {
                MOElementBase var5 = this.elements.get(var4);
                if (!var5.isVisible() || !var5.isEnabled()) continue;
                var5.onMouseReleased(var1, var2);
            }
        }
        super.func_146286_b(var1 += this.field_147003_i, var2 += this.field_147009_r, var3);
    }

    protected void func_146273_a(int var1, int var2, int var3, long var4) {
        this.lastIndex = -1;
        super.func_146273_a(var1, var2, var3, var4);
    }

    public void mouseClicked(int var1) {
        super.func_73864_a(this.field_147003_i + this.mouseX, this.field_147009_r + this.mouseY, var1);
    }

    public boolean func_146981_a(Slot var1, int var2, int var3) {
        return this.func_146978_c(var1.field_75223_e, var1.field_75221_f, 16, 16, var2, var3);
    }

    protected void updateElementInformation() {
        int i;
        for (i = 0; i < this.pageButtons.size(); ++i) {
            this.pageButtons.get(i).setPosition(6, 8 + (this.pageButtons.get(i).getHeight() + 2) * i);
        }
        i = this.elements.size();
        while (i-- > 0) {
            if (!(this.elements.get(i) instanceof MOElementBase)) continue;
            this.elements.get(i).updateInfo();
        }
    }

    protected final void updateElements() {
        int elementCount = this.elements.size();
        while (elementCount-- > 0) {
            MOElementBase element = this.elements.get(elementCount);
            if (!element.isVisible() || !element.isEnabled()) continue;
            element.update(this.mouseX, this.mouseY);
        }
    }

    protected void AddMainPlayerSlots(Container container, GuiElementList elements) {
        this.AddPlayerSlots(45, this.field_147000_g - 106, container, elements, true, false, "small", null);
    }

    protected void AddHotbarPlayerSlots(Container container, GuiElementList elements) {
        this.AddPlayerSlots(45, this.field_147000_g - 27, container, elements, false, true, "small", null);
    }

    protected void AddMainPlayerSlots(Container container, GuiElementList elements, String type, Color color, int x, int y) {
        this.AddPlayerSlots(x, y, container, elements, true, false, type, color);
    }

    protected void AddHotbarPlayerSlots(Container container, GuiElementList elements, String type, Color color, int x, int y) {
        this.AddPlayerSlots(x, y, container, elements, false, true, type, color);
    }

    protected void AddPlayerSlots(int x, int y, Container container, GuiElementList elements, boolean main, boolean hotbar, String type, Color color) {
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            ElementInventorySlot inventorySlot;
            if (!(container.field_75151_b.get(i) instanceof SlotPlayerInventory)) continue;
            SlotPlayerInventory slot = (SlotPlayerInventory)((Object)container.field_75151_b.get(i));
            if (main && !slot.isHotbar()) {
                inventorySlot = new ElementInventorySlot(this, slot, 18, 18, type);
                inventorySlot.setColor(color);
                inventorySlot.setPosition(x + 18 * (slot.getSlotIndex() % 9), y + 18 * (slot.getSlotIndex() / 9));
                elements.addElement(inventorySlot);
                continue;
            }
            if (!hotbar || !slot.isHotbar()) continue;
            inventorySlot = new ElementInventorySlot(this, slot, 18, 18, type);
            inventorySlot.setColor(color);
            inventorySlot.setPosition(x + 18 * (slot.getSlotIndex() % 9), y);
            elements.addElement(inventorySlot);
        }
    }

    public void drawSizedModalRect(int x1, int y1, int x2, int y2, int color) {
        int var6;
        if (x1 < x2) {
            var6 = x1;
            x1 = x2;
            x2 = var6;
        }
        if (y1 < y2) {
            var6 = y1;
            y1 = y2;
            y2 = var6;
        }
        float var7 = (float)(color >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(color >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(color >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(color & 0xFF) / 255.0f;
        Tessellator var11 = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)var8, (float)var9, (float)var10, (float)var7);
        var11.func_78382_b();
        var11.func_78377_a((double)x1, (double)y2, (double)this.field_73735_i);
        var11.func_78377_a((double)x2, (double)y2, (double)this.field_73735_i);
        var11.func_78377_a((double)x2, (double)y1, (double)this.field_73735_i);
        var11.func_78377_a((double)x1, (double)y1, (double)this.field_73735_i);
        var11.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawSizedRect(int x1, int y1, int x2, int y2, int color) {
        int var6;
        if (x1 < x2) {
            var6 = x1;
            x1 = x2;
            x2 = var6;
        }
        if (y1 < y2) {
            var6 = y1;
            y1 = y2;
            y2 = var6;
        }
        float var7 = (float)(color >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(color >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(color >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(color & 0xFF) / 255.0f;
        Tessellator var11 = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)var8, (float)var9, (float)var10, (float)var7);
        var11.func_78382_b();
        var11.func_78377_a((double)x1, (double)y2, (double)this.field_73735_i);
        var11.func_78377_a((double)x2, (double)y2, (double)this.field_73735_i);
        var11.func_78377_a((double)x2, (double)y1, (double)this.field_73735_i);
        var11.func_78377_a((double)x1, (double)y1, (double)this.field_73735_i);
        var11.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float var9 = 1.0f / texW;
        float var10 = 1.0f / texH;
        Tessellator var11 = Tessellator.field_78398_a;
        var11.func_78382_b();
        var11.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + 0) * var9), (double)((float)(v + height) * var10));
        var11.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * var9), (double)((float)(v + height) * var10));
        var11.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + width) * var9), (double)((float)(v + 0) * var10));
        var11.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + 0) * var9), (double)((float)(v + 0) * var10));
        var11.func_78381_a();
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        if (icon != null) {
            double var6 = icon.func_94209_e();
            double var8 = icon.func_94212_f();
            double var10 = icon.func_94206_g();
            double var12 = icon.func_94210_h();
            Tessellator var14 = Tessellator.field_78398_a;
            var14.func_78382_b();
            var14.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, var6, var10 + (var12 - var10) * (double)height / 16.0);
            var14.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, var6 + (var8 - var6) * (double)width / 16.0, var10 + (var12 - var10) * (double)height / 16.0);
            var14.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, var6 + (var8 - var6) * (double)width / 16.0, var10);
            var14.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, var6, var10);
            var14.func_78381_a();
        }
    }

    public void onPageChange(int newPage) {
    }

    public void handleListChange(String listName, int mouseButton, int element) {
    }

    public void registerPages(MOBaseContainer container) {
    }

    public void setPage(int page) {
        if (this.currentPage != (page = MathHelper.func_76125_a((int)page, (int)0, (int)(this.pages.size() - 1)))) {
            this.onPageChange(page);
        }
        this.currentPage = page;
        for (int i = 0; i < this.pages.size(); ++i) {
            this.pages.get(i).setVisible(i == this.currentPage);
            if (i >= this.pageButtons.size()) continue;
            this.pageButtons.get(i).setEnabled(i != this.currentPage);
        }
    }

    protected MOElementBase getElementAtPosition(int mX, int mY) {
        int i = this.elements.size();
        while (i-- > 0) {
            MOElementBase element = this.elements.get(i);
            if (!element.isVisible() || !element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public void addToTooltip(String string) {
        this.tooltip.add(string);
    }

    public List<String> getTooltips() {
        return this.tooltip;
    }

    public MOElementIconButton AddPage(ElementBaseGroup page, HoloIcon icon, String tooltip) {
        this.pages.add(page);
        MOElementIconButton button = new MOElementIconButton(this, this, 0, 0, page.getName(), 0, 0, 24, 0, 24, 0, 24, 24, "", icon);
        button.setTexture("mo:textures/gui/elements/page_button.png", 48, 24);
        button.setToolTip(tooltip);
        this.pageButtons.add(button);
        return button;
    }

    public MOBaseContainer getContainer() {
        return (MOBaseContainer)this.field_147002_h;
    }

    @Override
    public MOElementBase addElement(MOElementBase element) {
        this.elements.add(element);
        return element;
    }

    public Slot func_146975_c(int mouseX, int mouseY) {
        for (int var3 = 0; var3 < this.field_147002_h.field_75151_b.size(); ++var3) {
            Slot var4 = (Slot)this.field_147002_h.field_75151_b.get(var3);
            if (!this.func_146981_a(var4, mouseX, mouseY)) continue;
            return var4;
        }
        return null;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public static void playSound(String soundName, float volume, float pitch) {
        Minecraft.func_71410_x().field_71439_g.func_85030_a(soundName, volume, pitch);
    }

    public void bindTexture(ResourceLocation location) {
        this.field_146297_k.field_71446_o.func_110577_a(location);
    }

    public void overlayRecipe() {
    }
}

