/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.client.data.Color;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ElementDoubleCircleBar
extends MOElementBase {
    public static final ResourceLocation BG = new ResourceLocation("mo:textures/gui/elements/circle_bar.png");
    public static final ResourceLocation OVERLAY = new ResourceLocation("mo:textures/gui/elements/circle_bar_top.png");
    public static final ResourceLocation BACK = new ResourceLocation("mo:textures/gui/elements/circle_bar_bottom.png");
    private float progressLeft;
    private float progressRight;
    private Color colorLeft;
    private Color colorRight;

    public ElementDoubleCircleBar(MOGuiBase gui, int posX, int posY, int width, int height, Color color) {
        super(gui, posX, posY, width, height);
        this.colorLeft = color;
        this.colorRight = color;
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    @Override
    public void addTooltip(List<String> var1, int mouseX, int mouseY) {
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.gui.bindTexture(BACK);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.drawSizedTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY, 135.0f, 135.0f);
        this.gui.bindTexture(BG);
        GL11.glAlphaFunc((int)516, (float)(1.0f - this.progressLeft));
        if (this.colorLeft != null) {
            GL11.glColor4f((float)this.colorLeft.getFloatR(), (float)this.colorLeft.getFloatG(), (float)this.colorLeft.getFloatB(), (float)this.colorLeft.getFloatA());
        }
        this.gui.drawSizedTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX / 2, this.sizeY, 135.0f, 135.0f);
        GL11.glAlphaFunc((int)516, (float)0.2f);
        this.gui.bindTexture(BG);
        GL11.glAlphaFunc((int)516, (float)(1.0f - this.progressRight));
        if (this.colorRight != null) {
            GL11.glColor4f((float)this.colorRight.getFloatR(), (float)this.colorRight.getFloatG(), (float)this.colorRight.getFloatB(), (float)this.colorRight.getFloatA());
        }
        this.gui.drawSizedTexturedModalRect(this.posX + 67, this.posY, 67, 0, this.sizeX / 2, this.sizeY, 135.0f, 135.0f);
        GL11.glAlphaFunc((int)516, (float)0.2f);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        this.gui.bindTexture(OVERLAY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.drawSizedTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY, 135.0f, 135.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    public void setProgressLeft(float progressLeft) {
        this.progressLeft = progressLeft;
    }

    public void setProgressRight(float progressRight) {
        this.progressRight = progressRight;
    }

    public void setColorLeft(Color color) {
        this.colorLeft = color;
    }

    public void setColorRight(Color color) {
        this.colorRight = color;
    }

    public float getProgressLeft() {
        return this.progressLeft;
    }

    public float getProgressRight() {
        return this.progressRight;
    }
}

