/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ElementItemPattern
extends ElementSlot {
    ScaleTexture texture;
    ItemPattern pattern;
    ItemStack itemStack;
    int amount = 0;

    public ElementItemPattern(MOGuiBase gui, ItemPattern pattern, String bgType, int width, int height) {
        super(gui, 0, 0, width, height, bgType);
        this.texture = new ScaleTexture(ElementItemPattern.getTexture(bgType), width, height).setOffsets(2, 2, 2, 2);
        this.pattern = pattern;
        if (pattern != null) {
            this.itemStack = pattern.toItemStack(false);
            this.name = this.itemStack.func_82833_r();
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.pattern != null) {
            this.itemStack.field_77994_a = this.amount;
            RenderUtils.renderStack(this.posX + 3, this.posY + 3, 0, this.itemStack, true);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.texture.render(this.posX, this.posY, this.sizeX, this.sizeY);
    }

    @Override
    public void addTooltip(List<String> list, int mouseX, int mouseY) {
        if (this.pattern != null && this.itemStack != null) {
            list.addAll(this.itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false));
            String name = list.get(0);
            int progress = this.pattern.getProgress();
            name = MatterDatabaseHelper.getPatternInfoColor(progress) + name + " [" + progress + "%]";
            list.set(0, name);
        }
    }

    public ItemPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ItemPattern pattern) {
        this.pattern = pattern;
        if (this.pattern != null) {
            this.itemStack = pattern.toItemStack(false);
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public ScaleTexture getTexture() {
        return this.texture;
    }
}

