/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element.starmap;

import java.util.ArrayList;
import matteroverdrive.Reference;
import matteroverdrive.api.starmap.IBuilding;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ElementSlotBuilding
extends ElementInventorySlot {
    TileEntityMachineStarMap starMap;

    public ElementSlotBuilding(MOGuiBase gui, MOSlot slot, int posX, int posY, int width, int height, String type, HoloIcon icon, TileEntityMachineStarMap starMap) {
        super(gui, slot, posX, posY, width, height, type, icon);
        this.starMap = starMap;
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.starMap.getPlanet() != null && this.getSlot().func_75211_c() != null && this.getSlot().func_75211_c().func_77973_b() instanceof IBuilding) {
            ArrayList<String> info = new ArrayList<String>();
            if (this.starMap.getPlanet().canBuild((IBuilding)this.getSlot().func_75211_c().func_77973_b(), this.getSlot().func_75211_c(), info)) {
                ItemStack buildingStack = this.getSlot().func_75211_c();
                long remainningTime = ((IBuilding)buildingStack.func_77973_b()).getRemainingBuildTimeTicks(buildingStack, this.starMap.getPlanet(), (World)Minecraft.func_71410_x().field_71441_e) / 20L;
                if (remainningTime >= 0L) {
                    String time = MOStringHelper.formatRemainingTime(remainningTime);
                    int timeWidth = this.getFontRenderer().func_78256_a(time);
                    this.getFontRenderer().func_78276_b(time, this.posX - timeWidth - 4, this.posY + 6, Reference.COLOR_HOLO.getColor());
                }
            } else {
                String infoText = String.join((CharSequence)". ", info);
                int width = this.getFontRenderer().func_78256_a(infoText);
                this.getFontRenderer().func_78276_b(infoText, this.posX - width - 4, this.posY + 7, Reference.COLOR_HOLO_RED.getColor());
            }
        }
    }
}

