/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.machines.IUpgradeHandler;
import matteroverdrive.client.data.Color;
import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.container.slot.SlotInventory;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.UpgradeSlot;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class PageUpgrades
extends ElementBaseGroup {
    Container container;
    MOGuiMachine guiMachine;

    public PageUpgrades(MOGuiMachine gui, int posX, int posY, Container container) {
        this(gui, posX, posY, 0, 0, container);
    }

    public PageUpgrades(MOGuiMachine gui, int posX, int posY, int width, int height, Container container) {
        super(gui, posX, posY, width, height);
        this.container = container;
        this.guiMachine = gui;
    }

    @Override
    public void init() {
        super.init();
        this.AddUpgradeSlots(this.container, ((MOTileEntityMachine)this.guiMachine.getMachine()).getInventoryContainer());
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float ticks) {
        super.drawBackground(mouseX, mouseY, ticks);
        this.DrawUpgradeStats();
    }

    public void DrawUpgradeStats() {
        HashMap<UpgradeTypes, Double> upgradesMap = new HashMap<UpgradeTypes, Double>();
        IUpgradeHandler upgradeHandler = ((MOTileEntityMachine)this.guiMachine.getMachine()).getUpgradeHandler();
        for (int i = 0; i < this.container.field_75151_b.size(); ++i) {
            ItemStack upgradeItem;
            if (!(this.container.func_75139_a(i) instanceof SlotInventory) || !(((SlotInventory)this.container.func_75139_a(i)).getSlot() instanceof UpgradeSlot) || (upgradeItem = this.container.func_75139_a(i).func_75211_c()) == null || !MatterHelper.isUpgrade(upgradeItem)) continue;
            IUpgrade upgrade = (IUpgrade)upgradeItem.func_77973_b();
            Map<UpgradeTypes, Double> upgradeMap = upgrade.getUpgrades(upgradeItem);
            for (Map.Entry<UpgradeTypes, Double> entry : upgradeMap.entrySet()) {
                double multiply;
                if (!this.guiMachine.getMachine().isAffectedByUpgrade(entry.getKey())) continue;
                double d = multiply = upgradeHandler != null ? upgradeHandler.affectUpgrade(entry.getKey(), entry.getValue()) : entry.getValue().doubleValue();
                if (upgradesMap.containsKey((Object)entry.getKey())) {
                    double previusValue = (Double)upgradesMap.get((Object)entry.getKey());
                    multiply = upgradeHandler.affectUpgrade(entry.getKey(), upgradeHandler != null ? upgradeHandler.affectUpgrade(entry.getKey(), previusValue * multiply) : previusValue * multiply);
                    upgradesMap.put(entry.getKey(), multiply);
                    continue;
                }
                upgradesMap.put(entry.getKey(), multiply);
            }
        }
        ArrayList<String> infos = new ArrayList<String>();
        for (Map.Entry entry : upgradesMap.entrySet()) {
            if (!this.guiMachine.getMachine().isAffectedByUpgrade((UpgradeTypes)((Object)entry.getKey()))) continue;
            infos.add(MOStringHelper.toInfo((UpgradeTypes)((Object)entry.getKey()), (Double)entry.getValue()));
        }
        RenderUtils.DrawMultilineInfo(infos, 76, 78, 100, 300, new Color(255, 255, 255).getColor());
    }

    public void AddUpgradeSlots(Container container, Inventory inventory) {
        int i;
        int upgradeSlotIndex = 0;
        int upgradeCount = 0;
        for (i = 0; i < container.field_75151_b.size(); ++i) {
            if (!(container.func_75139_a(i) instanceof SlotInventory) || !(((SlotInventory)container.func_75139_a(i)).getSlot() instanceof UpgradeSlot)) continue;
            ++upgradeCount;
        }
        for (i = 0; i < container.field_75151_b.size(); ++i) {
            if (!(container.func_75139_a(i) instanceof SlotInventory) || !(((SlotInventory)container.func_75139_a(i)).getSlot() instanceof UpgradeSlot)) continue;
            ElementInventorySlot slotElement = new ElementInventorySlot(this.gui, (MOSlot)((Object)container.field_75151_b.get(i)), 22, 22, "big");
            slotElement.setIcon(inventory.getSlot(((MOSlot)((Object)container.field_75151_b.get(i))).getSlotIndex()).getHoloIcon());
            int xStart = 12 + this.sizeX / 2 - MathHelper.func_76125_a((int)(upgradeCount * 24), (int)0, (int)120) / 2;
            slotElement.setPosition(xStart + upgradeSlotIndex % 5 * 24, 52 + upgradeSlotIndex / 5 * 24);
            this.addElement(slotElement);
            ++upgradeSlotIndex;
        }
    }
}

