/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages.starmap;

import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementShipEntry;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.tile.TileEntityMachineStarMap;

public class PagePlanetStats
extends ElementBaseGroup
implements IListHandler {
    TileEntityMachineStarMap starMap;
    ElementGroupList shipList;

    public PagePlanetStats(GuiStarMap gui, int posX, int posY, int width, int height, TileEntityMachineStarMap starMap) {
        super(gui, posX, posY, width, height);
        this.starMap = starMap;
        this.shipList = new ElementGroupList(gui, this, 16, 16, width, 256);
    }

    @Override
    public void init() {
        super.init();
        this.addElement(this.shipList);
        this.loadShips();
    }

    public void loadShips() {
        this.shipList.init();
        Planet planet = GalaxyClient.getInstance().getTheGalaxy().getPlanet(this.starMap.getGalaxyPosition());
        if (planet != null && !this.starMap.getGalaxyPosition().equals(this.starMap.getDestination())) {
            for (int i = 0; i < planet.getFleet().size(); ++i) {
                this.shipList.addElement(new ElementShipEntry((GuiStarMap)this.gui, this.shipList, 186, 32, planet, planet.getFleet().get(i), i));
            }
        }
        this.shipList.update(0, 0);
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }
}

