/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.client.data.Color;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.guide.IGuideElement;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Element;

public abstract class GuideElementAbstract
implements IGuideElement {
    protected MOGuiBase gui;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int marginTop;
    protected int marginBottom;
    protected int marginLeft;
    protected int marginRight;
    protected int textAlign;
    protected int floating;
    protected Color color;

    @Override
    public void loadElement(MOGuideEntry entry, Element element, Map<String, String> styleSheetMap, int width, int height) {
        Map<String, String> styleMap = this.buildStyleMap(styleSheetMap, element);
        this.loadStyles(entry, element, styleMap, width, height);
        this.loadContent(entry, element, width, height);
        this.calculateDimentions(entry, element, styleMap, width, height);
    }

    protected void loadStyles(MOGuideEntry entry, Element element, Map<String, String> styleMap, int width, int height) {
        this.marginTop = this.getIntFromStyle("margin-top", styleMap, height);
        this.marginBottom = this.getIntFromStyle("margin-bottom", styleMap, height);
        this.marginLeft = this.getIntFromStyle("margin-left", styleMap, width);
        this.marginRight = this.getIntFromStyle("margin-right", styleMap, width);
        this.textAlign = this.calculateTextAlignFromStyle(styleMap);
        this.floating = this.getFloatingFromStyle(styleMap);
        this.color = this.getColorFromStyle(styleMap);
    }

    protected abstract void loadContent(MOGuideEntry var1, Element var2, int var3, int var4);

    protected void calculateDimentions(MOGuideEntry entry, Element element, Map<String, String> styleMap, int parentWidth, int parentHeight) {
        this.width = this.calculateWidth(styleMap, parentWidth);
        if (styleMap.containsKey("height")) {
            this.height = this.getIntFromStyle("height", styleMap, parentHeight);
        }
        if (styleMap.containsKey("min-height")) {
            this.height = Math.min(this.height, this.getIntFromStyle("min-height", styleMap, parentHeight));
        }
        if (styleMap.containsKey("max-height")) {
            this.height = Math.max(this.height, this.getIntFromStyle("max-height", styleMap, parentHeight));
        }
    }

    protected int calculateWidth(Map<String, String> styleMap, int parentWidth) {
        int width = this.width;
        if (this.getFloating() == 0) {
            width = parentWidth;
        }
        if (styleMap.containsKey("width")) {
            width = this.getIntFromStyle("width", styleMap, parentWidth);
        }
        if (styleMap.containsKey("min-width")) {
            width = Math.min(this.width, this.getIntFromStyle("min-width", styleMap, parentWidth));
        }
        if (styleMap.containsKey("max-width")) {
            width = Math.max(this.width, this.getIntFromStyle("max-width", styleMap, parentWidth));
        }
        return width;
    }

    protected Map<String, String> decodeShortcode(String rawShortcode) {
        HashMap<String, String> shortCodeMap = new HashMap<String, String>();
        String[] shortCodeParams = rawShortcode.substring(1, rawShortcode.length() - 1).split(" ");
        if (shortCodeParams.length > 0) {
            shortCodeMap.put("type", shortCodeParams[0]);
        }
        for (int i = 1; i < shortCodeParams.length; ++i) {
            String[] keyValue = shortCodeParams[i].split("=", 2);
            if (keyValue.length < 2) continue;
            shortCodeMap.put(keyValue[0], keyValue[1]);
        }
        return shortCodeMap;
    }

    protected ItemStack shortCodeToStack(Map<String, String> shortCodeMap) {
        Item item;
        String mod = "mo";
        int count = 1;
        int damage = 0;
        if (shortCodeMap.containsKey("mod")) {
            mod = shortCodeMap.get("mod");
        }
        if (shortCodeMap.containsKey("damage")) {
            damage = Integer.parseInt(shortCodeMap.get("damage"));
        }
        if (shortCodeMap.containsKey("count")) {
            count = Integer.parseInt(shortCodeMap.get("Count"));
        }
        if (shortCodeMap.get("type").equalsIgnoreCase("block") && shortCodeMap.containsKey("name")) {
            Block block = GameRegistry.findBlock((String)mod, (String)shortCodeMap.get("name"));
            if (block != null) {
                return new ItemStack(block, count, damage);
            }
        } else if (shortCodeMap.containsKey("name") && (item = GameRegistry.findItem((String)mod, (String)shortCodeMap.get("name"))) != null) {
            return new ItemStack(item, count, damage);
        }
        return null;
    }

    protected void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
    }

    protected FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public Map<String, String> decodeStyle(String styleRaw) {
        String[] lines;
        HashMap<String, String> styleMap = new HashMap<String, String>();
        for (String line : lines = styleRaw.split(";")) {
            String[] vars = line.split(":");
            if (vars.length != 2) continue;
            styleMap.put(vars[0].trim(), vars[1].trim());
        }
        return styleMap;
    }

    public int getIntFromStyle(String key, Map<String, String> styleMap, int max) {
        if (styleMap.containsKey(key)) {
            return this.parseStyleNumber(styleMap.get(key), max);
        }
        return 0;
    }

    public int calculateTextAlignFromStyle(Map<String, String> syleMap) {
        if (syleMap.containsKey("text-align")) {
            if (syleMap.get("text-align").equalsIgnoreCase("center")) {
                return 1;
            }
            if (syleMap.get("text-align").equalsIgnoreCase("right")) {
                return 2;
            }
        }
        return 0;
    }

    public int getFloatingFromStyle(Map<String, String> stringMap) {
        if (stringMap.containsKey("float")) {
            if (stringMap.get("float").equalsIgnoreCase("left")) {
                return 1;
            }
            if (stringMap.get("float").equalsIgnoreCase("right")) {
                // empty if block
            }
            return 2;
        }
        return 0;
    }

    public Color getColorFromStyle(Map<String, String> stringMap) {
        if (stringMap.containsKey("color")) {
            if (stringMap.get("color").startsWith("#")) {
                return new Color(Integer.parseInt(stringMap.get("color").substring(1), 16));
            }
            if (stringMap.get("color").startsWith("rgb(")) {
                String[] rgb = stringMap.get("color").substring(4, stringMap.get("color").length() - 1).split(",");
                if (rgb.length == 3) {
                    return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                }
                if (rgb.length == 4) {
                    return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]), Integer.parseInt(rgb[3]));
                }
            }
        }
        return new Color(255, 255, 255);
    }

    private int parseStyleNumber(String number, int value) {
        if (number.endsWith("px")) {
            try {
                return Integer.parseInt(number.substring(0, number.length() - 2));
            }
            catch (NumberFormatException e) {
                MOLog.log(Level.ERROR, e, "Could not parse Int %s in %s", number.substring(0, number.length() - 2), this);
            }
        } else if (number.endsWith("%")) {
            try {
                return (int)((float)Integer.parseInt(number.substring(0, number.length() - 1)) / 100.0f * (float)value);
            }
            catch (NumberFormatException e) {
                MOLog.log(Level.ERROR, e, "Could not parse Int %s in %s", number.substring(0, number.length() - 1), this);
            }
        }
        return 0;
    }

    public Map<String, String> buildStyleMap(Map<String, String> styleSheetMap, Element element) {
        HashMap<String, String> styleMap = new HashMap<String, String>();
        if (element.hasAttribute("class")) {
            String[] classes = element.getAttribute("class").split(" ");
            for (int i = 0; i < classes.length; ++i) {
                if (!styleSheetMap.containsKey("." + classes[i])) continue;
                styleMap.putAll(this.decodeStyle(styleSheetMap.get("." + classes[i])));
            }
        }
        if (element.hasAttribute("style")) {
            styleMap.putAll(this.decodeStyle(element.getAttribute("style")));
        }
        return styleMap;
    }

    @Override
    public int getFloating() {
        return this.floating;
    }

    @Override
    public int getWidth() {
        return this.width + this.marginLeft + this.marginRight;
    }

    @Override
    public int getHeight() {
        return this.height + this.marginTop + this.marginBottom;
    }

    @Override
    public void setGUI(MOGuiBase gui) {
        this.gui = gui;
    }
}

