/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import matteroverdrive.guide.GuideElementAbstract;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;

public class GuideElementImage
extends GuideElementAbstract {
    ResourceLocation location;
    int imageWidth;
    int imageHeight;

    @Override
    public void drawElement(int width, int mouseX, int mouseY) {
        int maxWidth = width - this.marginLeft - this.marginRight;
        float imageScale = (float)maxWidth / (float)Math.max(this.imageWidth, maxWidth);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3553);
        if (this.location != null) {
            RenderUtils.applyColor(this.color);
            this.bindTexture(this.location);
            int x = 0;
            if (this.textAlign == 1) {
                x = width / 2 - (int)((float)this.imageWidth * imageScale / 2.0f);
            }
            RenderUtils.drawPlane(x + this.marginLeft, this.marginTop, 0.0, (float)this.imageWidth * imageScale, (float)this.imageHeight * imageScale);
        }
    }

    @Override
    protected void loadContent(MOGuideEntry entry, Element element, int width, int height) {
        if (element.hasAttribute("src")) {
            this.location = new ResourceLocation("mo:textures/" + element.getAttribute("src"));
        }
        if (element.hasAttribute("width")) {
            this.imageWidth = Integer.parseInt(element.getAttribute("width"));
        }
        if (element.hasAttribute("height")) {
            this.imageHeight = Integer.parseInt(element.getAttribute("height"));
        }
        this.height = this.imageHeight;
        this.width = this.imageWidth;
    }
}

