/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.EnumSet;
import matteroverdrive.api.events.MOEventTransport;
import matteroverdrive.api.events.anomaly.MOEventGravitationalAnomalyConsume;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.entity.player.MOExtendedProperties;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EntityHandler {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            if (AndroidPlayer.get((EntityPlayer)event.entity) == null) {
                AndroidPlayer.register((EntityPlayer)event.entity);
            }
            if (MOExtendedProperties.get((EntityPlayer)event.entity) == null) {
                MOExtendedProperties.register((EntityPlayer)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        AndroidPlayer androidPlayer;
        if (event.entityLiving instanceof EntityPlayer && (androidPlayer = AndroidPlayer.get((EntityPlayer)event.entityLiving)).isAndroid()) {
            androidPlayer.onEntityFall(event);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            AndroidPlayer.get((EntityPlayer)event.entity).sync(EnumSet.allOf(AndroidPlayer.DataType.class));
            MOExtendedProperties.get((EntityPlayer)event.entity).sync(EnumSet.allOf(PlayerQuestData.DataType.class));
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        AndroidPlayer androidPlayer;
        if (event.entityLiving instanceof EntityPlayer && (androidPlayer = AndroidPlayer.get((EntityPlayer)event.entityLiving)) != null && androidPlayer.isAndroid()) {
            androidPlayer.onEntityJump(event);
            androidPlayer.triggerEventOnStats((LivingEvent)event);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        AndroidPlayer newAndroidPlayer = AndroidPlayer.get(event.entityPlayer);
        AndroidPlayer oldAndroidPlayer = AndroidPlayer.get(event.original);
        if (newAndroidPlayer != null && oldAndroidPlayer != null) {
            newAndroidPlayer.copy(oldAndroidPlayer);
            if (event.wasDeath) {
                newAndroidPlayer.onPlayerRespawn();
            }
            newAndroidPlayer.sync(EnumSet.allOf(AndroidPlayer.DataType.class));
        }
        MOExtendedProperties newExtendedProperties = MOExtendedProperties.get(event.entityPlayer);
        MOExtendedProperties oldExtenderDProperties = MOExtendedProperties.get(event.original);
        if (newExtendedProperties != null && oldExtenderDProperties != null) {
            newExtendedProperties.copy(oldExtenderDProperties);
            newExtendedProperties.sync(EnumSet.allOf(PlayerQuestData.DataType.class));
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            AndroidPlayer.get((EntityPlayer)event.entityLiving).triggerEventOnStats((LivingEvent)event);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent deathEvent) {
        if (deathEvent.source != null && deathEvent.source.func_76346_g() instanceof EntityPlayer) {
            MOExtendedProperties extendedProperties = MOExtendedProperties.get((EntityPlayer)deathEvent.source.func_76346_g());
            extendedProperties.onEvent((Event)deathEvent);
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        AndroidPlayer androidPlayer;
        if (event.entityLiving instanceof EntityPlayer && (androidPlayer = AndroidPlayer.get((EntityPlayer)event.entityLiving)).isAndroid()) {
            androidPlayer.onEntityHurt(event);
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup(EntityItemPickupEvent event) {
        if (event.entityPlayer != null) {
            MOExtendedProperties extendedProperties;
            if (event.item.func_92059_d() != null && MatterHelper.containsMatter(event.item.func_92059_d())) {
                for (int i = 0; i < 9; ++i) {
                    if (event.entityPlayer.field_71071_by.func_70301_a(i) == null || event.entityPlayer.field_71071_by.func_70301_a(i).func_77973_b() != MatterOverdriveItems.portableDecomposer) continue;
                    MatterOverdriveItems.portableDecomposer.decomposeItem(event.entityPlayer.field_71071_by.func_70301_a(i), event.item.func_92059_d());
                }
            }
            if ((extendedProperties = MOExtendedProperties.get(event.entityPlayer)) != null) {
                extendedProperties.onEvent((Event)event);
            }
        }
    }

    @SubscribeEvent
    public void onEntityTransport(MOEventTransport eventTransport) {
        MOExtendedProperties extendedProperties;
        if (eventTransport.entity instanceof EntityPlayer && (extendedProperties = MOExtendedProperties.get((EntityPlayer)eventTransport.entity)) != null) {
            extendedProperties.onEvent((Event)eventTransport);
        }
    }

    @SubscribeEvent
    public void onEntityAnomalyConsume(MOEventGravitationalAnomalyConsume.Post event) {
        MOExtendedProperties extendedProperties;
        if (event.entity instanceof EntityPlayer && (extendedProperties = MOExtendedProperties.get((EntityPlayer)event.entity)) != null) {
            extendedProperties.onEvent(event);
        }
    }
}

