/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.container.ContainerAndroidSpawner;
import matteroverdrive.container.ContainerAndroidStation;
import matteroverdrive.container.ContainerFactory;
import matteroverdrive.container.ContainerFusionReactor;
import matteroverdrive.container.ContainerInscriber;
import matteroverdrive.container.ContainerPatternMonitor;
import matteroverdrive.container.ContainerReplicator;
import matteroverdrive.container.ContainerSolarPanel;
import matteroverdrive.container.ContainerStarMap;
import matteroverdrive.container.ContainerWeaponStation;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.gui.GuiAndroidSpawner;
import matteroverdrive.gui.GuiAndroidStation;
import matteroverdrive.gui.GuiChargingStation;
import matteroverdrive.gui.GuiContractMarket;
import matteroverdrive.gui.GuiDecomposer;
import matteroverdrive.gui.GuiFusionReactor;
import matteroverdrive.gui.GuiHoloSign;
import matteroverdrive.gui.GuiInscriber;
import matteroverdrive.gui.GuiMatterAnalyzer;
import matteroverdrive.gui.GuiNetworkRouter;
import matteroverdrive.gui.GuiNetworkSwitch;
import matteroverdrive.gui.GuiPatternMonitor;
import matteroverdrive.gui.GuiPatternStorage;
import matteroverdrive.gui.GuiRecycler;
import matteroverdrive.gui.GuiReplicator;
import matteroverdrive.gui.GuiSolarPanel;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.GuiTransporter;
import matteroverdrive.gui.GuiWeaponStation;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.analyzer.TileEntityMachineMatterAnalyzer;
import matteroverdrive.machines.fusionReactorController.TileEntityMachineFusionReactorController;
import matteroverdrive.machines.transporter.TileEntityMachineTransporter;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.tile.TileEntityAndroidSpawner;
import matteroverdrive.tile.TileEntityAndroidStation;
import matteroverdrive.tile.TileEntityHoloSign;
import matteroverdrive.tile.TileEntityInscriber;
import matteroverdrive.tile.TileEntityMachineChargingStation;
import matteroverdrive.tile.TileEntityMachineContractMarket;
import matteroverdrive.tile.TileEntityMachineDecomposer;
import matteroverdrive.tile.TileEntityMachineMatterRecycler;
import matteroverdrive.tile.TileEntityMachineNetworkRouter;
import matteroverdrive.tile.TileEntityMachineNetworkSwitch;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import matteroverdrive.tile.TileEntityMachinePatternStorage;
import matteroverdrive.tile.TileEntityMachineReplicator;
import matteroverdrive.tile.TileEntityMachineSolarPanel;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.tile.TileEntityWeaponStation;
import matteroverdrive.util.MOLog;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    private Map<Class<? extends MOTileEntity>, Class<? extends MOGuiBase>> tileEntityGuiList = new HashMap<Class<? extends MOTileEntity>, Class<? extends MOGuiBase>>();
    private Map<Class<? extends MOTileEntity>, Class<? extends MOBaseContainer>> tileEntityContainerList = new HashMap<Class<? extends MOTileEntity>, Class<? extends MOBaseContainer>>();

    public void register(Side side) {
        if (side == Side.SERVER) {
            this.registerContainer(TileEntityMachineSolarPanel.class, ContainerSolarPanel.class);
            this.registerContainer(TileEntityWeaponStation.class, ContainerWeaponStation.class);
            this.registerContainer(TileEntityMachineFusionReactorController.class, ContainerFusionReactor.class);
            this.registerContainer(TileEntityAndroidStation.class, ContainerAndroidStation.class);
            this.registerContainer(TileEntityMachineStarMap.class, ContainerStarMap.class);
            this.registerContainer(TileEntityInscriber.class, ContainerInscriber.class);
            this.registerContainer(TileEntityAndroidSpawner.class, ContainerAndroidSpawner.class);
            this.registerContainer(TileEntityMachineReplicator.class, ContainerReplicator.class);
            this.registerContainer(TileEntityMachinePatternMonitor.class, ContainerPatternMonitor.class);
        } else {
            this.registerGuiAndContainer(TileEntityMachineReplicator.class, GuiReplicator.class, ContainerReplicator.class);
            this.registerGui(TileEntityMachineDecomposer.class, GuiDecomposer.class);
            this.registerGui(TileEntityMachineNetworkRouter.class, GuiNetworkRouter.class);
            this.registerGui(TileEntityMachineMatterAnalyzer.class, GuiMatterAnalyzer.class);
            this.registerGui(TileEntityMachinePatternStorage.class, GuiPatternStorage.class);
            this.registerGuiAndContainer(TileEntityMachineSolarPanel.class, GuiSolarPanel.class, ContainerSolarPanel.class);
            this.registerGuiAndContainer(TileEntityWeaponStation.class, GuiWeaponStation.class, ContainerWeaponStation.class);
            this.registerGuiAndContainer(TileEntityMachinePatternMonitor.class, GuiPatternMonitor.class, ContainerPatternMonitor.class);
            this.registerGui(TileEntityMachineNetworkSwitch.class, GuiNetworkSwitch.class);
            this.registerGui(TileEntityMachineTransporter.class, GuiTransporter.class);
            this.registerGui(TileEntityMachineMatterRecycler.class, GuiRecycler.class);
            this.registerGuiAndContainer(TileEntityMachineFusionReactorController.class, GuiFusionReactor.class, ContainerFusionReactor.class);
            this.registerGuiAndContainer(TileEntityAndroidStation.class, GuiAndroidStation.class, ContainerAndroidStation.class);
            this.registerGuiAndContainer(TileEntityMachineStarMap.class, GuiStarMap.class, ContainerStarMap.class);
            this.registerGui(TileEntityHoloSign.class, GuiHoloSign.class);
            this.registerGui(TileEntityMachineChargingStation.class, GuiChargingStation.class);
            this.registerGuiAndContainer(TileEntityInscriber.class, GuiInscriber.class, ContainerInscriber.class);
            this.registerGui(TileEntityMachineContractMarket.class, GuiContractMarket.class);
            this.registerGuiAndContainer(TileEntityAndroidSpawner.class, GuiAndroidSpawner.class, ContainerAndroidSpawner.class);
        }
    }

    public void registerContainer(Class<? extends MOTileEntity> tileEntity, Class<? extends MOBaseContainer> container) {
        this.tileEntityContainerList.put(tileEntity, container);
    }

    public void registerGuiAndContainer(Class<? extends MOTileEntity> tileEntity, Class<? extends MOGuiBase> gui, Class<? extends MOBaseContainer> container) {
        this.tileEntityContainerList.put(tileEntity, container);
        this.tileEntityGuiList.put(tileEntity, gui);
    }

    public void registerGui(Class<? extends MOTileEntity> tileEntity, Class<? extends MOGuiBase> gui) {
        this.tileEntityGuiList.put(tileEntity, gui);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity entity = world.func_147438_o(x, y, z);
        switch (ID) {
            default: 
        }
        if (entity != null && this.tileEntityContainerList.containsKey(entity.getClass())) {
            try {
                Constructor<?>[] constructors;
                Class<? extends MOBaseContainer> containerClass = this.tileEntityContainerList.get(entity.getClass());
                for (Constructor<?> constructor : constructors = containerClass.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 2 || !parameterTypes[0].isInstance(player.field_71071_by) || !parameterTypes[1].isInstance(entity)) continue;
                    this.onContainerOpen(entity, Side.SERVER);
                    return constructor.newInstance(player.field_71071_by, entity);
                }
            }
            catch (InvocationTargetException e) {
                MOLog.warn("Could not call TileEntity constructor in server GUI handler", e);
            }
            catch (InstantiationException e) {
                MOLog.warn("Could not instantiate TileEntity in server GUI handler", e);
            }
            catch (IllegalAccessException e) {
                MOLog.warn("Could not access TileEntity constructor in server GUI handler", e);
            }
        } else if (entity instanceof MOTileEntityMachine) {
            return ContainerFactory.createMachineContainer((MOTileEntityMachine)entity, player.field_71071_by);
        }
        return null;
    }

    private void onContainerOpen(TileEntity entity, Side side) {
        if (entity instanceof MOTileEntityMachine) {
            ((MOTileEntityMachine)entity).onContainerOpen(side);
        }
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity entity = world.func_147438_o(x, y, z);
        switch (ID) {
            default: 
        }
        if (this.tileEntityGuiList.containsKey(entity.getClass())) {
            try {
                Constructor<?>[] constructors;
                Class<? extends MOGuiBase> containerClass = this.tileEntityGuiList.get(entity.getClass());
                for (Constructor<?> constructor : constructors = containerClass.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 2 || !parameterTypes[0].isInstance(player.field_71071_by) || !parameterTypes[1].isInstance(entity)) continue;
                    this.onContainerOpen(entity, Side.CLIENT);
                    return constructor.newInstance(player.field_71071_by, entity);
                }
            }
            catch (InvocationTargetException e) {
                MOLog.warn("Could not call TileEntity constructor in client GUI handler", e);
            }
            catch (InstantiationException e) {
                MOLog.warn("Could not instantiate the TileEntity in client GUI handler", e);
            }
            catch (IllegalAccessException e) {
                MOLog.warn("Could not access TileEntity constructor in client GUI handler", new Object[0]);
            }
        } else if (entity instanceof MOTileEntityMachine) {
            return new MOGuiMachine<MOTileEntityMachine>(ContainerFactory.createMachineContainer((MOTileEntityMachine)entity, player.field_71071_by), (MOTileEntityMachine)entity);
        }
        return null;
    }
}

